/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.test;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.jobmanager.NodeLocationMessage;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.test.CommTestException;
import com.mathworks.toolbox.distcomp.test.CommTestInfo;
import com.mathworks.toolbox.distcomp.test.CommunicationErrorMessage;
import com.mathworks.toolbox.distcomp.test.PackageInfo;
import com.mathworks.toolbox.distcomp.test.TestErrorCode;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.ErrorPrinter;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.rmi.RemoteException;
import java.rmi.ServerException;
import java.util.logging.Level;

public final class TwoWayCommTester {
    private static final String TEST_ERROR_KEY = "TEST_ERROR";

    private TwoWayCommTester() {
    }

    public static boolean testTwoWayCommunication(JobManagerLocal jobManagerLocal, CommTestInfo commTestInfo) {
        if (jobManagerLocal == null) {
            TwoWayCommTester.logNullJobManagerTestFailure(DistcompLevel.ONE, "testTwoWayCommunication");
            return false;
        }
        try {
            jobManagerLocal.testCommunicationWithClient(commTestInfo);
            TwoWayCommTester.logTestSuccess(DistcompLevel.FOUR, "testTwoWayCommunication", jobManagerLocal);
        }
        catch (RemoteException remoteException) {
            TwoWayCommTester.logTestFailure(DistcompLevel.ONE, "testTwoWayCommunication", jobManagerLocal, remoteException);
            return false;
        }
        return true;
    }

    public static boolean testTwoWayDataStoreCommunication(JobManagerLocal jobManagerLocal) {
        if (jobManagerLocal == null) {
            TwoWayCommTester.logNullJobManagerTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunication");
            return false;
        }
        try {
            jobManagerLocal.testTwoWayDataStoreCommunication();
            TwoWayCommTester.logTestSuccess(DistcompLevel.FOUR, "testTwoWayDataStoreCommunication", jobManagerLocal);
        }
        catch (RemoteException remoteException) {
            TwoWayCommTester.logTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunication", jobManagerLocal, remoteException);
            return false;
        }
        catch (MJSException mJSException) {
            TwoWayCommTester.logTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunication", jobManagerLocal, mJSException);
            return false;
        }
        return true;
    }

    public static TestResult testTwoWayDataStoreCommunicationAndReturnResult(JobManagerLocal jobManagerLocal) {
        if (jobManagerLocal == null) {
            TwoWayCommTester.logNullJobManagerTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunicationAndReturnResult");
            return new TestResult(false);
        }
        try {
            jobManagerLocal.testTwoWayDataStoreCommunication();
            TwoWayCommTester.logTestSuccess(DistcompLevel.FOUR, "testTwoWayDataStoreCommunicationAndReturnResult", jobManagerLocal);
        }
        catch (RemoteException remoteException) {
            TwoWayCommTester.logTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunicationAndReturnResult", jobManagerLocal, remoteException);
            return new TestResult(false, TwoWayCommTester.createTestResultMessage(jobManagerLocal, remoteException));
        }
        catch (MJSException mJSException) {
            TwoWayCommTester.logTestFailure(DistcompLevel.ONE, "testTwoWayDataStoreCommunicationAndReturnResult", jobManagerLocal, mJSException);
            return new TestResult(false, mJSException.getMessage());
        }
        return new TestResult(true);
    }

    private static String createTestResultMessage(JobManagerLocal jobManagerLocal, RemoteException remoteException) {
        PrintStream printStream;
        Charset charset = Charset.forName("UTF-16");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            printStream = new PrintStream((OutputStream)byteArrayOutputStream, false, charset.name());
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)("Encoding: " + charset + " not supported, caused by:\n" + unsupportedEncodingException));
        }
        try {
            TwoWayCommTester.printCommErrorMessage(new ErrorPrinterImpl(printStream), jobManagerLocal, remoteException);
            String string = byteArrayOutputStream.toString(charset.name());
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)("Encoding: " + charset + " not supported, caused by:\n" + unsupportedEncodingException));
        }
        finally {
            printStream.close();
        }
    }

    private static void logTestSuccess(Level level, String string, JobManagerLocal jobManagerLocal) {
        String string2 = jobManagerLocal.getName() + "@" + jobManagerLocal.getHostName();
        PackageInfo.LOGGER.log(level, string + " to " + string2 + " succeeded.");
    }

    private static void logTestFailure(Level level, String string, JobManagerLocal jobManagerLocal, Throwable throwable) {
        String string2 = jobManagerLocal.getName() + "@" + jobManagerLocal.getHostName();
        PackageInfo.LOGGER.log(level, string + " to " + string2 + " failed.", throwable);
    }

    private static void logNullJobManagerTestFailure(Level level, String string) {
        PackageInfo.LOGGER.log(level, string + " failed because it was passed a null job manager.");
    }

    private static void printCommErrorMessage(ErrorPrinter errorPrinter, JobManagerLocal jobManagerLocal, RemoteException remoteException) {
        String string;
        DistcompTesterException distcompTesterException;
        if (remoteException instanceof ServerException && remoteException.getCause() instanceof DistcompException) {
            Throwable throwable = remoteException.getCause().getCause();
            if (throwable instanceof CommTestException) {
                throwable = throwable.getCause();
            }
            distcompTesterException = new DistcompTesterException(throwable);
            string = TwoWayCommTester.commFromJobManagerMessage(jobManagerLocal);
        } else {
            distcompTesterException = new DistcompTesterException(remoteException);
            string = TwoWayCommTester.commToJobManagerMessage(jobManagerLocal);
        }
        errorPrinter.printError(string, distcompTesterException);
    }

    private static String commToJobManagerMessage(JobManagerLocal jobManagerLocal) {
        NodeLocationMessage nodeLocationMessage = new NodeLocationMessage();
        CommToJobManagerMessage commToJobManagerMessage = new CommToJobManagerMessage(jobManagerLocal.getHostName(), jobManagerLocal.getLookupURL(), nodeLocationMessage.clientLocationMessage(), nodeLocationMessage.jobManagerLocationMessage(jobManagerLocal.getName(), jobManagerLocal.getHostName(), jobManagerLocal.getAllHostAddresses()));
        return commToJobManagerMessage.getLocalizedMessage();
    }

    private static String commFromJobManagerMessage(JobManagerLocal jobManagerLocal) {
        NodeLocationMessage nodeLocationMessage = new NodeLocationMessage();
        CommFromJobManagerMessage commFromJobManagerMessage = new CommFromJobManagerMessage(jobManagerLocal.getDataStoreMinLimit(), jobManagerLocal.getHostName(), nodeLocationMessage.clientLocationMessage(), nodeLocationMessage.jobManagerLocationMessage(jobManagerLocal.getName(), jobManagerLocal.getHostName(), jobManagerLocal.getAllHostAddresses()));
        return commFromJobManagerMessage.getLocalizedMessage();
    }

    private static class CommFromJobManagerMessage
    extends CommunicationErrorMessage {
        CommFromJobManagerMessage(long l, String string, String string2, String string3) {
            super(TestErrorCode.CommFromJMMessage, l, string, string2, string3);
        }
    }

    private static class CommToJobManagerMessage
    extends CommunicationErrorMessage {
        CommToJobManagerMessage(String string, String string2, String string3, String string4) {
            super(TestErrorCode.CommToJMMessage, string, string2, string3, string4);
        }
    }

    private static class DistcompTesterException
    extends DistcompDiagnosticException {
        DistcompTesterException(Throwable throwable) {
            super(throwable, TwoWayCommTester.TEST_ERROR_KEY, new Object[0]);
        }
    }

    public static class TestResult {
        private final boolean fSuccess;
        private final String fErrorMessage;

        TestResult(boolean bl) {
            this.fSuccess = bl;
            this.fErrorMessage = null;
        }

        TestResult(boolean bl, String string) {
            this.fSuccess = bl;
            this.fErrorMessage = string;
        }

        public boolean isSuccess() {
            return this.fSuccess;
        }

        public String getErrorMessage() {
            return this.fErrorMessage;
        }
    }
}

