/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.test;

import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.nio.charset.Charset;

public class SocketTester {
    private static final Charset ENCODING = Charset.forName("UTF-8");
    private static final String ANSWER_YES = "yes";
    private static final String ANSWER_NO = "no";
    private static final String START_SOCKET_LISTENER_QUESTION = "Do you want to start a socket listener on this computer? (yes/no)";
    private static final String OPEN_SOCKET_QUESTION = "Do you want to connect to a socket listener on another computer? (yes/no)";
    private static final String SOCKET_LISTENER_HOST_PROMPT = "Enter the hostname or IP address by which this computer is known on your network.";
    private static final String SOCKET_LISTENER_PORT_PROMPT = "Enter the port on which you want to start a socket listener on this computer.";
    private static final String SOCKET_DESTINATION_HOST_PROMPT = "Enter the hostname or IP address of the computer to which you want to connect.";
    private static final String SOCKET_DESTINATION_PORT_PROMPT = "Enter the port on the computer to which you want to connect.";

    private SocketTester() {
    }

    public static void startSocketListener(String string, int n) {
        try {
            ServerSocket serverSocket = new ServerSocket();
            InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n);
            serverSocket.bind(inetSocketAddress);
            Socket socket = serverSocket.accept();
            System.out.println("\nSuccessfully received a TCP connection from the computer with IP address " + socket.getInetAddress().getHostAddress() + ".\n");
        }
        catch (IOException iOException) {
            new ErrorPrinterImpl().printError(iOException);
        }
    }

    public static void openSocket(String string, int n) {
        try {
            new Socket(string, n);
            System.out.println("\nSuccessfully opened a TCP socket to host " + string + " at port " + n + ".\n");
        }
        catch (IOException iOException) {
            new ErrorPrinterImpl().printError(iOException);
        }
    }

    public static void main(String[] stringArray) {
        try {
            System.setOut(new PrintStream((OutputStream)System.out, false, ENCODING.name()));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalStateException(unsupportedEncodingException);
        }
        System.out.println("\nThis program allows you to test communication between two computers.\nYou can either start a socket listener on this computer or connect to\na socket listener running on another computer.\n");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in, ENCODING));){
            boolean bl = SocketTester.isAnswerYes(bufferedReader, START_SOCKET_LISTENER_QUESTION);
            System.out.println();
            if (bl) {
                String string = InetAddress.getLocalHost().getHostName();
                System.out.print("Enter the hostname or IP address by which this computer is known on your network.\n[" + string + "]  ");
                String string2 = SocketTester.readHost(bufferedReader);
                string2 = string2.equals("") ? string : string2;
                System.out.println();
                System.out.println(SOCKET_LISTENER_PORT_PROMPT);
                int n = SocketTester.readPort(bufferedReader);
                System.out.println("\nWaiting for a TCP connection on host " + string2 + " at port " + n + ".\n");
                SocketTester.startSocketListener(string2, n);
            } else {
                boolean bl2 = SocketTester.isAnswerYes(bufferedReader, OPEN_SOCKET_QUESTION);
                if (bl2) {
                    System.out.println();
                    System.out.println(SOCKET_DESTINATION_HOST_PROMPT);
                    String string = SocketTester.readHost(bufferedReader);
                    System.out.println();
                    System.out.println(SOCKET_DESTINATION_PORT_PROMPT);
                    int n = SocketTester.readPort(bufferedReader);
                    System.out.println();
                    SocketTester.openSocket(string, n);
                }
            }
        }
        catch (IOException iOException) {
            new ErrorPrinterImpl().printError(iOException);
        }
    }

    private static boolean isAnswerYes(BufferedReader bufferedReader, String string) throws IOException {
        boolean bl;
        String string2 = null;
        while (true) {
            System.out.println(string);
            string2 = SocketTester.readWordFromUser(bufferedReader);
            if (string2.equalsIgnoreCase(ANSWER_YES)) {
                bl = true;
                break;
            }
            if (string2.equalsIgnoreCase(ANSWER_NO)) {
                bl = false;
                break;
            }
            System.out.println("Please answer yes or no.");
        }
        return bl;
    }

    private static String readHost(BufferedReader bufferedReader) throws IOException {
        String string = SocketTester.readWordFromUser(bufferedReader);
        if (string.equals("")) {
            return string;
        }
        try {
            new URL("http://" + string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IOException("Invalid host provided: " + string);
        }
        return string;
    }

    private static int readPort(BufferedReader bufferedReader) throws IOException {
        int n = SocketTester.readIntFromUser(bufferedReader);
        if (n < 1 || n > 65535) {
            throw new IOException("Port was not between 1 and 65535.");
        }
        return n;
    }

    private static String readWordFromUser(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        if (string == null) {
            string = "";
        }
        return string.trim();
    }

    private static int readIntFromUser(BufferedReader bufferedReader) throws IOException {
        String string = SocketTester.readWordFromUser(bufferedReader);
        return Integer.parseInt(string);
    }
}

