/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage.cloud;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.resources.parallel.cluster.webservices;
import com.mathworks.toolbox.distcomp.auth.credentials.CredentialRole;
import com.mathworks.toolbox.distcomp.auth.credentials.LoginTokenCredentials;
import com.mathworks.toolbox.distcomp.auth.credentials.UserCredentials;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.storage.DataNotFoundException;
import com.mathworks.toolbox.distcomp.storage.DataStorageException;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.storage.IncorrectStateToDemoteJobException;
import com.mathworks.toolbox.distcomp.storage.IncorrectStateToPromoteJobException;
import com.mathworks.toolbox.distcomp.storage.PackageInfo;
import com.mathworks.toolbox.distcomp.storage.ReadJobsException;
import com.mathworks.toolbox.distcomp.storage.ReadTasksException;
import com.mathworks.toolbox.distcomp.storage.StorageErrorCode;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.StorageHelpers;
import com.mathworks.toolbox.distcomp.storage.WorkUnitNotFoundException;
import com.mathworks.toolbox.distcomp.storage.WorkUnitStorageException;
import com.mathworks.toolbox.distcomp.util.Pair;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedMessageCreator;
import com.mathworks.toolbox.distcomp.util.i18n.I18nRuntimeException;
import com.mathworks.toolbox.distcomp.workunit.JobIDAndMLType;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitStateException;
import com.mathworks.webservices.mjs.CloudMJSClient;
import com.mathworks.webservices.mjs.CloudMJSDataAccess;
import com.mathworks.webservices.mjs.CloudMJSJobAccess;
import com.mathworks.webservices.mjs.CloudMJSQueueAccess;
import com.mathworks.webservices.mjs.CloudMJSTaskAccess;
import com.mathworks.webservices.mjs.exception.AuthenticationException;
import com.mathworks.webservices.mjs.exception.QuotaExceededException;
import com.mathworks.webservices.mjs.exception.ResourceExistsException;
import com.mathworks.webservices.mjs.exception.ResourceNotFoundException;
import com.mathworks.webservices.mjs.exception.ServiceException;
import com.mathworks.webservices.mjs.exception.SessionException;
import com.mathworks.webservices.mjs.model.CloudMJSErrorCode;
import com.mathworks.webservices.mjs.model.ErrorReturn;
import com.mathworks.webservices.mjs.model.data.CloudDataMetadata;
import com.mathworks.webservices.mjs.model.job.CloudJob;
import com.mathworks.webservices.mjs.model.job.CloudJobMetadata;
import com.mathworks.webservices.mjs.model.request.CloudDataCloneRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataCreateRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataFullReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataFullUpdateRequest;
import com.mathworks.webservices.mjs.model.request.CloudDataRemoveRequest;
import com.mathworks.webservices.mjs.model.request.CloudJobCreateRequest;
import com.mathworks.webservices.mjs.model.request.CloudJobMetadataReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudJobReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudJobRemoveRequest;
import com.mathworks.webservices.mjs.model.request.CloudJobUpdateRequest;
import com.mathworks.webservices.mjs.model.request.CloudLoginRequest;
import com.mathworks.webservices.mjs.model.request.CloudLogoutRequest;
import com.mathworks.webservices.mjs.model.request.CloudQueueDemoteRequest;
import com.mathworks.webservices.mjs.model.request.CloudQueuePromoteRequest;
import com.mathworks.webservices.mjs.model.request.CloudTaskCreateRequest;
import com.mathworks.webservices.mjs.model.request.CloudTaskMetadataReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudTaskReadRequest;
import com.mathworks.webservices.mjs.model.request.CloudTaskRemoveRequest;
import com.mathworks.webservices.mjs.model.request.CloudTaskUpdateRequest;
import com.mathworks.webservices.mjs.model.response.CloudDataCloneResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataCreateResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataFullReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataFullUpdateResponse;
import com.mathworks.webservices.mjs.model.response.CloudDataRemoveResponse;
import com.mathworks.webservices.mjs.model.response.CloudJobCreateResponse;
import com.mathworks.webservices.mjs.model.response.CloudJobMetadataReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudJobReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudJobRemoveResponse;
import com.mathworks.webservices.mjs.model.response.CloudJobUpdateResponse;
import com.mathworks.webservices.mjs.model.response.CloudQueueDemoteResponse;
import com.mathworks.webservices.mjs.model.response.CloudQueuePromoteResponse;
import com.mathworks.webservices.mjs.model.response.CloudTaskCreateResponse;
import com.mathworks.webservices.mjs.model.response.CloudTaskMetadataReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudTaskReadResponse;
import com.mathworks.webservices.mjs.model.response.CloudTaskRemoveResponse;
import com.mathworks.webservices.mjs.model.response.CloudTaskUpdateResponse;
import com.mathworks.webservices.mjs.model.task.CloudTask;
import com.mathworks.webservices.mjs.model.task.CloudTaskMetadata;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public final class CloudStorage
implements DatabaseStorage {
    private final CloudMJSClient fClient;
    private AtomicReference<String> fLoginToken = new AtomicReference();
    private final CloudMJSDataAccess fDataAccess;
    private final CloudMJSJobAccess fJobAccess;
    private final CloudMJSTaskAccess fTaskAccess;
    private final CloudMJSQueueAccess fQueueAccess;

    public CloudStorage(CloudMJSClient cloudMJSClient, String string) {
        this.fClient = cloudMJSClient;
        this.fDataAccess = cloudMJSClient.getDataAccess();
        this.fJobAccess = cloudMJSClient.getJobAccess();
        this.fTaskAccess = cloudMJSClient.getTaskAccess();
        this.fQueueAccess = cloudMJSClient.getQueueAccess();
        this.fLoginToken.set(string);
    }

    @Override
    public void updateData(Uuid uuid, InputStream inputStream, int n) throws StorageException {
        this.appendOrUpdateData(uuid, inputStream, n, false);
    }

    @Override
    public int readData(Uuid uuid, OutputStream outputStream, int n) throws StorageException {
        CloudDataFullReadResponse cloudDataFullReadResponse = this.makeReadDataRequest(uuid, outputStream);
        long l = cloudDataFullReadResponse.getContentLength();
        assert (l == (long)n) : "Amount of data returned from GDS does not equal requested amount.";
        assert (l <= Integer.MAX_VALUE);
        return (int)l;
    }

    @Override
    public byte[] readData(Uuid uuid) throws StorageException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CloudDataFullReadResponse cloudDataFullReadResponse = this.makeReadDataRequest(uuid, byteArrayOutputStream);
        long l = cloudDataFullReadResponse.getContentLength();
        assert (l <= Integer.MAX_VALUE);
        return byteArrayOutputStream.toByteArray();
    }

    private CloudDataFullReadResponse makeReadDataRequest(Uuid uuid, OutputStream outputStream) throws StorageException {
        final CloudDataFullReadRequest cloudDataFullReadRequest = new CloudDataFullReadRequest().withUuid(uuid.toString()).withOutputStream(outputStream);
        try {
            return this.makeRequestAndRetry(new StorageInvokable<CloudDataFullReadResponse>(){

                @Override
                public CloudDataFullReadResponse invoke() {
                    return CloudStorage.this.fDataAccess.fullRead(cloudDataFullReadRequest);
                }
            });
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            throw new GDSDataNotFoundException((Exception)((Object)resourceNotFoundException));
        }
    }

    @Override
    public void removeData(Uuid uuid) throws StorageException {
        CloudDataMetadata cloudDataMetadata = new CloudDataMetadata().withUuid(uuid.toString());
        final CloudDataRemoveRequest cloudDataRemoveRequest = new CloudDataRemoveRequest().withCloudDataMetadata(new CloudDataMetadata[]{cloudDataMetadata});
        CloudDataRemoveResponse cloudDataRemoveResponse = this.makeRequestAndRetry(new StorageInvokable<CloudDataRemoveResponse>(){

            @Override
            public CloudDataRemoveResponse invoke() {
                return CloudStorage.this.fDataAccess.remove(cloudDataRemoveRequest);
            }
        });
        List list = cloudDataRemoveResponse.getRemovedUuids();
        assert (list.size() == 1) : "Removed incorrect amount of data, requested 1, but removed: " + list.size();
    }

    @Override
    public Uuid copyData(Uuid uuid) throws StorageException {
        Uuid uuid2 = UuidFactory.generate();
        CloudDataMetadata cloudDataMetadata = new CloudDataMetadata().withUuid(uuid2.toString());
        final CloudDataCloneRequest cloudDataCloneRequest = new CloudDataCloneRequest().withOriginalDataUuid(uuid.toString()).withCloneDataMetadata(new CloudDataMetadata[]{cloudDataMetadata});
        CloudDataCloneResponse cloudDataCloneResponse = this.makeRequestAndRetry(new StorageInvokable<CloudDataCloneResponse>(){

            @Override
            public CloudDataCloneResponse invoke() {
                return CloudStorage.this.fDataAccess.clone(cloudDataCloneRequest);
            }
        });
        List list = cloudDataCloneResponse.getClonedData();
        List list2 = cloudDataCloneResponse.getErrors();
        if (!list2.isEmpty()) {
            assert (list2.size() == 1);
            throw new CloneDataException(this.extractAndLogErrorMessage((ErrorReturn)list2.get(0), "Failed to clone data."));
        }
        assert (list.size() == 1) : "Cloned incorrect amount of data, requested 1, got: " + list.size();
        Uuid uuid3 = UuidFactory.create((String)((CloudDataMetadata)list.get(0)).getUuid());
        assert (uuid3.equals((Object)uuid2));
        return uuid2;
    }

    @Override
    public void appendToData(Uuid uuid, InputStream inputStream, int n) throws StorageException {
        this.appendOrUpdateData(uuid, inputStream, n, true);
    }

    private void appendOrUpdateData(Uuid uuid, InputStream inputStream, int n, boolean bl) throws StorageException {
        final CloudDataFullUpdateRequest cloudDataFullUpdateRequest = new CloudDataFullUpdateRequest().withAppend(Boolean.valueOf(bl)).withContent(inputStream).withContentLength(Long.valueOf(n)).withUuid(uuid.toString());
        try {
            this.makeRequestAndRetry(new StorageInvokable<CloudDataFullUpdateResponse>(){

                @Override
                public CloudDataFullUpdateResponse invoke() {
                    return CloudStorage.this.fDataAccess.fullUpdate(cloudDataFullUpdateRequest);
                }
            });
        }
        catch (ResourceNotFoundException resourceNotFoundException) {
            throw new GDSDataNotFoundException((Exception)((Object)resourceNotFoundException));
        }
    }

    @Override
    public void putTaskData(Uuid uuid, Uuid uuid2, Uuid uuid3, InputStream inputStream, int n) throws StorageException {
        CloudDataMetadata cloudDataMetadata = new CloudDataMetadata().withTaskUuid(uuid2.toString()).withJobUuid(uuid.toString()).withUuid(uuid3.toString());
        this.putData(cloudDataMetadata, uuid3, inputStream, n);
    }

    @Override
    public void putJobData(Uuid uuid, Uuid uuid2, InputStream inputStream, int n) throws StorageException {
        CloudDataMetadata cloudDataMetadata = new CloudDataMetadata().withJobUuid(uuid.toString()).withUuid(uuid2.toString());
        this.putData(cloudDataMetadata, uuid2, inputStream, n);
    }

    private void putData(CloudDataMetadata cloudDataMetadata, Uuid uuid, InputStream inputStream, int n) throws StorageException {
        final CloudDataCreateRequest cloudDataCreateRequest = new CloudDataCreateRequest().withCloudDataMetadata(new CloudDataMetadata[]{cloudDataMetadata});
        CloudDataCreateResponse cloudDataCreateResponse = this.makeRequestAndRetry(new StorageInvokable<CloudDataCreateResponse>(){

            @Override
            public CloudDataCreateResponse invoke() {
                return CloudStorage.this.fDataAccess.create(cloudDataCreateRequest);
            }
        });
        List list = cloudDataCreateResponse.getCreatedDataMetadata();
        List list2 = cloudDataCreateResponse.getErrors();
        if (!list2.isEmpty()) {
            assert (list2.size() == 1);
            throw new CreateDataException(this.extractAndLogErrorMessage((ErrorReturn)list2.get(0), "Failed to create data in storage."));
        }
        assert (list.size() == 1) : "Created incorrect amount of data, requested 1, got: " + list.size();
        this.updateData(uuid, inputStream, n);
    }

    @Override
    public void removeDataForJobAndTasks(Uuid uuid) throws DataStorageException {
    }

    @Override
    public Uuid putJob(JobImpl jobImpl) throws StorageException {
        CloudJobCreateResponse cloudJobCreateResponse;
        CloudJob cloudJob;
        Pair<InputStream, Integer> pair;
        Uuid uuid = jobImpl.getID();
        try {
            pair = this.serializeToStream(jobImpl);
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to write job to GDS storage.", iOException);
            throw new WorkUnitStorageException((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.WriteJobError, (Throwable)iOException, new Object[0]);
        }
        CloudJobMetadata cloudJobMetadata = new CloudJobMetadata().withUuid(jobImpl.getID().toString()).withType(Integer.valueOf(jobImpl.getJobMLType())).withState(Integer.valueOf(jobImpl.getState()));
        try {
            cloudJob = new CloudJob().withCloudJobMetadata(cloudJobMetadata).withSerializedJob(pair.getFirst(), pair.getSecond().intValue());
        }
        catch (IOException iOException) {
            throw new JobWriteException(iOException);
        }
        final CloudJobCreateRequest cloudJobCreateRequest = new CloudJobCreateRequest().withCloudJob(cloudJob);
        try {
            cloudJobCreateResponse = this.makeRequestAndRetry(new StorageInvokable<CloudJobCreateResponse>(){

                @Override
                public CloudJobCreateResponse invoke() throws StorageException {
                    return CloudStorage.this.fJobAccess.create(cloudJobCreateRequest);
                }
            });
        }
        catch (ResourceExistsException resourceExistsException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to create job because a job with the same id already existed in GDS storage.", resourceExistsException);
            throw new JobAlreadyExistsException((Exception)((Object)resourceExistsException));
        }
        CloudJobMetadata cloudJobMetadata2 = cloudJobCreateResponse.getCloudJobMetadata();
        Uuid uuid2 = UuidFactory.create((String)cloudJobMetadata2.getUuid());
        assert (uuid2.equals((Object)uuid)) : "Uuid of newly created job does not match uuid of original job.";
        return uuid2;
    }

    @Override
    public void removeJob(Uuid uuid) throws StorageException {
        final CloudJobRemoveRequest cloudJobRemoveRequest = new CloudJobRemoveRequest().withCloudJobMetadata(new CloudJobMetadata[]{new CloudJobMetadata().withUuid(uuid.toString())});
        this.makeRequestAndRetry(new StorageInvokable<CloudJobRemoveResponse>(){

            @Override
            public CloudJobRemoveResponse invoke() throws StorageException {
                return CloudStorage.this.fJobAccess.remove(cloudJobRemoveRequest);
            }
        });
    }

    @Override
    public void addToQueue(Uuid uuid) throws StorageException {
        final CloudQueuePromoteRequest cloudQueuePromoteRequest = new CloudQueuePromoteRequest().withJobUuid(uuid.toString());
        this.makeRequestAndRetry(new StorageInvokable<CloudQueuePromoteResponse>(){

            @Override
            public CloudQueuePromoteResponse invoke() throws StorageException {
                return CloudStorage.this.fQueueAccess.promoteJob(cloudQueuePromoteRequest);
            }
        });
    }

    @Override
    public void removeFromQueue(Uuid uuid) throws StorageException {
        final CloudQueueDemoteRequest cloudQueueDemoteRequest = new CloudQueueDemoteRequest().withJobUuid(uuid.toString());
        this.makeRequestAndRetry(new StorageInvokable<Object>(){

            @Override
            public Object invoke() throws StorageException {
                return CloudStorage.this.fQueueAccess.demoteJob(cloudQueueDemoteRequest);
            }
        });
    }

    @Override
    public void promoteJob(Uuid uuid) throws StorageException, WorkUnitStateException {
        int n = this.readJobState(uuid);
        if (n != 1) {
            throw new IncorrectStateToPromoteJobException();
        }
        final CloudQueuePromoteRequest cloudQueuePromoteRequest = new CloudQueuePromoteRequest().withJobUuid(uuid.toString());
        this.makeRequestAndRetry(new StorageInvokable<CloudQueuePromoteResponse>(){

            @Override
            public CloudQueuePromoteResponse invoke() throws StorageException {
                return CloudStorage.this.fQueueAccess.promoteJob(cloudQueuePromoteRequest);
            }
        });
    }

    @Override
    public void demoteJob(Uuid uuid) throws StorageException, WorkUnitStateException {
        int n = this.readJobState(uuid);
        if (n != 1) {
            throw new IncorrectStateToDemoteJobException();
        }
        final CloudQueueDemoteRequest cloudQueueDemoteRequest = new CloudQueueDemoteRequest().withJobUuid(uuid.toString());
        this.makeRequestAndRetry(new StorageInvokable<CloudQueueDemoteResponse>(){

            @Override
            public CloudQueueDemoteResponse invoke() throws StorageException {
                return CloudStorage.this.fQueueAccess.demoteJob(cloudQueueDemoteRequest);
            }
        });
    }

    private int readJobState(Uuid uuid) throws StorageException {
        final CloudJobMetadataReadRequest cloudJobMetadataReadRequest = new CloudJobMetadataReadRequest().withCloudJobMetadata(new CloudJobMetadata[]{new CloudJobMetadata().withUuid(uuid.toString())});
        CloudJobMetadataReadResponse cloudJobMetadataReadResponse = this.makeRequestAndRetry(new StorageInvokable<CloudJobMetadataReadResponse>(){

            @Override
            public CloudJobMetadataReadResponse invoke() throws StorageException {
                return CloudStorage.this.fJobAccess.metadataRead(cloudJobMetadataReadRequest);
            }
        });
        List list = cloudJobMetadataReadResponse.getJobMetadata();
        if (list.isEmpty()) {
            throw new ReadJobStateException();
        }
        assert (list.size() == 1);
        return ((CloudJobMetadata)list.get(0)).getState();
    }

    @Override
    public void updateCredentials(UserCredentials userCredentials) {
        assert (userCredentials.hasCredentialsForRole(CredentialRole.LOGIN_TOKEN));
        LoginTokenCredentials loginTokenCredentials = (LoginTokenCredentials)userCredentials.getCredentialsForRole(CredentialRole.LOGIN_TOKEN);
        this.fLoginToken.set(loginTokenCredentials.getLoginToken());
    }

    @Override
    public Uuid[] readTasksByJobID(Uuid uuid) throws StorageException {
        CloudTaskMetadata cloudTaskMetadata = new CloudTaskMetadata().withJobUuid(uuid.toString());
        List<CloudTaskMetadata> list = this.readAndSortTaskMetadataBySequence(cloudTaskMetadata);
        ArrayList<Uuid> arrayList = new ArrayList<Uuid>();
        for (CloudTaskMetadata cloudTaskMetadata2 : list) {
            arrayList.add(UuidFactory.create((String)cloudTaskMetadata2.getUuid()));
        }
        return arrayList.toArray(new Uuid[arrayList.size()]);
    }

    @Override
    public Uuid[][] readTasksByJobIDAndState(Uuid uuid, int[] nArray) throws StorageException {
        ArrayList<CloudTaskMetadata> arrayList = new ArrayList<CloudTaskMetadata>();
        for (int n : nArray) {
            arrayList.add(new CloudTaskMetadata().withJobUuid(uuid.toString()).withState(Integer.valueOf(n)));
        }
        List<CloudTaskMetadata> list = this.readAndSortTaskMetadataBySequence(arrayList.toArray(new CloudTaskMetadata[arrayList.size()]));
        Map<Integer, Collection<Uuid>> map = this.filterTasksByState(list);
        return StorageHelpers.createArrayOfUuids(nArray, map);
    }

    @Override
    public Uuid[] readTasksByJobIDAndState(Uuid uuid, int n, int n2) throws StorageException {
        Uuid[] uuidArray = this.readTasksByJobIDAndState(uuid, new int[]{n})[0];
        if (uuidArray.length > n2) {
            return Arrays.copyOf(uuidArray, n2);
        }
        return uuidArray;
    }

    @Override
    public Uuid[] readTasksByJobIDAndBeforeState(Uuid uuid, int n) throws MJSException {
        if (n == 0) {
            return StorageHelpers.EMPTY_UUID_ARRAY;
        }
        ArrayList<CloudTaskMetadata> arrayList = new ArrayList<CloudTaskMetadata>();
        for (int i = 0; i < n; ++i) {
            arrayList.add(new CloudTaskMetadata().withJobUuid(uuid.toString()).withState(Integer.valueOf(i)));
        }
        List<CloudTaskMetadata> list = this.readAndSortTaskMetadataBySequence(arrayList.toArray(new CloudTaskMetadata[arrayList.size()]));
        ArrayList<Uuid> arrayList2 = new ArrayList<Uuid>();
        for (CloudTaskMetadata cloudTaskMetadata : list) {
            arrayList2.add(UuidFactory.create((String)cloudTaskMetadata.getUuid()));
        }
        return arrayList2.toArray(new Uuid[list.size()]);
    }

    @Override
    public Uuid[] readTasksByState(int n) throws StorageException {
        CloudTaskMetadata cloudTaskMetadata = new CloudTaskMetadata().withState(Integer.valueOf(n));
        List<CloudTaskMetadata> list = this.readAndSortTaskMetadataBySequence(cloudTaskMetadata);
        ArrayList<Uuid> arrayList = new ArrayList<Uuid>();
        for (CloudTaskMetadata cloudTaskMetadata2 : list) {
            arrayList.add(UuidFactory.create((String)cloudTaskMetadata2.getUuid()));
        }
        return arrayList.toArray(new Uuid[list.size()]);
    }

    private List<CloudTaskMetadata> readAndSortTaskMetadataBySequence(CloudTaskMetadata ... cloudTaskMetadataArray) throws StorageException {
        final CloudTaskMetadataReadRequest cloudTaskMetadataReadRequest = new CloudTaskMetadataReadRequest().withCloudTaskMetadata(cloudTaskMetadataArray);
        CloudTaskMetadataReadResponse cloudTaskMetadataReadResponse = this.makeRequestAndRetry(new StorageInvokable<CloudTaskMetadataReadResponse>(){

            @Override
            public CloudTaskMetadataReadResponse invoke() throws StorageException {
                return CloudStorage.this.fTaskAccess.metadataRead(cloudTaskMetadataReadRequest);
            }
        });
        List list = cloudTaskMetadataReadResponse.getTaskMetadata();
        Collections.sort(list, new Comparator<CloudTaskMetadata>(){

            @Override
            public int compare(CloudTaskMetadata cloudTaskMetadata, CloudTaskMetadata cloudTaskMetadata2) {
                return cloudTaskMetadata.getSequence().compareTo(cloudTaskMetadata2.getSequence());
            }
        });
        return list;
    }

    private Map<Integer, Collection<Uuid>> filterTasksByState(Collection<CloudTaskMetadata> collection) {
        HashMap<Integer, Collection<Uuid>> hashMap = new HashMap<Integer, Collection<Uuid>>();
        for (CloudTaskMetadata cloudTaskMetadata : collection) {
            if (!hashMap.containsKey(cloudTaskMetadata.getState())) {
                hashMap.put(cloudTaskMetadata.getState(), new ArrayList());
            }
            ((Collection)hashMap.get(cloudTaskMetadata.getState())).add(UuidFactory.create((String)cloudTaskMetadata.getUuid()));
        }
        return hashMap;
    }

    private Map<Integer, Collection<JobIDAndMLType>> filterJobsByState(Collection<CloudJobMetadata> collection) {
        HashMap<Integer, Collection<JobIDAndMLType>> hashMap = new HashMap<Integer, Collection<JobIDAndMLType>>();
        for (CloudJobMetadata cloudJobMetadata : collection) {
            if (!hashMap.containsKey(cloudJobMetadata.getState())) {
                hashMap.put(cloudJobMetadata.getState(), new ArrayList());
            }
            ((Collection)hashMap.get(cloudJobMetadata.getState())).add(new JobIDAndMLType(UuidFactory.create((String)cloudJobMetadata.getUuid()), cloudJobMetadata.getType()));
        }
        return hashMap;
    }

    @Override
    public Uuid[] readJobsByState(int n) throws StorageException {
        CloudJobMetadata cloudJobMetadata = new CloudJobMetadata().withState(Integer.valueOf(n));
        Comparator<CloudJobMetadata> comparator = new Comparator<CloudJobMetadata>(){

            @Override
            public int compare(CloudJobMetadata cloudJobMetadata, CloudJobMetadata cloudJobMetadata2) {
                Integer n = cloudJobMetadata.getQueuenum();
                Integer n2 = cloudJobMetadata2.getQueuenum();
                if (n != null && n2 != null) {
                    return cloudJobMetadata.getQueuenum().compareTo(cloudJobMetadata2.getQueuenum());
                }
                assert (n == null && n2 == null);
                return cloudJobMetadata.getSequence().compareTo(cloudJobMetadata2.getSequence());
            }
        };
        List<CloudJobMetadata> list = this.readAndSortJobMetadata(comparator, cloudJobMetadata);
        ArrayList<Uuid> arrayList = new ArrayList<Uuid>();
        for (CloudJobMetadata cloudJobMetadata2 : list) {
            arrayList.add(UuidFactory.create((String)cloudJobMetadata2.getUuid()));
        }
        return arrayList.toArray(new Uuid[list.size()]);
    }

    @Override
    public Uuid readFirstJobByState(int n) throws StorageException {
        CloudJobMetadata cloudJobMetadata = new CloudJobMetadata().withState(Integer.valueOf(n));
        List<CloudJobMetadata> list = this.readAndSortJobMetadataBySequence(cloudJobMetadata);
        return list.isEmpty() ? null : UuidFactory.create((String)list.get(0).getUuid());
    }

    @Override
    public JobIDAndMLType[] readJobsAndTypes() throws StorageException {
        List<CloudJobMetadata> list = this.readAndSortJobMetadataBySequence(new CloudJobMetadata());
        ArrayList<JobIDAndMLType> arrayList = new ArrayList<JobIDAndMLType>(list.size());
        for (CloudJobMetadata cloudJobMetadata : list) {
            arrayList.add(new JobIDAndMLType(UuidFactory.create((String)cloudJobMetadata.getUuid()), cloudJobMetadata.getType()));
        }
        return arrayList.toArray(new JobIDAndMLType[list.size()]);
    }

    @Override
    public JobIDAndMLType[][] readJobsAndTypesByState(int[] nArray) throws StorageException {
        ArrayList<CloudJobMetadata> arrayList = new ArrayList<CloudJobMetadata>();
        for (int n : nArray) {
            arrayList.add(new CloudJobMetadata().withState(Integer.valueOf(n)));
        }
        Comparator<CloudJobMetadata> comparator = new Comparator<CloudJobMetadata>(){

            @Override
            public int compare(CloudJobMetadata cloudJobMetadata, CloudJobMetadata cloudJobMetadata2) {
                if (cloudJobMetadata.getQueuenum() != null && cloudJobMetadata2.getQueuenum() != null) {
                    return cloudJobMetadata.getQueuenum().compareTo(cloudJobMetadata2.getQueuenum());
                }
                return cloudJobMetadata.getSequence().compareTo(cloudJobMetadata2.getSequence());
            }
        };
        List<CloudJobMetadata> list = this.readAndSortJobMetadata(comparator, arrayList.toArray(new CloudJobMetadata[arrayList.size()]));
        Map<Integer, Collection<JobIDAndMLType>> map = this.filterJobsByState(list);
        return JobIDAndMLType.convertToJobAndTypesArray(nArray, map);
    }

    @Override
    public Uuid[] readJobsByJobStateWithTasksInState(int n, int n2) throws StorageException {
        Object object2;
        CloudTaskMetadataReadRequest cloudTaskMetadataReadRequest = this.readJobsByState(n);
        if (((Uuid[])cloudTaskMetadataReadRequest).length == 0) {
            return StorageHelpers.EMPTY_UUID_ARRAY;
        }
        ArrayList<CloudTaskMetadata> arrayList = new ArrayList<CloudTaskMetadata>();
        for (Object object2 : cloudTaskMetadataReadRequest) {
            arrayList.add(new CloudTaskMetadata().withJobUuid(object2.toString()).withState(Integer.valueOf(n2)));
        }
        final CloudTaskMetadataReadRequest cloudTaskMetadataReadRequest2 = new CloudTaskMetadataReadRequest().withCloudTaskMetadata(arrayList.toArray(new CloudTaskMetadata[arrayList.size()]));
        CloudTaskMetadataReadResponse cloudTaskMetadataReadResponse = this.makeRequestAndRetry(new StorageInvokable<CloudTaskMetadataReadResponse>(){

            @Override
            public CloudTaskMetadataReadResponse invoke() throws StorageException {
                return CloudStorage.this.fTaskAccess.metadataRead(cloudTaskMetadataReadRequest2);
            }
        });
        List list = cloudTaskMetadataReadResponse.getTaskMetadata();
        object2 = new HashSet();
        for (CloudTaskMetadata cloudTaskMetadata : list) {
            object2.add(UuidFactory.create((String)cloudTaskMetadata.getJobUuid()));
        }
        return object2.toArray(new Uuid[object2.size()]);
    }

    private List<CloudJobMetadata> readAndSortJobMetadataBySequence(CloudJobMetadata ... cloudJobMetadataArray) throws StorageException {
        Comparator<CloudJobMetadata> comparator = new Comparator<CloudJobMetadata>(){

            @Override
            public int compare(CloudJobMetadata cloudJobMetadata, CloudJobMetadata cloudJobMetadata2) {
                return cloudJobMetadata.getSequence().compareTo(cloudJobMetadata2.getSequence());
            }
        };
        return this.readAndSortJobMetadata(comparator, cloudJobMetadataArray);
    }

    private List<CloudJobMetadata> readAndSortJobMetadata(Comparator<CloudJobMetadata> comparator, CloudJobMetadata ... cloudJobMetadataArray) throws StorageException {
        final CloudJobMetadataReadRequest cloudJobMetadataReadRequest = new CloudJobMetadataReadRequest().withCloudJobMetadata(cloudJobMetadataArray);
        CloudJobMetadataReadResponse cloudJobMetadataReadResponse = this.makeRequestAndRetry(new StorageInvokable<CloudJobMetadataReadResponse>(){

            @Override
            public CloudJobMetadataReadResponse invoke() throws StorageException {
                return CloudStorage.this.fJobAccess.metadataRead(cloudJobMetadataReadRequest);
            }
        });
        List list = cloudJobMetadataReadResponse.getJobMetadata();
        Collections.sort(list, comparator);
        return list;
    }

    @Override
    public int countTasksByJobID(Uuid uuid) throws StorageException {
        CloudTaskMetadata cloudTaskMetadata = new CloudTaskMetadata().withJobUuid(uuid.toString());
        List<CloudTaskMetadata> list = this.readTaskMetadata(cloudTaskMetadata);
        return list.size();
    }

    @Override
    public int countTasksByJobIDAndState(Uuid uuid, int n) throws StorageException {
        CloudTaskMetadata cloudTaskMetadata = new CloudTaskMetadata().withJobUuid(uuid.toString()).withState(Integer.valueOf(n));
        List<CloudTaskMetadata> list = this.readTaskMetadata(cloudTaskMetadata);
        return list.size();
    }

    @Override
    public int countTasksByJobIDAndBeforeState(Uuid uuid, int n) throws StorageException {
        CloudTaskMetadata cloudTaskMetadata = new CloudTaskMetadata().withJobUuid(uuid.toString());
        List<CloudTaskMetadata> list = this.readTaskMetadata(cloudTaskMetadata);
        int n2 = 0;
        for (CloudTaskMetadata cloudTaskMetadata2 : list) {
            if (cloudTaskMetadata2.getState() >= n) continue;
            ++n2;
        }
        return n2;
    }

    private List<CloudTaskMetadata> readTaskMetadata(CloudTaskMetadata ... cloudTaskMetadataArray) throws StorageException {
        final CloudTaskMetadataReadRequest cloudTaskMetadataReadRequest = new CloudTaskMetadataReadRequest().withCloudTaskMetadata(cloudTaskMetadataArray);
        CloudTaskMetadataReadResponse cloudTaskMetadataReadResponse = this.makeRequestAndRetry(new StorageInvokable<CloudTaskMetadataReadResponse>(){

            @Override
            public CloudTaskMetadataReadResponse invoke() throws StorageException {
                return CloudStorage.this.fTaskAccess.metadataRead(cloudTaskMetadataReadRequest);
            }
        });
        return cloudTaskMetadataReadResponse.getTaskMetadata();
    }

    @Override
    public Uuid putTask(TaskImpl taskImpl) throws StorageException {
        CloudTask cloudTask;
        CloudTaskCreateRequest cloudTaskCreateRequest;
        Integer n = (int)taskImpl.getNum();
        CloudTaskMetadata cloudTaskMetadata = new CloudTaskMetadata().withUuid(taskImpl.getID().toString()).withJobUuid(taskImpl.getJob().toString()).withState(Integer.valueOf(taskImpl.getState())).withSequence(n);
        try {
            cloudTaskCreateRequest = this.serializeToStream(taskImpl);
            cloudTask = new CloudTask().withCloudTaskMetadata(cloudTaskMetadata).withSerializedTask(cloudTaskCreateRequest.getFirst(), cloudTaskCreateRequest.getSecond().intValue());
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to write task " + n + " to database.", iOException);
            throw new WorkUnitStorageException((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.WriteTaskError, (Throwable)iOException, new Object[0]);
        }
        cloudTaskCreateRequest = new CloudTaskCreateRequest().withCloudTasks(new CloudTask[]{cloudTask});
        CloudTaskCreateResponse cloudTaskCreateResponse = this.makeRequestAndRetry(new StorageInvokable<CloudTaskCreateResponse>(){

            @Override
            public CloudTaskCreateResponse invoke() throws StorageException {
                return CloudStorage.this.fTaskAccess.create(cloudTaskCreateRequest);
            }
        });
        List list = cloudTaskCreateResponse.getErrors();
        if (!list.isEmpty()) {
            assert (list.size() == 1);
            throw new PutTaskException(this.extractAndLogErrorMessage((ErrorReturn)list.get(0), "Failed to put task in storage."));
        }
        List list2 = cloudTaskCreateResponse.getCreatedTaskMetadata();
        assert (list2.size() == 1) : "Only one task was created but it was not returned correctly";
        CloudTaskMetadata cloudTaskMetadata2 = (CloudTaskMetadata)list2.get(0);
        assert (cloudTaskMetadata2.getSequence() != null) : "Task's sequence number was null";
        return UuidFactory.create((String)cloudTaskMetadata2.getUuid());
    }

    @Override
    public void removeTask(Uuid uuid) throws StorageException {
        CloudTaskMetadata cloudTaskMetadata = new CloudTaskMetadata().withUuid(uuid.toString());
        final CloudTaskRemoveRequest cloudTaskRemoveRequest = new CloudTaskRemoveRequest().withCloudTaskMetadata(new CloudTaskMetadata[]{cloudTaskMetadata});
        this.makeRequestAndRetry(new StorageInvokable<CloudTaskRemoveResponse>(){

            @Override
            public CloudTaskRemoveResponse invoke() throws StorageException {
                return CloudStorage.this.fTaskAccess.remove(cloudTaskRemoveRequest);
            }
        });
    }

    @Override
    public int updateWorkUnit(WorkUnitImpl workUnitImpl) throws StorageException {
        if (workUnitImpl instanceof JobImpl) {
            JobImpl jobImpl = (JobImpl)workUnitImpl;
            try {
                CloudJobMetadata cloudJobMetadata = new CloudJobMetadata().withUuid(jobImpl.getID().toString()).withState(Integer.valueOf(jobImpl.getState())).withType(Integer.valueOf(jobImpl.getJobMLType()));
                Pair<InputStream, Integer> pair = this.serializeToStream(jobImpl);
                CloudJob cloudJob = new CloudJob().withCloudJobMetadata(cloudJobMetadata).withSerializedJob(pair.getFirst(), pair.getSecond().intValue());
                return this.updateJob(cloudJob);
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(Level.SEVERE, "Failed to update job.", iOException);
                throw new WorkUnitStorageException((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.UpdateJobError, (Throwable)iOException, new Object[0]);
            }
        }
        if (workUnitImpl instanceof TaskImpl) {
            TaskImpl taskImpl = (TaskImpl)workUnitImpl;
            try {
                CloudTaskMetadata cloudTaskMetadata = new CloudTaskMetadata().withUuid(taskImpl.getID().toString()).withState(Integer.valueOf(taskImpl.getState()));
                Pair<InputStream, Integer> pair = this.serializeToStream(taskImpl);
                CloudTask cloudTask = new CloudTask().withCloudTaskMetadata(cloudTaskMetadata).withSerializedTask(pair.getFirst(), pair.getSecond().intValue());
                return this.updateTask(cloudTask);
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(Level.SEVERE, "Failed to update task.", iOException);
                throw new WorkUnitStorageException((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.UpdateTaskError, (Throwable)iOException, new Object[0]);
            }
        }
        PackageInfo.LOGGER.log(Level.SEVERE, "The WorkUnitImpl was not an instance of JobImpl or TaskImpl.");
        throw new IllegalStateException("The WorkUnitImpl was not an instance of JobImpl or TaskImpl.");
    }

    private int updateJob(CloudJob cloudJob) throws StorageException {
        final CloudJobUpdateRequest cloudJobUpdateRequest = new CloudJobUpdateRequest().withCloudJobs(new CloudJob[]{cloudJob});
        CloudJobUpdateResponse cloudJobUpdateResponse = this.makeRequestAndRetry(new StorageInvokable<CloudJobUpdateResponse>(){

            @Override
            public CloudJobUpdateResponse invoke() throws StorageException {
                return CloudStorage.this.fJobAccess.update(cloudJobUpdateRequest);
            }
        });
        List list = cloudJobUpdateResponse.getErrors();
        if (!list.isEmpty()) {
            assert (list.size() == 1);
            if (((ErrorReturn)list.get(0)).getErrorCode() != CloudMJSErrorCode.RESOURCE_NOT_FOUND) {
                throw new UpdateJobException(this.extractAndLogErrorMessage((ErrorReturn)list.get(0), "Failed to update job in GDS storage."));
            }
        }
        return cloudJobUpdateResponse.getUpdatedUuids().size();
    }

    private int updateTask(CloudTask cloudTask) throws StorageException {
        final CloudTaskUpdateRequest cloudTaskUpdateRequest = new CloudTaskUpdateRequest().withCloudTasks(new CloudTask[]{cloudTask});
        CloudTaskUpdateResponse cloudTaskUpdateResponse = this.makeRequestAndRetry(new StorageInvokable<CloudTaskUpdateResponse>(){

            @Override
            public CloudTaskUpdateResponse invoke() throws StorageException {
                return CloudStorage.this.fTaskAccess.update(cloudTaskUpdateRequest);
            }
        });
        List list = cloudTaskUpdateResponse.getErrors();
        if (!list.isEmpty()) {
            assert (list.size() == 1);
            if (((ErrorReturn)list.get(0)).getErrorCode() != CloudMJSErrorCode.RESOURCE_NOT_FOUND) {
                throw new UpdateTaskException(this.extractAndLogErrorMessage((ErrorReturn)list.get(0), "Failed to update task in GDS storage."));
            }
        }
        return cloudTaskUpdateResponse.getUpdatedUuids().size();
    }

    @Override
    public void close() throws StorageException {
        CloudLogoutRequest cloudLogoutRequest = new CloudLogoutRequest();
        this.fClient.logout(cloudLogoutRequest);
    }

    @Override
    public WorkUnitImpl readWorkUnit(Uuid uuid) throws StorageException {
        WorkUnitImpl workUnitImpl;
        List<CloudJob> list = this.makeReadJobRequest(uuid);
        if (!list.isEmpty()) {
            assert (list.size() == 1);
            workUnitImpl = this.readJob(list.get(0));
        } else {
            List<CloudTask> list2 = this.makeReadTaskRequest(uuid);
            if (list2.isEmpty()) {
                throw new WorkUnitNotFoundException((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.WorkUnitNotFound, new Object[0]);
            }
            assert (list2.size() == 1);
            workUnitImpl = this.readTask(list2.get(0));
        }
        assert (workUnitImpl != null);
        return workUnitImpl;
    }

    private List<CloudJob> makeReadJobRequest(Uuid uuid) throws StorageException {
        final CloudJobReadRequest cloudJobReadRequest = new CloudJobReadRequest().withCloudJobMetadata(new CloudJobMetadata[]{new CloudJobMetadata().withUuid(uuid.toString())});
        CloudJobReadResponse cloudJobReadResponse = this.makeRequestAndRetry(new StorageInvokable<CloudJobReadResponse>(){

            @Override
            public CloudJobReadResponse invoke() throws StorageException {
                return CloudStorage.this.fJobAccess.read(cloudJobReadRequest);
            }
        });
        return cloudJobReadResponse.getJobs();
    }

    private List<CloudTask> makeReadTaskRequest(Uuid uuid) throws StorageException {
        final CloudTaskReadRequest cloudTaskReadRequest = new CloudTaskReadRequest().withCloudTaskMetadata(new CloudTaskMetadata[]{new CloudTaskMetadata().withUuid(uuid.toString())});
        CloudTaskReadResponse cloudTaskReadResponse = this.makeRequestAndRetry(new StorageInvokable<CloudTaskReadResponse>(){

            @Override
            public CloudTaskReadResponse invoke() throws StorageException {
                return CloudStorage.this.fTaskAccess.read(cloudTaskReadRequest);
            }
        });
        return cloudTaskReadResponse.getTasks();
    }

    private JobImpl readJob(CloudJob cloudJob) throws WorkUnitNotFoundException, WorkUnitStorageException {
        JobImpl jobImpl;
        CloudJobMetadata cloudJobMetadata = cloudJob.getCloudJobMetadata();
        try (ObjectInputStream objectInputStream = new ObjectInputStream(cloudJob.getSerializedJob());){
            long l = cloudJobMetadata.getSequence().intValue();
            int n = cloudJobMetadata.getType();
            int n2 = cloudJobMetadata.getState();
            jobImpl = JobImpl.create(objectInputStream, l, n2, n);
        }
        catch (InvalidClassException | ClassNotFoundException exception) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to deserialize job " + cloudJobMetadata.getSequence() + " (uuid: " + cloudJobMetadata.getUuid() + " from database.", exception);
            throw new VersionMismatchException(exception);
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to read job from GDS storage.", iOException);
            throw new ReadJobsException(iOException);
        }
        return jobImpl;
    }

    private TaskImpl readTask(CloudTask cloudTask) throws WorkUnitNotFoundException, WorkUnitStorageException {
        TaskImpl taskImpl;
        CloudTaskMetadata cloudTaskMetadata = cloudTask.getCloudTaskMetadata();
        try (ObjectInputStream objectInputStream = new ObjectInputStream(cloudTask.getSerializedTask());){
            long l = cloudTaskMetadata.getSequence().intValue();
            int n = cloudTaskMetadata.getState();
            taskImpl = TaskImpl.create(objectInputStream, l, n);
        }
        catch (InvalidClassException | ClassNotFoundException exception) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to deserialize task " + cloudTaskMetadata.getSequence() + " (uuid: " + cloudTaskMetadata.getUuid() + ") of job (uuid: " + cloudTaskMetadata.getJobUuid() + " from database.", exception);
            throw new VersionMismatchException(exception);
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(Level.SEVERE, "Failed to read task from GDS storage.", iOException);
            throw new ReadTasksException(iOException);
        }
        return taskImpl;
    }

    @Override
    public int getCacheSize() {
        throw new UnsupportedOperationException();
    }

    private <T> Pair<? extends InputStream, Integer> serializeToStream(T t) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try (ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);){
            objectOutputStream.writeObject(t);
        }
        return new Pair<ByteArrayInputStream, Integer>(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()), byteArrayOutputStream.size());
    }

    private String extractAndLogErrorMessage(ErrorReturn errorReturn, String string) {
        CloudMJSErrorCode cloudMJSErrorCode = errorReturn.getErrorCode();
        String string2 = errorReturn.getMessage();
        PackageInfo.LOGGER.log(Level.SEVERE, string + " Error code: " + cloudMJSErrorCode.name() + ", Error message: " + string2);
        return string2;
    }

    private <V> V makeRequestAndRetry(StorageInvokable<V> storageInvokable) throws StorageException {
        for (int i = 1; i >= 0; --i) {
            try {
                return storageInvokable.invoke();
            }
            catch (SessionException sessionException) {
                if (i > 0) {
                    PackageInfo.LOGGER.log(Level.INFO, "GDS session failed. Attempting to log in again.", sessionException);
                    this.retryLogin(sessionException);
                    continue;
                }
                PackageInfo.LOGGER.log(Level.SEVERE, "GDS session failed.", sessionException);
                throw new GDSSessionFailureException((Exception)((Object)sessionException));
            }
            catch (QuotaExceededException quotaExceededException) {
                PackageInfo.LOGGER.log(Level.SEVERE, "Exceeded GDS quota.", quotaExceededException);
                throw new GDSQuotaExceededException((Exception)((Object)quotaExceededException));
            }
            catch (ServiceException serviceException) {
                PackageInfo.LOGGER.log(Level.SEVERE, "Error thrown from GDS web service.", serviceException);
                throw new ServiceErrorPassThroughException((Exception)((Object)serviceException));
            }
        }
        throw new IllegalStateException();
    }

    private void retryLogin(SessionException sessionException) throws GDSAuthenticationFailureException {
        try {
            CloudLoginRequest cloudLoginRequest = new CloudLoginRequest().withLoginToken(this.fLoginToken.get());
            this.fClient.login(cloudLoginRequest);
        }
        catch (AuthenticationException authenticationException) {
            throw new GDSAuthenticationFailureException(sessionException, (Exception)((Object)authenticationException));
        }
    }

    private static interface StorageInvokable<V> {
        public V invoke() throws StorageException;
    }

    private static final class GDSDataNotFoundException
    extends DataNotFoundException {
        GDSDataNotFoundException(Exception exception) {
            super((BaseMsgID)new mjs.DataNotFound(), (Throwable)exception);
        }
    }

    private static final class ServiceErrorPassThroughException
    extends StorageException {
        ServiceErrorPassThroughException(Exception exception) {
            super((BaseMsgID)new webservices.ServiceError(exception.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private static final class GDSQuotaExceededException
    extends StorageException {
        GDSQuotaExceededException(Exception exception) {
            super((BaseMsgID)new mjs.GDSQuotaExceeded(), (Throwable)exception);
        }
    }

    private static final class GDSSessionFailureException
    extends I18nRuntimeException {
        GDSSessionFailureException(Exception exception) {
            super((BaseMsgID)new mjs.GDSSessionFailure(), (Throwable)exception);
        }
    }

    private static final class GDSAuthenticationFailureException
    extends StorageException {
        GDSAuthenticationFailureException(SessionException sessionException, Exception exception) {
            super((BaseMsgID)new mjs.GDSAuthenticationErrorOnRetry(sessionException.getLocalizedMessage()), (Throwable)exception);
        }
    }

    private static class VersionMismatchException
    extends WorkUnitStorageException {
        private VersionMismatchException(Exception exception) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.VersionMismatchError, (Throwable)exception, new Object[0]);
        }
    }

    private static final class UpdateTaskException
    extends WorkUnitStorageException {
        UpdateTaskException(String string) {
            super((BaseMsgID)new mjs.GDSUpdateTaskError(string));
        }
    }

    private static final class UpdateJobException
    extends WorkUnitStorageException {
        UpdateJobException(String string) {
            super((BaseMsgID)new mjs.GDSUpdateJobError(string));
        }
    }

    private static final class PutTaskException
    extends WorkUnitStorageException {
        PutTaskException(String string) {
            super((BaseMsgID)new mjs.GDSPutTaskError(string));
        }
    }

    private static class ReadJobStateException
    extends StorageException {
        ReadJobStateException() {
            super((BaseMsgID)new mjs.GDSReadJobStateError());
        }
    }

    private static class JobAlreadyExistsException
    extends WorkUnitStorageException {
        JobAlreadyExistsException(Exception exception) {
            super((BaseMsgID)new mjs.GDSJobAlreadyExists(), (Throwable)exception);
        }
    }

    private static class JobWriteException
    extends WorkUnitStorageException {
        JobWriteException(Exception exception) {
            super((BaseMsgID)new mjs.GDSJobWriteError(), (Throwable)exception);
        }
    }

    private static final class CreateDataException
    extends DataStorageException {
        CreateDataException(String string) {
            super((BaseMsgID)new mjs.GDSCreateDataError(string));
        }
    }

    private static class CloneDataException
    extends DataStorageException {
        CloneDataException(String string) {
            super((BaseMsgID)new mjs.GDSCloneDataError(string));
        }
    }
}

