/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.storage;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.storage.DatabaseConnectionPool;
import com.mathworks.toolbox.distcomp.storage.PackageInfo;
import com.mathworks.toolbox.distcomp.storage.StorageErrorCode;
import com.mathworks.toolbox.distcomp.storage.StorageException;
import com.mathworks.toolbox.distcomp.storage.StorageInitException;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedMessageCreator;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class H2DatabaseConnectionPool
implements DatabaseConnectionPool {
    private static final String DRIVER_CLASS = "org.h2.Driver";
    private static final String USERNAME = "user";
    private static final String PASSWORD = "pass";
    private static final String TASK_TABLE_NAME = "task_table";
    private static final String JOB_TABLE_NAME = "job_table";
    private static final String DATA_TABLE_NAME = "data_table";
    private static final String CRED_TABLE_NAME = "cred_table";
    private static final String BLOBFILE_TABLE_NAME = "blobfile_table";
    private static final String DATA_SEQUENCE_NAME = "data_seq_key";
    private static final String JOB_SEQUENCE_NAME = "job_seq_key";
    private static final String JOB_QUEUE_SEQUENCE_NAME = "job_queue_seq_key";
    private String fDatabaseURL;
    private int fOpenConnections = 0;
    private static final int MAX_DATABASE_CONNECTIONS = 3;
    private static final Map<String, DatabaseConnectionPool> ALL_DATABASE_CREATORS = new HashMap<String, DatabaseConnectionPool>();

    private H2DatabaseConnectionPool(String string) throws StorageInitException {
        try {
            Class.forName(DRIVER_CLASS).newInstance();
        }
        catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
            throw new StorageInitException((BaseMsgID)new mjs.InstanceCreationFailed(DRIVER_CLASS), (Throwable)reflectiveOperationException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new StorageInitException((BaseMsgID)new mjs.MissingJDBCDriver(), (Throwable)classNotFoundException);
        }
        this.fDatabaseURL = string;
    }

    public static synchronized DatabaseConnectionPool getH2DatabaseConnectionPool(String string) throws StorageInitException {
        DatabaseConnectionPool databaseConnectionPool;
        if (ALL_DATABASE_CREATORS.containsKey(string)) {
            databaseConnectionPool = ALL_DATABASE_CREATORS.get(string);
        } else {
            databaseConnectionPool = new H2DatabaseConnectionPool(string);
            ALL_DATABASE_CREATORS.put(string, databaseConnectionPool);
        }
        return databaseConnectionPool;
    }

    private Connection openConnectionToNewDatabase() throws StorageInitException {
        try {
            boolean bl = false;
            Connection connection = this.getConnection(this.createConnectionCommand(bl));
            this.initializeTables(connection);
            return connection;
        }
        catch (SQLException sQLException) {
            throw new StorageInitException((BaseMsgID)new mjs.DatabaseConnectionFailed(), (Throwable)sQLException);
        }
    }

    @Override
    public synchronized Connection openConnectionToDatabase() throws StorageInitException {
        Connection connection;
        if (this.fOpenConnections >= 3) {
            return null;
        }
        try {
            boolean bl = true;
            connection = this.getConnection(this.createConnectionCommand(bl));
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Using existing database");
        }
        catch (SQLException sQLException) {
            if (sQLException.getSQLState().equals("90013")) {
                connection = this.openConnectionToNewDatabase();
            }
            throw new StorageInitException((BaseMsgID)new mjs.DatabaseConnectionFailed(), (Throwable)sQLException);
        }
        ++this.fOpenConnections;
        return connection;
    }

    @Override
    public synchronized void closeConnection(Connection connection) throws StorageException {
        try {
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new CloseConnectionException(sQLException);
        }
        --this.fOpenConnections;
    }

    private static String createTaskTableString() {
        return "CREATE TABLE task_table (seqnum       BIGINT NOT NULL,jobid        UUID NOT NULL,state        INT NOT NULL,taskid       UUID NOT NULL,task         JAVA_OBJECT NOT NULL,UNIQUE(taskid)); ";
    }

    private static String createJobTableString() {
        return "CREATE TABLE job_table (seqnum       BIGINT NOT NULL,queuenum     BIGINT NOT NULL,jobid        UUID NOT NULL,state        INT NOT NULL,type         INT NOT NULL,job          JAVA_OBJECT NOT NULL,UNIQUE(jobid)); ";
    }

    private static String createDataTableString() {
        return "CREATE TABLE data_table (seqnum       BIGINT NOT NULL,jobid        UUID,taskid       UUID,dataid       UUID NOT NULL,data         BLOB NOT NULL,UNIQUE(dataid) ); ";
    }

    private static String createBlobFileTableString() {
        return "CREATE TABLE blobfile_table (seqnum       BIGINT NOT NULL,jobid        UUID,taskid       UUID,dataid       UUID NOT NULL,filepath     VARCHAR NOT NULL,dataSize     BIGINT NOT NULL,UNIQUE(dataid)); ";
    }

    private static String createCredTableString() {
        return "CREATE TABLE cred_table (creds        JAVA_OBJECT NOT NULL,user         JAVA_OBJECT NOT NULL,role         VARCHAR NOT NULL,UNIQUE(user, role)); ";
    }

    private static List<String> createIndicesStrings() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("CREATE INDEX IDS ON data_table (seqnum)");
        arrayList.add("CREATE INDEX IDJ ON data_table (jobid)");
        arrayList.add("CREATE INDEX IDT ON data_table (taskid)");
        arrayList.add("CREATE INDEX IDD ON data_table (dataid)");
        arrayList.add("CREATE INDEX IBS ON blobfile_table (seqnum)");
        arrayList.add("CREATE INDEX IBJ ON blobfile_table (jobid)");
        arrayList.add("CREATE INDEX IBT ON blobfile_table (taskid)");
        arrayList.add("CREATE INDEX IBD ON blobfile_table (dataid)");
        arrayList.add("CREATE INDEX ITS ON task_table (seqnum)");
        arrayList.add("CREATE INDEX ITJ ON task_table (jobid)");
        arrayList.add("CREATE INDEX ITT ON task_table (taskid)");
        arrayList.add("CREATE INDEX IJS ON job_table (seqnum)");
        arrayList.add("CREATE INDEX IJQ ON job_table (queuenum)");
        arrayList.add("CREATE INDEX IJJ ON job_table (jobid)");
        arrayList.add("CREATE INDEX IJT ON job_table (type)");
        arrayList.add("CREATE INDEX ICT ON cred_table (user)");
        return arrayList;
    }

    private static String createDataSequence() {
        return "CREATE SEQUENCE data_seq_key INCREMENT BY 1 START WITH 1 CACHE 30";
    }

    private static String createJobSequence() {
        return "CREATE SEQUENCE job_seq_key INCREMENT BY 1 START WITH 1 CACHE 30";
    }

    private static String createJobQueueSequence() {
        return "CREATE SEQUENCE job_queue_seq_key INCREMENT BY 1 START WITH 1 CACHE 30";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeTables(Connection connection) throws StorageInitException {
        try {
            Statement statement = connection.createStatement();
            try {
                statement.executeUpdate(H2DatabaseConnectionPool.createTaskTableString());
                statement.executeUpdate(H2DatabaseConnectionPool.createDataTableString());
                statement.executeUpdate(H2DatabaseConnectionPool.createBlobFileTableString());
                statement.executeUpdate(H2DatabaseConnectionPool.createJobTableString());
                statement.executeUpdate(H2DatabaseConnectionPool.createCredTableString());
                statement.executeUpdate(H2DatabaseConnectionPool.createDataSequence());
                statement.executeUpdate(H2DatabaseConnectionPool.createJobSequence());
                statement.executeUpdate(H2DatabaseConnectionPool.createJobQueueSequence());
                for (String string : H2DatabaseConnectionPool.createIndicesStrings()) {
                    statement.executeUpdate(string);
                }
            }
            finally {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Unable to close database initialization statement", sQLException);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new StorageInitException((BaseMsgID)new mjs.DatabaseTableCreationFailed(), (Throwable)sQLException);
        }
    }

    private Connection getConnection(String string) throws SQLException {
        Properties properties = new Properties();
        properties.setProperty(USERNAME, USERNAME);
        properties.setProperty("password", PASSWORD);
        Connection connection = DriverManager.getConnection(string, properties);
        connection.setAutoCommit(true);
        return connection;
    }

    private String createConnectionCommand(boolean bl) {
        String string = this.fDatabaseURL + ";TRACE_LEVEL_FILE=0;TRACE_LEVEL_SYSTEM_OUT=0";
        if (bl) {
            string = string + ";IFEXISTS=TRUE";
        }
        return string;
    }

    private static final class CloseConnectionException
    extends StorageException {
        CloseConnectionException(SQLException sQLException) {
            super((I18nMatlabIdentifiedMessageCreator)StorageErrorCode.CloseConnectionError, (Throwable)sQLException, new Object[0]);
        }
    }
}

