/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.service;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.service.DistcompExportException;
import com.mathworks.toolbox.distcomp.service.ExportConfigInfo;
import com.mathworks.toolbox.distcomp.service.Exporter;
import com.mathworks.toolbox.distcomp.service.PackageInfo;
import com.mathworks.toolbox.distcomp.service.RMISocketFactoryProvider;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.concurrent.ReentrantLock;
import java.rmi.Remote;
import java.rmi.server.ExportException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.security.Security;
import java.util.concurrent.locks.Lock;

public abstract class DistcompExporter
implements Exporter {
    private static final Lock EXPORT_PORT_LOCK;
    protected static final int EXPORT_PORT_NOT_SET = -1;
    private final int fMinPort;
    private final int fMaxPort;
    private final RMISocketFactoryProvider fProvider;

    protected DistcompExporter(int n, int n2, RMISocketFactoryProvider rMISocketFactoryProvider) {
        this.fMinPort = n;
        this.fMaxPort = n2;
        this.fProvider = rMISocketFactoryProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Remote export(Remote remote2) throws ExportException {
        Remote remote3;
        EXPORT_PORT_LOCK.lock();
        try {
            int n = this.getExportPort();
            if (n == -1) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Exporting " + remote2.getClass() + " on free port");
                remote3 = this.exportOnFreePort(remote2);
            } else {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Exporting " + remote2.getClass() + " on export port " + n);
                remote3 = this.exportOnPortAndRegister(remote2, n, this.getRMIServerSocketFactory(), this.getRMIClientSocketFactory());
            }
        }
        finally {
            EXPORT_PORT_LOCK.unlock();
        }
        return remote3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean unexport(boolean bl) {
        EXPORT_PORT_LOCK.lock();
        try {
            boolean bl2 = this.unexportImpl(bl);
            if (bl2) {
                this.unregisterExportPort();
            }
            boolean bl3 = bl2;
            return bl3;
        }
        finally {
            EXPORT_PORT_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getExportPort() {
        EXPORT_PORT_LOCK.lock();
        try {
            int n = ExportConfigInfo.getPort(this.fProvider, -1);
            return n;
        }
        finally {
            EXPORT_PORT_LOCK.unlock();
        }
    }

    @Override
    public boolean isExportSecure() {
        return this.fProvider.isSecure();
    }

    protected abstract Remote exportOnPort(Remote var1, int var2, RMIClientSocketFactory var3, RMIServerSocketFactory var4) throws ExportException;

    protected abstract boolean unexportImpl(boolean var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerExportPort(int n) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "DistcompExporter has successfully exported on " + n);
        EXPORT_PORT_LOCK.lock();
        try {
            ExportConfigInfo.register(this.fProvider, n);
        }
        finally {
            EXPORT_PORT_LOCK.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterExportPort() {
        EXPORT_PORT_LOCK.lock();
        try {
            ExportConfigInfo.unregister(this.fProvider);
        }
        finally {
            EXPORT_PORT_LOCK.unlock();
        }
    }

    private Remote exportOnFreePort(Remote remote2) throws ExportException {
        RMIServerSocketFactory rMIServerSocketFactory = this.getRMIServerSocketFactory();
        RMIClientSocketFactory rMIClientSocketFactory = this.getRMIClientSocketFactory();
        Remote remote3 = null;
        for (int i = this.fMinPort; i <= this.fMaxPort; ++i) {
            try {
                remote3 = this.exportOnPortAndRegister(remote2, i, rMIServerSocketFactory, rMIClientSocketFactory);
                break;
            }
            catch (ExportException exportException) {
                if (i != this.fMaxPort) continue;
                throw new DistcompExportException(this.getFailedToExportMessageID(), (Exception)exportException);
            }
        }
        return remote3;
    }

    private Remote exportOnPortAndRegister(Remote remote2, int n, RMIServerSocketFactory rMIServerSocketFactory, RMIClientSocketFactory rMIClientSocketFactory) throws ExportException {
        Remote remote3 = this.exportOnPort(remote2, n, rMIClientSocketFactory, rMIServerSocketFactory);
        this.registerExportPort(n);
        return remote3;
    }

    private BaseMsgID getFailedToExportMessageID() {
        if (this.fMinPort == this.fMaxPort) {
            return new mjs.FailedToExportObjectOnPort((long)this.fMinPort);
        }
        return new mjs.FailedToFindPortToExportObject((long)this.fMinPort, (long)this.fMaxPort);
    }

    private RMIClientSocketFactory getRMIClientSocketFactory() {
        return this.fProvider.getClientSocketFactory();
    }

    private RMIServerSocketFactory getRMIServerSocketFactory() {
        return this.fProvider.getServerSocketFactory();
    }

    static {
        if (Security.getProvider("Apple") != null) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Removing Apple security provider");
            Security.removeProvider("Apple");
        }
        EXPORT_PORT_LOCK = new ReentrantLock();
    }
}

