/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.CredentialException;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredential;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.Password;
import com.mathworks.toolbox.distcomp.remote.PasswordCredential;
import com.mathworks.toolbox.distcomp.remote.PasswordCredentialDescription;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseMonitor;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseMonitorFactory;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseSource;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchLeasableSession;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.SshParameter;
import java.io.File;
import java.util.Arrays;
import java.util.logging.Level;

public final class JSchSessionLeaseSource {
    public static final LeaseSource<JSchLeasableSession> INSTANCE = new LeaseSource<JSchLeasableSession>(new JSchLeaseSessionMonitorFactory());
    private static final int CHANNEL_LIMIT = 10;
    private static final int LEASE_ATTEMPTS = 2;

    private JSchSessionLeaseSource() {
    }

    private static int getIdleSecondsBeforeDisconnect(ParameterMap parameterMap) {
        int n = SshParameter.IDLE_SECONDS_BEFORE_DISCONNECT.getSuggestedValue();
        if (parameterMap.containsKey(SshParameter.IDLE_SECONDS_BEFORE_DISCONNECT)) {
            n = parameterMap.get(SshParameter.IDLE_SECONDS_BEFORE_DISCONNECT);
        }
        return n;
    }

    private static JSchLeasableSession getJSchLeasableSession(String string, ParameterMap parameterMap) throws ProtocolDispatchException {
        String string2 = string + ": ";
        try {
            Session session = JSchSessionLeaseSource.createJSchSession(string, parameterMap);
            return new JSchLeasableSession(session);
        }
        catch (CredentialException credentialException) {
            throw new CouldNotConnectJSchSessionException(string2, credentialException);
        }
    }

    private static Session createJSchSession(String string, ParameterMap parameterMap) throws CredentialException, ProtocolDispatchException {
        Object object;
        Object object2;
        Session session;
        Object object3;
        Credential credential;
        String string2 = string + ": ";
        JSch.setLogger((com.jcraft.jsch.Logger)new JSchToJavaLogger(string2));
        JSch jSch = new JSch();
        int n = SshParameter.PORT.getSuggestedValue();
        if (parameterMap.containsKey(SshParameter.PORT)) {
            n = parameterMap.get(SshParameter.PORT);
        }
        if ((credential = parameterMap.get(SshParameter.SSH_CREDENTIAL)) instanceof PasswordCredential) {
            object3 = (PasswordCredential)credential;
            String string3 = ((PasswordCredential)object3).getParameterMap().get(PasswordCredentialDescription.USERNAME);
            session = JSchSessionLeaseSource.createSession(string3, string, n, jSch);
            object2 = ((PasswordCredential)object3).getParameterMap().get(PasswordCredentialDescription.PASSWORD);
            if (object2 == null) {
                throw new NullPasswordJSchSessionException(session);
            }
            session.setPassword(((Password)object2).getPassword());
        } else if (credential instanceof IdentityFileCredential) {
            object3 = (IdentityFileCredential)credential;
            String string4 = ((IdentityFileCredential)object3).getParameterMap().get(IdentityFileCredentialDescription.USERNAME);
            session = JSchSessionLeaseSource.createSession(string4, string, n, jSch);
            object2 = ((IdentityFileCredential)object3).getParameterMap().get(IdentityFileCredentialDescription.IDENTITY_FILE);
            object = null;
            Password password = ((IdentityFileCredential)object3).getParameterMap().get(IdentityFileCredentialDescription.PASSPHRASE);
            if (password != null && !password.isEmpty()) {
                object = password.getPassword();
            }
            try {
                jSch.addIdentity(((File)object2).getAbsolutePath(), object);
            }
            catch (JSchException jSchException) {
                throw new IdentityFileCredentialException(jSchException);
            }
        } else {
            throw new UnrecognizedCredentialException();
        }
        object3 = parameterMap.get(SshParameter.KNOWN_HOSTS);
        if (object3 != null) {
            try {
                jSch.setKnownHosts(((File)object3).toString());
            }
            catch (JSchException jSchException) {
                throw new SetKnownHostsException((File)object3, jSchException);
            }
        }
        boolean bl = false;
        if (parameterMap.containsKey(SshParameter.STRICT_HOST_KEY_CHECKING)) {
            bl = parameterMap.get(SshParameter.STRICT_HOST_KEY_CHECKING);
        }
        object = "no";
        if (bl) {
            object = "yes";
        }
        session.setConfig("StrictHostKeyChecking", (String)object);
        return session;
    }

    private static Session createSession(String string, String string2, int n, JSch jSch) throws ProtocolDispatchException {
        try {
            Session session = jSch.getSession(string, string2, n);
            session.setDaemonThread(true);
            return session;
        }
        catch (JSchException jSchException) {
            throw new CanNotCreateSshSessionException(string, string2, n, jSchException);
        }
    }

    static LeaseMonitor<JSchLeasableSession> createForTunnelFuture(String string, ParameterMap parameterMap) throws DispatchException {
        JSchLeaseSessionMonitorFactory jSchLeaseSessionMonitorFactory = new JSchLeaseSessionMonitorFactory();
        LeaseSource<JSchLeasableSession> leaseSource = null;
        return jSchLeaseSessionMonitorFactory.newLeaseMonitor(string, parameterMap, leaseSource);
    }

    private static final class JSchToJavaLogger
    implements com.jcraft.jsch.Logger {
        private final String fLogIDString;

        JSchToJavaLogger(String string) {
            this.fLogIDString = string;
        }

        public boolean isEnabled(int n) {
            return true;
        }

        public void log(int n, String string) {
            switch (n) {
                case 1: {
                    Logger.LOGGER.finest(this.fLogIDString + string);
                    break;
                }
                case 2: {
                    Logger.LOGGER.fine(this.fLogIDString + string);
                    break;
                }
                default: {
                    Logger.LOGGER.finest(this.fLogIDString + string);
                    assert (false) : "JSch added log level " + n;
                    Logger.LOGGER.warning("New log level from JSch: " + n + " " + string);
                }
            }
        }
    }

    private static final class CanNotCreateSshSessionException
    extends ProtocolDispatchException {
        private final String fUser;
        private final String fHostname;
        private final int fPort;

        CanNotCreateSshSessionException(String string, String string2, int n, JSchException jSchException) {
            super(jSchException);
            this.fUser = string;
            this.fHostname = string2;
            this.fPort = n;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.CanNotCreateSshSession(this.fUser, this.fHostname, Integer.toString(this.fPort), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.CanNotCreateSshSession(this.fUser, this.fHostname, Integer.toString(this.fPort), this.getCause().getLocalizedMessage());
        }
    }

    private static final class SetKnownHostsException
    extends ProtocolDispatchException {
        private final File fKnownHosts;

        SetKnownHostsException(File file, JSchException jSchException) {
            super(jSchException);
            this.fKnownHosts = file;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.SetKnownHosts(Arrays.toString(this.fKnownHosts.listFiles()), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.SetKnownHosts(Arrays.toString(this.fKnownHosts.listFiles()), this.getCause().getLocalizedMessage());
        }
    }

    private static final class UnrecognizedCredentialException
    extends CredentialException {
        private final BaseMsgID fBaseMsgID = new remote.UnrecognizedCredential();

        UnrecognizedCredentialException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class IdentityFileCredentialException
    extends CredentialException {
        IdentityFileCredentialException(JSchException jSchException) {
            super(jSchException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new remote.IdentityFileCredentialProblem(this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new remote.IdentityFileCredentialProblem(this.getCause().getLocalizedMessage());
        }
    }

    private static final class NullPasswordJSchSessionException
    extends CredentialException {
        private final BaseMsgID fBaseMsgID;

        NullPasswordJSchSessionException(Session session) {
            this.fBaseMsgID = new remote.NullPasswordJSchSession(session.toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CouldNotConnectJSchSessionException
    extends ProtocolDispatchException {
        private final BaseMsgID fBaseMsgID;

        CouldNotConnectJSchSessionException(String string, CredentialException credentialException) {
            super(credentialException);
            this.fBaseMsgID = new remote.CouldNotConnectJSchSession(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchLeaseSessionMonitorFactory
    implements LeaseMonitorFactory<JSchLeasableSession> {
        private JSchLeaseSessionMonitorFactory() {
        }

        @Override
        public LeaseMonitor<JSchLeasableSession> newLeaseMonitor(String string, ParameterMap parameterMap, LeaseSource<JSchLeasableSession> leaseSource) throws DispatchException {
            int n = 1;
            while (true) {
                try {
                    return this.createLeaseMonitor(string, parameterMap, leaseSource);
                }
                catch (DispatchException dispatchException) {
                    Logger.LOGGER.log(Level.INFO, "Creating a new lease monitor failed, retrying.", dispatchException);
                    if (n >= 2) {
                        throw dispatchException;
                    }
                    ++n;
                    continue;
                }
                break;
            }
        }

        private LeaseMonitor<JSchLeasableSession> createLeaseMonitor(String string, ParameterMap parameterMap, LeaseSource<JSchLeasableSession> leaseSource) throws DispatchException {
            JSchLeasableSession jSchLeasableSession = JSchSessionLeaseSource.getJSchLeasableSession(string, parameterMap);
            int n = JSchSessionLeaseSource.getIdleSecondsBeforeDisconnect(parameterMap);
            return new LeaseMonitor<JSchLeasableSession>(jSchLeasableSession, leaseSource, string, parameterMap, 10, n);
        }
    }
}

