/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi.plugin;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.remote.CopyFromRemoteCommand;
import com.mathworks.toolbox.distcomp.remote.CopyFuture;
import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.FulfillmentException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ProtocolDispatchException;
import com.mathworks.toolbox.distcomp.remote.spi.Lease;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.CouldNotConnectJSchChannelException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.FilePermissions;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchDirectoryMissingException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchFutureHelper;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchLeasableSession;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSCPAcknowledgeException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSCPCommandException;
import com.mathworks.toolbox.distcomp.remote.spi.plugin.JSchSessionLeaseSource;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.BufferedOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.logging.Level;

final class JSchCopyFromFuture
implements CopyFuture,
Runnable {
    private final JSchFutureHelper fHelper;
    private final CopyFromRemoteCommand fCommand;
    private static final int BUFFER_SIZE = 16384;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static JSchCopyFromFuture createJschCopyFromFuture(CopyFromRemoteCommand copyFromRemoteCommand, String string, ParameterMap parameterMap, String string2) throws DispatchException {
        boolean bl = false;
        Lease<JSchLeasableSession> lease = null;
        try {
            lease = JSchSessionLeaseSource.INSTANCE.getLease(string, parameterMap);
            JSchCopyFromFuture jSchCopyFromFuture = new JSchCopyFromFuture(copyFromRemoteCommand, lease, string2);
            JSchFutureHelper.startThread(jSchCopyFromFuture, string2);
            bl = true;
            JSchCopyFromFuture jSchCopyFromFuture2 = jSchCopyFromFuture;
            return jSchCopyFromFuture2;
        }
        finally {
            if (!bl && lease != null) {
                lease.release();
            }
        }
    }

    private JSchCopyFromFuture(CopyFromRemoteCommand copyFromRemoteCommand, Lease<JSchLeasableSession> lease, String string) throws ProtocolDispatchException {
        try {
            this.fCommand = copyFromRemoteCommand;
            String string2 = JSchCopyFromFuture.createScpCommand(this.fCommand.getRemoteFile());
            ChannelExec channelExec = JSchCopyFromFuture.createChannelExec(lease.getLeasedConnection().getSession(), string2, string);
            this.fHelper = new JSchFutureHelper(lease, (Channel)channelExec, string);
        }
        catch (JSchException jSchException) {
            throw new CouldNotConnectJSchChannelException(string, jSchException);
        }
    }

    private static String createScpCommand(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("scp ");
        stringBuilder.append("-d -r -f ");
        stringBuilder.append("\"");
        stringBuilder.append(string);
        stringBuilder.append("\"");
        return stringBuilder.toString();
    }

    private static ChannelExec createChannelExec(Session session, String string, String string2) throws JSchException {
        ChannelExec channelExec = (ChannelExec)session.openChannel("exec");
        channelExec.setCommand(string);
        Logger.LOGGER.finest(string2 + " " + string);
        return channelExec;
    }

    @Override
    public void cancel() {
        this.fHelper.cancel();
    }

    @Override
    public boolean isRunning() {
        return this.fHelper.isRunning();
    }

    @Override
    public void awaitEnd() throws InterruptedException, FulfillmentException {
        this.fHelper.awaitEnd();
    }

    public boolean isExitStatusOfRemoteCommand() {
        return this.fHelper.isExitStatusOfRemoteCommand();
    }

    public int getExitStatus() throws InterruptedException, FulfillmentException {
        return this.fHelper.getExitStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            try {
                try {
                    if (!this.fHelper.hasBeenCancelled()) {
                        this.fHelper.connectToChannel();
                        this.copyFilesFrom();
                    }
                }
                catch (InterruptedException interruptedException) {
                    Logger.LOGGER.log(Level.FINE, this.fHelper.getLogIDString() + ": interrupted", interruptedException);
                }
                catch (Exception exception) {
                    this.fHelper.handleException(exception);
                }
                finally {
                    this.fHelper.disconnectFromChannel();
                }
            }
            finally {
                this.fHelper.releaseLease();
            }
        }
        finally {
            this.fHelper.signalCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void copyFilesFrom() throws IOException, InterruptedException, JSchSCPAcknowledgeException, JSchSCPCommandException {
        File file = this.findTargetDirectory();
        try (OutputStream outputStream = null;){
            outputStream = this.fHelper.getOutputStream();
            try (InputStream inputStream = null;){
                inputStream = this.fHelper.getInputStream();
                this.copyFilesFrom(true, file, inputStream, outputStream);
            }
        }
        this.fHelper.waitForChannelToClose();
        Logger.LOGGER.fine(this.fHelper.getLogIDString() + ": completed ");
    }

    private File findTargetDirectory() {
        File file = this.getLocalFile().getAbsoluteFile().getParentFile();
        if (this.getLocalFile().isDirectory()) {
            file = this.getLocalFile().getAbsoluteFile();
        }
        return file;
    }

    private File getLocalFile() {
        return this.fCommand.getLocalFile();
    }

    private boolean checkCancelled(OutputStream outputStream) throws IOException {
        boolean bl = this.fHelper.hasBeenCancelled();
        if (bl) {
            this.sendAck(2, outputStream);
        }
        return bl;
    }

    private void copyFilesFrom(boolean bl, File file, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPAcknowledgeException, JSchSCPCommandException {
        if (bl) {
            this.sendAck(0, outputStream);
        }
        boolean bl2 = true;
        do {
            if (!this.checkCancelled(outputStream)) {
                int n = inputStream.read();
                if (n == 67) {
                    this.copyFileFrom(bl, file, inputStream, outputStream);
                    continue;
                }
                if (n == 68) {
                    this.copyDirectoryFrom(bl, file, inputStream, outputStream);
                    continue;
                }
                if (n == 69) {
                    this.receiveLine(inputStream);
                    this.sendAck(0, outputStream);
                    bl2 = false;
                    continue;
                }
                if (n == 84) {
                    this.receiveLine(inputStream);
                    Logger.LOGGER.warning(this.fHelper.getLogIDString() + ": T not supported. Can not preserve access and modifications times.");
                    continue;
                }
                if (n == -1) {
                    if (!bl) {
                        throw new JSchSCPEOFException(this.fHelper.getLogIDString());
                    }
                    bl2 = false;
                    continue;
                }
                if (n == 1 || n == 2) {
                    String string = this.receiveLine(inputStream);
                    throw new JSchSCPCommandErrorException(n, string);
                }
                String string = this.receiveLine(inputStream);
                throw new JSchSCPCommandInterpretationException(n, string);
            }
            bl2 = false;
        } while (bl2);
    }

    private void setFilePermissions(byte[] byArray, File file) {
        byte[] byArray2 = new byte[]{byArray[1]};
        byte[] byArray3 = new byte[]{byArray[3]};
        byte by = Byte.parseByte(new String(byArray2));
        byte by2 = Byte.parseByte(new String(byArray3));
        boolean bl = (by & 1) != 0;
        boolean bl2 = (by & 2) != 0;
        boolean bl3 = (by & 4) != 0;
        boolean bl4 = (by2 & 1) != 0;
        boolean bl5 = (by2 & 2) != 0;
        boolean bl6 = (by2 & 4) != 0;
        FilePermissions filePermissions = new FilePermissions(bl, bl3, bl2, bl4, bl6, bl5);
        filePermissions.setPermisions(file, this.fHelper.getLogIDString());
    }

    private void copyDirectoryFrom(boolean bl, File file, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPAcknowledgeException, JSchSCPCommandException {
        File file2;
        String string;
        byte[] byArray = this.receiveBytes(5, inputStream);
        String string2 = this.receiveLine(inputStream);
        String string3 = string2.substring(0, string2.indexOf(32));
        try {
            long l = Long.parseLong(string3);
            if (l != 0L) {
                throw new JSchSCPDirectoryFileLengthException(l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSchSCPDirectoryFormatException(string2, numberFormatException);
        }
        String string4 = string2.substring(string2.indexOf(32) + 1, string2.length());
        if (bl) {
            string4 = this.getLocalFile().getName();
        }
        if (!this.fCommand.isExcluded(string = this.createRemotePath(file2 = bl && this.getLocalFile().getAbsoluteFile().equals(file) ? file : new File(file, string4)))) {
            boolean bl2 = file2.exists() && file2.isDirectory();
            boolean bl3 = file2.mkdir();
            if (!bl2 && !bl3) {
                throw new JSchDirectoryMissingException(this.fHelper.getLogIDString(), file2);
            }
            Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": created directory " + file2);
            this.setFilePermissions(byArray, file2);
        }
        this.sendAck(0, outputStream);
        this.copyFilesFrom(false, file2, inputStream, outputStream);
    }

    private void copyFileFrom(boolean bl, File file, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPAcknowledgeException, JSchSCPCommandException {
        long l;
        byte[] byArray = this.receiveBytes(5, inputStream);
        String string = this.receiveLine(inputStream);
        String string2 = string.substring(0, string.indexOf(32));
        try {
            l = Long.parseLong(string2);
            if (l < 0L) {
                throw new JSchSCPFileLengthException(l);
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new JSchSCPFileFormatException(string, numberFormatException);
        }
        String string3 = string.substring(string.indexOf(32) + 1, string.length());
        if (bl && !this.getLocalFile().isDirectory()) {
            string3 = this.getLocalFile().getName();
        }
        this.sendAck(0, outputStream);
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + " about to receive : size=" + l + ", name=" + string3);
        File file2 = new File(file, string3);
        String string4 = this.createRemotePath(file2);
        if (!this.fCommand.isExcluded(string4)) {
            this.receiveFile(file2, l, inputStream, outputStream);
            this.setFilePermissions(byArray, file2);
        } else {
            this.drainBitsOfFile(l, inputStream, outputStream);
        }
        this.checkAck(inputStream);
        this.sendAck(0, outputStream);
        Logger.LOGGER.finest(this.fHelper.getLogIDString() + " received : file size=" + l + ", file=" + string3);
    }

    private String createRemotePath(File file) {
        URI uRI;
        URI uRI2 = this.fCommand.getLocalFile().toURI();
        URI uRI3 = uRI2.relativize(uRI = file.toURI());
        String string = uRI3.getPath();
        if ("".equals(string)) {
            return this.fCommand.getRemoteFile();
        }
        return this.fCommand.getRemoteFile() + "/" + string;
    }

    private int checkAck(InputStream inputStream) throws IOException, JSchSCPAcknowledgeException {
        int n;
        int n2 = inputStream.read();
        if (n2 == 0 || n2 == -1) {
            return n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            n = inputStream.read();
            stringBuilder.append((char)n);
        } while (n != 10 && n != -1);
        if (n2 == 1) {
            throw new JSchSCPErrorException(stringBuilder.toString(), n2);
        }
        if (n2 == 2) {
            throw new JSchSCPFatalErrorException(stringBuilder.toString(), n2);
        }
        throw new JSchSCPUnknownCodeException(stringBuilder.toString(), n2);
    }

    private void sendAck(int n, OutputStream outputStream) throws IOException {
        outputStream.write(n);
        outputStream.flush();
    }

    private byte[] receiveBytes(int n, InputStream inputStream) throws IOException, JSchSCPCommandException {
        byte[] byArray = new byte[n];
        int n2 = inputStream.read(byArray, 0, n);
        if (n2 != n) {
            throw new JSchSCPBytesReadException(n, n2);
        }
        return byArray;
    }

    private String receiveLine(InputStream inputStream) throws IOException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        do {
            if ((n = inputStream.read()) == -1 || n == 10) continue;
            stringBuilder.append((char)n);
        } while (n != -1 && n != 10);
        return stringBuilder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receiveFile(File file, long l, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPCommandException {
        try (OutputStream outputStream2 = null;){
            boolean bl;
            int n;
            outputStream2 = new BufferedOutputStream(new FileOutputStream(file));
            byte[] byArray = new byte[16384];
            long l2 = 0L;
            int n2 = byArray.length;
            do {
                if ((long)n2 >= l - l2) {
                    n2 = (int)(l - l2);
                }
                if ((n = inputStream.read(byArray, 0, n2)) != n2) {
                    Logger.LOGGER.finest(this.fHelper.getLogIDString() + ": expected to read " + n2 + " for " + file + " but received " + n);
                }
                if (n > 0) {
                    outputStream2.write(byArray, 0, n);
                } else {
                    if (n == -1) {
                        throw new PrematureEOFException(l, file, l2);
                    }
                    if (n2 > 0 && n == 0) {
                        throw new IllegalStateException(this.fHelper.getLogIDString() + ": received unexpected value from read() " + n + " while receiving " + file);
                    }
                }
                bl = this.checkCancelled(outputStream);
            } while ((l2 += (long)n) < l && !bl);
            if (bl) {
                Logger.LOGGER.warning(this.fHelper.getLogIDString() + ": cancelled after receiving " + l2 + " bytes of " + file);
            }
        }
    }

    private void drainBitsOfFile(long l, InputStream inputStream, OutputStream outputStream) throws IOException, JSchSCPCommandException {
        boolean bl;
        int n;
        byte[] byArray = new byte[16384];
        long l2 = 0L;
        int n2 = byArray.length;
        do {
            if ((long)n2 > l - l2) {
                n2 = (int)(l - l2);
            }
            if ((n = inputStream.read(byArray, 0, n2)) != n2) {
                throw new JSchSCPCommandBitsReadException(n2, n);
            }
            bl = this.checkCancelled(outputStream);
        } while ((l2 += (long)n) < l && !bl);
        if (bl) {
            Logger.LOGGER.warning(this.fHelper.getLogIDString() + ": cancelled after receiving " + l2 + " bytes");
        }
    }

    private static final class JSchSCPCommandBitsReadException
    extends JSchSCPCommandException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPCommandBitsReadException(int n, int n2) {
            this.fBaseMsgID = new remote.JSchSCPBytesRead(Integer.toString(n), Integer.toString(n2));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class PrematureEOFException
    extends EOFException
    implements I18nMatlabIdentifiedException {
        private final XMLMessageCreator fErrorMessageCreator = new XMLMessageCreator();
        private final BaseMsgID fBaseMsgID;

        PrematureEOFException(long l, File file, long l2) {
            this.fBaseMsgID = new remote.PrematureEOF(Long.toString(l), file.toString(), Long.toString(l2));
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.fBaseMsgID);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.fBaseMsgID);
        }

        public String getMessageID() {
            return this.fBaseMsgID.getCatalogId() + ":" + this.fBaseMsgID.getMessageId();
        }
    }

    private static final class JSchSCPBytesReadException
    extends JSchSCPCommandException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPBytesReadException(int n, int n2) {
            this.fBaseMsgID = new remote.JSchSCPBytesRead(Integer.toString(n), Integer.toString(n2));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSCPUnknownCodeException
    extends JSchSCPAcknowledgeException {
        private final BaseMsgID fBaseMsgID = new remote.JSchSCPUnknownAck(this.getAckAsString(), this.getRawMessage());

        JSchSCPUnknownCodeException(String string, int n) {
            super(string, n);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSCPFatalErrorException
    extends JSchSCPAcknowledgeException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPFatalErrorException(String string, int n) {
            super(string, n);
            if (n != 2) {
                throw new IllegalArgumentException("ack must be 2 but is " + n);
            }
            this.fBaseMsgID = new remote.JSchSCPFatalAckError(this.getRawMessage());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSCPErrorException
    extends JSchSCPAcknowledgeException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPErrorException(String string, int n) {
            super(string, n);
            if (n != 1) {
                throw new IllegalArgumentException("ack must be 1 but is " + n);
            }
            this.fBaseMsgID = new remote.JSchSCPAckError(this.getRawMessage());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSCPFileFormatException
    extends JSchSCPCommandException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPFileFormatException(String string, NumberFormatException numberFormatException) {
            super(numberFormatException);
            this.fBaseMsgID = new remote.JSchSCPFileFormat(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSCPFileLengthException
    extends JSchSCPCommandException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPFileLengthException(long l) {
            this.fBaseMsgID = new remote.JSchSCPFileLength(Long.toString(l));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSCPDirectoryFormatException
    extends JSchSCPCommandException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPDirectoryFormatException(String string, NumberFormatException numberFormatException) {
            super(numberFormatException);
            this.fBaseMsgID = new remote.JSchSCPDirectoryFormat(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSCPDirectoryFileLengthException
    extends JSchSCPCommandException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPDirectoryFileLengthException(long l) {
            this.fBaseMsgID = new remote.JSchSCPDirectoryFormat(Long.toString(l));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSCPCommandInterpretationException
    extends JSchSCPCommandException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPCommandInterpretationException(Integer n, String string) {
            this.fBaseMsgID = new remote.JSchSCPCommandInterpretation(Integer.toString(n), string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSCPCommandErrorException
    extends JSchSCPCommandException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPCommandErrorException(Integer n, String string) {
            this.fBaseMsgID = new remote.JSchSCPCommandError(Integer.toString(n), string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class JSchSCPEOFException
    extends JSchSCPCommandException {
        private final BaseMsgID fBaseMsgID;

        JSchSCPEOFException(String string) {
            this.fBaseMsgID = new remote.JSchSCPEOF(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

