/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote.spi;

import com.mathworks.toolbox.distcomp.remote.DispatchException;
import com.mathworks.toolbox.distcomp.remote.Logger;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.spi.LeasableConnection;
import com.mathworks.toolbox.distcomp.remote.spi.Lease;
import com.mathworks.toolbox.distcomp.remote.spi.LeaseSource;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public final class LeaseMonitor<T extends LeasableConnection> {
    private final T fLeasedConnection;
    private final LeaseSource<T> fLeaseSource;
    private final String fHostname;
    private final ParameterMap fParameterMap;
    private final int fLeaseLimit;
    private final int fIdleSecondsBeforeDisconnect;
    private final Set<Lease> fLeases = new HashSet<Lease>();
    private final String fLogIdString;
    private final Lock fLock = new ReentrantLock();

    public LeaseMonitor(T t, LeaseSource<T> leaseSource, String string, ParameterMap parameterMap, int n, int n2) throws DispatchException {
        this.fHostname = string;
        this.fParameterMap = parameterMap;
        this.fLeaseSource = leaseSource;
        this.fLeaseLimit = n;
        this.fIdleSecondsBeforeDisconnect = n2;
        this.fLeasedConnection = t;
        this.fLeasedConnection.connect();
        this.fLogIdString = string + " : ";
    }

    public LeaseMonitor(T t, String string, ParameterMap parameterMap, int n, int n2) throws DispatchException {
        this.fHostname = string;
        this.fParameterMap = parameterMap;
        this.fLeaseSource = null;
        this.fLeaseLimit = n;
        this.fIdleSecondsBeforeDisconnect = n2;
        this.fLeasedConnection = t;
        this.fLeasedConnection.connect();
        this.fLogIdString = string + " : ";
    }

    public String getHostname() {
        return this.fHostname;
    }

    public ParameterMap getParameterMap() {
        return this.fParameterMap;
    }

    public LeaseSource<T> getLeaseSource() {
        return this.fLeaseSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lease<T> claim() {
        try {
            this.fLock.lock();
            if (this.fLeases.size() >= this.fLeaseLimit) {
                Logger.LOGGER.warning(this.fLogIdString + this.fLeases.size() + " leases outstanding. Lease limit is " + this.fLeaseLimit);
            } else {
                Logger.LOGGER.finest(this.fLogIdString + this.fLeases.size() + " leases outstanding.");
            }
            Lease lease = new Lease(this);
            this.fLeases.add(lease);
            Lease lease2 = lease;
            return lease2;
        }
        finally {
            this.fLock.unlock();
        }
    }

    public int getIdleSecondsBeforeDisconnect() {
        return this.fIdleSecondsBeforeDisconnect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getLeasedConnection() {
        try {
            this.fLock.lock();
            T t = this.fLeasedConnection;
            return t;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean noLeasesOutstanding() {
        try {
            this.fLock.lock();
            boolean bl = this.fLeases.isEmpty();
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Lease<T> lease) {
        try {
            this.fLock.lock();
            boolean bl = this.fLeases.remove(lease);
            if (bl) {
                Logger.LOGGER.finest(this.fLogIdString + " lease released. " + this.fLeases.size() + " outstanding.");
            } else {
                Logger.LOGGER.warning(this.fLogIdString + " lease not found. " + this.fLeases.size() + " outstanding.");
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnectWithNoRelease() {
        try {
            this.fLock.lock();
            this.fLeasedConnection.disconnect();
            if (this.fLeases.isEmpty()) {
                Logger.LOGGER.fine(this.fLogIdString + "session disconnected");
            } else {
                Logger.LOGGER.warning(this.fLogIdString + "session disconnected with " + this.fLeases.size() + " outstanding leases.");
            }
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disconnectIfNoLeasesOutstanding() {
        try {
            this.fLock.lock();
            if (this.fLeases.isEmpty()) {
                this.fLeasedConnection.disconnect();
                Logger.LOGGER.fine(this.fLogIdString + "session disconnected");
                boolean bl = true;
                return bl;
            }
            Logger.LOGGER.finest(this.fLogIdString + "Not disconnected due to " + this.fLeases + " outstanding leases.");
            boolean bl = false;
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnected() {
        try {
            this.fLock.lock();
            boolean bl = this.fLeasedConnection.isConnected();
            return bl;
        }
        finally {
            this.fLock.unlock();
        }
    }
}

