/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.toolbox.distcomp.remote.CredentialParameter;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;

public final class ParameterSet {
    private final Set<Parameter<?>> fSet;
    private final CredentialParameter fCredentialParameter;
    public static final ParameterSet EMPTY = new ParameterSet(new Parameter[0]);

    public ParameterSet(Parameter<?> ... parameterArray) {
        LinkedHashSet linkedHashSet = new LinkedHashSet();
        CredentialParameter credentialParameter = null;
        for (Parameter<?> parameter : parameterArray) {
            linkedHashSet.add(parameter);
            if (!(parameter instanceof CredentialParameter)) continue;
            if (credentialParameter == null) {
                credentialParameter = (CredentialParameter)parameter;
                continue;
            }
            throw new IllegalArgumentException("At most one CredentialParameter per ParameterSet, not both " + credentialParameter + " and " + parameter);
        }
        this.fCredentialParameter = credentialParameter;
        this.fSet = Collections.unmodifiableSet(linkedHashSet);
    }

    public Set<Parameter<?>> getParameters() {
        return this.fSet;
    }

    public CredentialParameter getCredentialParameter() {
        return this.fCredentialParameter;
    }

    public boolean hasCredentialParameter() {
        return null != this.fCredentialParameter;
    }

    public String toString() {
        return "ParameterSet{fSet=" + this.fSet + ", fCredentialParameter=" + this.fCredentialParameter + '}';
    }
}

