/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.remote;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.remote;
import com.mathworks.toolbox.distcomp.remote.Credential;
import com.mathworks.toolbox.distcomp.remote.CredentialDescription;
import com.mathworks.toolbox.distcomp.remote.IdentityFileCredential;
import com.mathworks.toolbox.distcomp.remote.InvalidValueException;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterInCredential;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.ParameterSet;
import com.mathworks.toolbox.distcomp.remote.Password;
import com.mathworks.toolbox.distcomp.remote.PasswordNullException;
import com.mathworks.toolbox.distcomp.remote.UsernameEmptyException;
import com.mathworks.toolbox.distcomp.remote.UsernameNullException;
import java.io.File;

public final class IdentityFileCredentialDescription
implements CredentialDescription {
    public static final IdentityFileCredentialDescription INSTANCE = new IdentityFileCredentialDescription();
    public static final ParameterInCredential<String> USERNAME = new ParameterInCredential<String>((Parameter.PersistentKey)PersistentKey.USERNAME, false, true, String.class, System.getProperty("user.name")){

        @Override
        public void checkValueImpl(String string) throws InvalidValueException {
            if (string == null) {
                throw new UsernameNullException(this);
            }
            if (string.isEmpty()) {
                throw new UsernameEmptyException(this);
            }
        }
    };
    public static final ParameterInCredential<File> IDENTITY_FILE = new ParameterInCredential<File>((Parameter.PersistentKey)PersistentKey.IDENTITY_FILE, true, false, File.class){

        @Override
        public void checkValueImpl(File file) throws InvalidValueException {
            if (file == null) {
                throw new IdentityFileNullException(this);
            }
            if (!file.exists()) {
                throw new IdentityFileEmptyException(this);
            }
            if (!file.isFile()) {
                throw new IdentityFileFormatException(this, file);
            }
        }
    };
    public static final ParameterInCredential<Password> PASSPHRASE = new ParameterInCredential<Password>((Parameter.PersistentKey)PersistentKey.PASSPHRASE, false, true, Password.class){

        @Override
        public void checkValueImpl(Password password) throws InvalidValueException {
            if (password == null) {
                throw new PasswordNullException(this);
            }
        }
    };
    private static final ParameterSet PARAMETERS = new ParameterSet(USERNAME, IDENTITY_FILE, PASSPHRASE);

    private IdentityFileCredentialDescription() {
    }

    @Override
    public ParameterSet getParameterSet() {
        return PARAMETERS;
    }

    @Override
    public Credential create(ParameterMap parameterMap) {
        return new IdentityFileCredential(parameterMap);
    }

    private static final class IdentityFileFormatException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        IdentityFileFormatException(Parameter<?> parameter, File file) {
            this.fBaseMsgID = new remote.IdentityFileFormat(parameter.getPersistentKey().toString(), file.getName());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class IdentityFileEmptyException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        IdentityFileEmptyException(Parameter<?> parameter) {
            this.fBaseMsgID = new remote.IdentityFileNull(parameter.getPersistentKey().toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class IdentityFileNullException
    extends InvalidValueException {
        private final BaseMsgID fBaseMsgID;

        IdentityFileNullException(Parameter<?> parameter) {
            this.fBaseMsgID = new remote.IdentityFileNull(parameter.getPersistentKey().toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static enum PersistentKey implements Parameter.PersistentKey
    {
        USERNAME,
        IDENTITY_FILE,
        PASSPHRASE;

    }
}

