/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.process;

import com.mathworks.toolbox.distcomp.process.IoPipeInputStream;
import com.mathworks.toolbox.distcomp.process.PackageInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;

final class IoPipeStreamRedirector
implements Runnable {
    private static final Logger LOGGER = PackageInfo.LOGGER;
    private final IoPipeInputStream fInput;
    private final OutputStream fOutput;
    private final Lock fEofLock = new ReentrantLock();
    private final Condition fEofCondition = this.fEofLock.newCondition();
    private boolean fEof = false;

    IoPipeStreamRedirector(IoPipeInputStream ioPipeInputStream, OutputStream outputStream) {
        this.fInput = ioPipeInputStream;
        this.fOutput = outputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void signalEof() {
        this.fEofLock.lock();
        try {
            this.fEof = true;
            this.fEofCondition.signalAll();
            LOGGER.log(DistcompLevel.SIX, "IoPipeStreamRedirector: signaled EoF");
        }
        finally {
            this.fEofLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean awaitEof() throws InterruptedException {
        this.fEofLock.lock();
        try {
            if (!this.fEof) {
                LOGGER.log(DistcompLevel.SIX, "IoPipeStreamRedirector: waiting for EoF");
                this.fEofCondition.await();
                LOGGER.log(DistcompLevel.SIX, "IoPipeStreamRedirector: finished waiting for EoF");
            }
            boolean bl = this.fEof;
            return bl;
        }
        finally {
            this.fEofLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int n;
            LOGGER.log(DistcompLevel.SIX, "IoPipeStreamRedirector: run() redirector.");
            do {
                if ((n = this.fInput.read()) == -1) continue;
                this.fOutput.write(n);
                this.fOutput.flush();
            } while (n != -1);
            this.fInput.close();
        }
        catch (IOException iOException) {
            LOGGER.log(DistcompLevel.TWO, "IoPipeStreamRedirector: Problem in redirector.", iOException);
        }
        finally {
            this.signalEof();
            LOGGER.log(DistcompLevel.SIX, "IoPipeStreamRedirector: finished run() redirector.");
        }
    }
}

