/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.taskqueue;

import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.AsynchronousEvaluationRequest;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.CancellationRequest;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.EvaluationRequest;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Log;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.SynchronousEvaluationRequest;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskDiaryMessage;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskDispatcher;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.TaskQueueRequestMessage;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public final class TaskDispatcherImpl
implements TaskDispatcher {
    private static final String CLASS = TaskDispatcherImpl.class.getSimpleName();
    private final SessionService fSession;
    private final CommunicationGroup fCommGroup;
    private final ExecutorService fExecutor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(CLASS + " fExecutor-"), (Logger)Log.LOGGER));
    private final Map<Long, Future<Object>> fTaskIdFutures = new ConcurrentHashMap<Long, Future<Object>>();

    public TaskDispatcherImpl(SessionService sessionService, CommunicationGroup communicationGroup) {
        this.fSession = sessionService;
        this.fCommGroup = communicationGroup;
    }

    public void shutdown() {
        assert (!this.fExecutor.isShutdown());
        this.fExecutor.shutdownNow();
    }

    private void returnResult(EvaluationRequest evaluationRequest, Object object, long l, Instance instance) {
        long l2 = evaluationRequest.getTaskID();
        Log.LOGGER.log(DistcompLevel.THREE, CLASS + ".returnResult returning:" + l2);
        this.fCommGroup.returnTo(instance, (ReturnMessage)evaluationRequest.buildResult(l, l2, object, null));
    }

    private void returnProblem(EvaluationRequest evaluationRequest, Throwable throwable, long l, Instance instance) {
        long l2 = evaluationRequest.getTaskID();
        Log.LOGGER.log(DistcompLevel.THREE, CLASS + ".returnProblem returning:" + l2);
        this.fCommGroup.returnTo(instance, (ReturnMessage)evaluationRequest.buildResult(l, l2, null, throwable));
    }

    private void handleSynchronousEvaluationRequest(long l, SynchronousEvaluationRequest synchronousEvaluationRequest, Instance instance) {
        long l2 = synchronousEvaluationRequest.getTaskID();
        Log.LOGGER.log(DistcompLevel.THREE, CLASS + " Incoming synchronous evaluation request " + l2);
        Future<Object> future = this.fExecutor.submit(new SynchronousEvaluation(synchronousEvaluationRequest, l, instance));
        this.fTaskIdFutures.put(l2, future);
    }

    private void handleAsynchronousEvaluationRequest(long l, AsynchronousEvaluationRequest asynchronousEvaluationRequest, Instance instance) {
        long l2 = asynchronousEvaluationRequest.getTaskID();
        Log.LOGGER.log(DistcompLevel.THREE, CLASS + " Incoming asynchronous evaluation request " + l2);
        Future<Object> future = this.fExecutor.submit(new AsynchronousEvaluation(asynchronousEvaluationRequest, l, instance));
        this.fTaskIdFutures.put(l2, future);
    }

    private void handleCancellationRequest(CancellationRequest cancellationRequest) {
        long l = cancellationRequest.getTaskID();
        Log.LOGGER.log(DistcompLevel.THREE, CLASS + ".handleCancellationRequest for ID: " + l);
        Future<Object> future = this.fTaskIdFutures.remove(cancellationRequest.getTaskID());
        if (future != null) {
            Log.LOGGER.log(DistcompLevel.THREE, CLASS + " cancelling future for " + l + ", future: " + future);
            boolean bl = future.cancel(true);
            Log.LOGGER.log(DistcompLevel.THREE, CLASS + " cancel result was: " + bl);
        } else {
            Log.LOGGER.log(DistcompLevel.THREE, CLASS + " no future to cancel for: " + l);
        }
    }

    @Override
    public synchronized void dispatch(TaskQueueRequestMessage taskQueueRequestMessage, Instance instance) {
        if (taskQueueRequestMessage instanceof SynchronousEvaluationRequest) {
            this.handleSynchronousEvaluationRequest(taskQueueRequestMessage.getSequenceNumber(), (SynchronousEvaluationRequest)taskQueueRequestMessage, instance);
        } else if (taskQueueRequestMessage instanceof AsynchronousEvaluationRequest) {
            this.handleAsynchronousEvaluationRequest(taskQueueRequestMessage.getSequenceNumber(), (AsynchronousEvaluationRequest)taskQueueRequestMessage, instance);
        } else if (taskQueueRequestMessage instanceof CancellationRequest) {
            this.handleCancellationRequest((CancellationRequest)taskQueueRequestMessage);
        } else {
            Log.LOGGER.log(DistcompLevel.ONE, CLASS + ".dispatch() on unknown message type: " + taskQueueRequestMessage.getClass());
            assert (false);
        }
    }

    private final class AsynchronousEvaluation
    implements Callable<Object> {
        private final long fSequence;
        private final long fTaskID;
        private final Instance fSrcID;
        private final AsynchronousEvaluationRequest fRequest;

        private AsynchronousEvaluation(AsynchronousEvaluationRequest asynchronousEvaluationRequest, long l, Instance instance) {
            this.fRequest = asynchronousEvaluationRequest;
            this.fSequence = l;
            this.fTaskID = asynchronousEvaluationRequest.getTaskID();
            this.fSrcID = instance;
        }

        private Object getWhileDraining(long l, Future<Object> future, DrainableWriter drainableWriter) throws ExecutionException, InterruptedException {
            boolean bl = false;
            Object object = null;
            while (!bl) {
                String string;
                try {
                    object = future.get(100L, TimeUnit.MILLISECONDS);
                    bl = true;
                }
                catch (TimeoutException timeoutException) {
                }
                catch (InterruptedException interruptedException) {
                    if (TaskDispatcherImpl.this.fTaskIdFutures.containsKey(l)) {
                        Log.LOGGER.info("TaskDispatcherImpl/getWhileDraining detected spurious cancellation.");
                    }
                    throw interruptedException;
                }
                if ((string = drainableWriter.drain()).isEmpty()) continue;
                TaskDispatcherImpl.this.fCommGroup.returnTo(this.fSrcID, (ReturnMessage)new TaskDiaryMessage(this.fSequence, this.fTaskID, string));
            }
            return object;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() {
            long l = this.fRequest.getTaskID();
            Log.LOGGER.log(DistcompLevel.THREE, CLASS + "$AsynchronousEvaluation.call() for task ID: " + l);
            Future<Object> future = null;
            try (DrainableWriter drainableWriter = new DrainableWriter();){
                future = this.fRequest.evaluate(TaskDispatcherImpl.this.fSession, drainableWriter, drainableWriter);
                Object object = this.getWhileDraining(l, future, drainableWriter);
                TaskDispatcherImpl.this.returnResult(this.fRequest, object, this.fSequence, this.fSrcID);
            }
            catch (InterruptedException interruptedException) {
                Log.LOGGER.log(DistcompLevel.TWO, CLASS + "$AsynchronousEvaluation.call() interrupted during task ID: " + l, interruptedException);
                if (future != null) {
                    Log.LOGGER.log(DistcompLevel.TWO, CLASS + "$AsynchronousEvaluation.call() cancelling underlyingFuture: " + future);
                    future.cancel(true);
                }
                TaskDispatcherImpl.this.returnProblem(this.fRequest, interruptedException, this.fSequence, this.fSrcID);
            }
            catch (ExecutionException executionException) {
                Log.LOGGER.log(DistcompLevel.TWO, CLASS + "$AsynchronousEvaluation.call() caught exception during asynchronous evaluation of " + l, executionException);
                TaskDispatcherImpl.this.returnProblem(this.fRequest, executionException.getCause(), this.fSequence, this.fSrcID);
            }
            catch (Throwable throwable) {
                Log.LOGGER.log(DistcompLevel.TWO, CLASS + "$AsynchronousEvaluation.call() caught exception during asynchronous evaluation of " + l, throwable);
                TaskDispatcherImpl.this.returnProblem(this.fRequest, throwable, this.fSequence, this.fSrcID);
            }
            finally {
                TaskDispatcherImpl.this.fTaskIdFutures.remove(this.fTaskID);
            }
            Log.LOGGER.log(DistcompLevel.THREE, CLASS + "$AsynchronousEvaluation.call() completed asynchronous task ID: " + l);
            return null;
        }
    }

    private static final class DrainableWriter
    extends Writer {
        private final StringWriter fWriter = new StringWriter();

        private DrainableWriter() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(char[] cArray, int n, int n2) throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.fWriter.write(cArray, n, n2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                this.fWriter.flush();
            }
        }

        @Override
        public void close() throws IOException {
            this.fWriter.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private String drain() {
            Object object = this.lock;
            synchronized (object) {
                String string = this.fWriter.toString();
                StringBuffer stringBuffer = this.fWriter.getBuffer();
                stringBuffer.delete(0, stringBuffer.length());
                return string;
            }
        }
    }

    private final class SynchronousEvaluation
    implements Callable<Object> {
        private final SynchronousEvaluationRequest fRequest;
        private final long fSequence;
        private final Instance fSrcID;

        private SynchronousEvaluation(SynchronousEvaluationRequest synchronousEvaluationRequest, long l, Instance instance) {
            this.fRequest = synchronousEvaluationRequest;
            this.fSequence = l;
            this.fSrcID = instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object call() {
            long l = this.fRequest.getTaskID();
            Log.LOGGER.log(DistcompLevel.THREE, CLASS + "$SynchronousEvaluation.call() starting synchronous task ID: " + l);
            try {
                StringWriter stringWriter = new StringWriter(0);
                StringWriter stringWriter2 = new StringWriter(0);
                Object object = this.fRequest.evaluate(TaskDispatcherImpl.this.fSession, stringWriter, stringWriter2);
                TaskDispatcherImpl.this.returnResult(this.fRequest, object, this.fSequence, this.fSrcID);
            }
            catch (Throwable throwable) {
                Log.LOGGER.log(DistcompLevel.TWO, CLASS + "$SynchronousEvaluation.call() caught exception during synchronous evaluation of " + l, throwable);
                TaskDispatcherImpl.this.returnProblem(this.fRequest, throwable, this.fSequence, this.fSrcID);
            }
            finally {
                TaskDispatcherImpl.this.fTaskIdFutures.remove(l);
            }
            Log.LOGGER.log(DistcompLevel.THREE, CLASS + "$SynchronousEvaluation.call() completed synchronous task ID: " + l);
            return null;
        }
    }
}

