/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.taskqueue;

import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.AbstractRemoteFuture;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.EvaluationResult;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.RemoteBroadcastFuture;
import com.mathworks.toolbox.distcomp.pmode.taskqueue.Task;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DefaultBroadcastRemoteFuture
extends AbstractRemoteFuture<Map<Instance, EvaluationResult>>
implements RemoteBroadcastFuture {
    private final List<Instance> fWorkers = new ArrayList<Instance>();
    private final Map<Instance, StringBuilder> fDiaries = new HashMap<Instance, StringBuilder>();
    private final Map<Instance, EvaluationResult> fResults = new HashMap<Instance, EvaluationResult>();

    @Override
    public synchronized Collection<Instance> getWorkers() {
        return new ArrayList<Instance>(this.fWorkers);
    }

    @Override
    public synchronized String getDiary(Instance instance) {
        if (this.fDiaries.containsKey(instance)) {
            return this.fDiaries.get(instance).toString();
        }
        return "";
    }

    @Override
    public synchronized void startedRunning(List<Instance> list) {
        assert (this.getState() == Task.State.QUEUED) : "Task should be queued before running";
        this.fWorkers.addAll(list);
        for (Instance instance : list) {
            this.fDiaries.put(instance, new StringBuilder());
        }
        this.setState(Task.State.RUNNING);
    }

    @Override
    public synchronized void appendDiary(String string, Instance instance) {
        assert (this.getState() == Task.State.RUNNING) : "Cannot append diary until task is running";
        assert (this.fDiaries.containsKey(instance));
        this.fDiaries.get(instance).append(string);
    }

    @Override
    public synchronized boolean setResult(EvaluationResult evaluationResult, Instance instance) {
        assert (this.getState() == Task.State.RUNNING) : "Cannot set result until task is running";
        EvaluationResult evaluationResult2 = this.fResults.put(instance, evaluationResult);
        assert (evaluationResult2 == null) : "Unexpectedly already had result.";
        if (this.fResults.size() == this.fWorkers.size()) {
            this.set(this.fResults);
            this.setState(Task.State.FINISHED);
            Set<Instance> set = this.fResults.keySet();
            assert (set.containsAll(this.fWorkers) && this.fWorkers.containsAll(set));
            return true;
        }
        return false;
    }
}

