/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.toolbox.distcomp.pmode.io.CommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.io.broker.Log;
import java.io.Serializable;
import java.util.Date;
import java.util.UUID;

public interface JoinInfo
extends Serializable {
    public static final long DEADLINE_NOT_SET = 0L;
    public static final long NO_DEADLINE = Long.MAX_VALUE;

    public UUID getGroupUUID();

    public Class<? extends CommunicationGroup> getGroupImplementation();

    public boolean hasExpired();

    public long getRemainingTime();

    public long getDeadline();

    public long getHandShakeDeadline();

    public long getJoinTimeLimit();

    public JoinInfo createCopyWithReasonableDeadline();

    public JoinInfo createCopyReplaceDeadline(long var1);

    public int getNumberOfAttempts();

    public String getLogString();

    public boolean peersConnectingAsGroupShareBarrier();

    public static final class DeadlineHelper {
        private DeadlineHelper() {
        }

        private static void checkJoinInfo(JoinInfo joinInfo) {
            if (joinInfo.getDeadline() == 0L) {
                throw new DeadlineNotSetException("The deadline for " + joinInfo + " has not been set. This JoinInfo is most likely a template.");
            }
        }

        public static boolean hasExpired(JoinInfo joinInfo) {
            DeadlineHelper.checkJoinInfo(joinInfo);
            return System.currentTimeMillis() > joinInfo.getDeadline();
        }

        public static long getRemainingTime(JoinInfo joinInfo) {
            DeadlineHelper.checkJoinInfo(joinInfo);
            if (joinInfo.getDeadline() == Long.MAX_VALUE) {
                return joinInfo.getJoinTimeLimit();
            }
            long l = joinInfo.getDeadline() - System.currentTimeMillis();
            if (l < 0L) {
                throw new JoinInfoExpiredException("The deadline for " + joinInfo + " has passed.");
            }
            return l;
        }

        private static long getReasonableDeadline(JoinInfo joinInfo) {
            if (joinInfo.getDeadline() == Long.MAX_VALUE) {
                return joinInfo.getDeadline();
            }
            long l = System.currentTimeMillis();
            long l2 = l + joinInfo.getJoinTimeLimit();
            if (joinInfo.hasExpired()) {
                Log.LOGGER.warning("The deadline for " + joinInfo + " has passed. It is now " + new Date(l) + ". Perhaps your system is running very slowly or your clocks are skewed. Resetting the deadline on this machine to " + new Date(l2) + " and attempting to continue.");
                return l2;
            }
            long l3 = joinInfo.getDeadline() - l;
            if (l3 / 10L < joinInfo.getJoinTimeLimit()) {
                Log.LOGGER.warning("The deadline for " + joinInfo + " only has " + l3 + " milliseconds left. It is now " + new Date(l) + ". Perhaps your system is running very slowly or your clocks are skewed. Resetting the deadline on this machine to " + new Date(l2) + " and attempting to continue.");
                return l2;
            }
            if (l3 > joinInfo.getJoinTimeLimit()) {
                Log.LOGGER.warning("The deadline for " + joinInfo + " is further in the future than the join time limit; " + l3 + " milliseconds left. It is now " + new Date(l) + ". Your clocks are skewed. Resetting the deadline on this machine to " + new Date(l2) + " and attempting to continue.");
                return l2;
            }
            return joinInfo.getDeadline();
        }

        public static long getReasonableHandShakeDeadline(JoinInfo joinInfo) {
            long l = System.currentTimeMillis();
            long l2 = joinInfo.getDeadline();
            long l3 = l + joinInfo.getJoinTimeLimit() / (long)joinInfo.getNumberOfAttempts();
            Log.LOGGER.finest("getReasonableHandShakeDeadline(" + joinInfo + ") time limit will be the lesser of " + (l3 - l) + " and " + (l2 - l));
            if (l2 == Long.MAX_VALUE) {
                return l3;
            }
            if (l2 > l3) {
                return l3;
            }
            return l2;
        }

        public static JoinInfo createCopyWithReasonableDeadline(JoinInfo joinInfo) {
            DeadlineHelper.checkJoinInfo(joinInfo);
            long l = DeadlineHelper.getReasonableDeadline(joinInfo);
            if (l == joinInfo.getDeadline()) {
                return joinInfo;
            }
            return joinInfo.createCopyReplaceDeadline(l);
        }
    }

    public static final class DeadlineNotSetException
    extends RuntimeException {
        DeadlineNotSetException(String string) {
            super(string);
        }
    }

    public static final class JoinInfoExpiredException
    extends RuntimeException {
        JoinInfoExpiredException(String string) {
            super(string);
        }
    }
}

