/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.shared;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.ByteChannelHelper;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ProtocolId;
import com.mathworks.toolbox.distcomp.util.Version;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ByteChannel;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;

public final class HandShake {
    private static final long CLOSER_TIMER_KEEP_ALIVE = 100000L;
    private static final ScheduledThreadPoolExecutor SCHEDULED_EXECUTOR_SERVICE = new ScheduledThreadPoolExecutor(1, (ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(HandShake.class.getSimpleName() + "SCHEDULED_EXECUTOR_SERVICE"), (Logger)PackageInfo.LOGGER));
    private static final int BYTE_LENGTH_OF_INT = 4;

    HandShake() {
    }

    Instance connectHandShake(ByteChannel byteChannel, Instance instance, long l) throws HandShakeException {
        long l2 = l - System.currentTimeMillis();
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Connect handshake to " + byteChannel + " within " + l2 + " milliseconds");
        this.sendBootstrap(byteChannel, instance, l);
        Instance instance2 = this.receiveBootstrapFromAcceptor(byteChannel, instance, l);
        this.sendAcknowledge(byteChannel, true, instance, l);
        this.receiveAcknowledge(byteChannel, instance, l);
        return instance2;
    }

    Instance acceptHandShake(ByteChannel byteChannel, Instance instance, long l) throws HandShakeException {
        long l2 = l - System.currentTimeMillis();
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Accept handshake to " + byteChannel + " within " + l2 + " milliseconds");
        Instance instance2 = this.receiveBootstrapFromConnector(byteChannel, instance, l);
        this.sendBootstrapToConnector(byteChannel, instance, l);
        this.receiveAckFromConnector(byteChannel, instance, l);
        this.sendAcknowledge(byteChannel, true, instance, l);
        return instance2;
    }

    private Instance receiveBootstrapFromAcceptor(ByteChannel byteChannel, Instance instance, long l) throws HandShakeException {
        try {
            return this.receiveBootstrap(byteChannel, instance, l);
        }
        catch (BrokenConnectionDuringHandShakeException brokenConnectionDuringHandShakeException) {
            throw brokenConnectionDuringHandShakeException;
        }
        catch (HandShakeException | RuntimeException exception) {
            this.safeSendAcknowledge(byteChannel, false, instance, l);
            throw exception;
        }
    }

    private Instance receiveBootstrapFromConnector(ByteChannel byteChannel, Instance instance, long l) throws HandShakeException {
        try {
            return this.receiveBootstrap(byteChannel, instance, l);
        }
        catch (BrokenConnectionDuringHandShakeException brokenConnectionDuringHandShakeException) {
            throw brokenConnectionDuringHandShakeException;
        }
        catch (HandShakeException | RuntimeException exception) {
            this.safeSendBootstrapToConnector(byteChannel, instance, l);
            this.safeSendAcknowledge(byteChannel, false, instance, l);
            throw exception;
        }
    }

    private void safeSendBootstrapToConnector(ByteChannel byteChannel, Instance instance, long l) {
        try {
            this.sendBootstrap(byteChannel, instance, l);
        }
        catch (HandShakeException | RuntimeException exception) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Unable to send peer info to " + byteChannel + ", but was already reporting problems.", exception);
        }
    }

    private void sendBootstrapToConnector(ByteChannel byteChannel, Instance instance, long l) throws HandShakeException {
        try {
            this.sendBootstrap(byteChannel, instance, l);
        }
        catch (BrokenConnectionDuringHandShakeException brokenConnectionDuringHandShakeException) {
            throw brokenConnectionDuringHandShakeException;
        }
        catch (HandShakeException | RuntimeException exception) {
            this.safeSendAcknowledge(byteChannel, false, instance, l);
            throw exception;
        }
    }

    private void receiveAckFromConnector(ByteChannel byteChannel, Instance instance, long l) throws HandShakeException {
        try {
            this.receiveAcknowledge(byteChannel, instance, l);
        }
        catch (BrokenConnectionDuringHandShakeException brokenConnectionDuringHandShakeException) {
            throw brokenConnectionDuringHandShakeException;
        }
        catch (HandShakeException | RuntimeException exception) {
            this.safeSendAcknowledge(byteChannel, false, instance, l);
            throw exception;
        }
    }

    private void sendBootstrap(ByteChannel byteChannel, Instance instance, long l) throws HandShakeException {
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "About to send peer info (" + this.getByteLengthOfBootstrap(instance) + " bytes) to " + byteChannel);
        ByteBuffer byteBuffer = ByteBuffer.allocate(this.getByteLengthOfBootstrap(instance));
        byteBuffer.putInt(instance.getProtocolId().getIdNumber());
        byteBuffer.putInt(this.getByteLengthOfBootstrap(instance));
        byteBuffer.putInt(20);
        instance.encodeInstanceBootstrap(byteBuffer);
        byteBuffer.flip();
        this.writeUntilBufferEmpty(byteChannel, byteBuffer, instance, l);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Sent local peer info :" + instance + " to " + byteChannel);
    }

    private Instance receiveBootstrap(ByteChannel byteChannel, Instance instance, long l) throws HandShakeException {
        this.receiveProtocolIdAndBootstrapLength(byteChannel, instance, l);
        int n = this.getByteLengthOfBootstrap(instance) - 8;
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "About to receive peer info bootstrap (" + n + " bytes) from " + byteChannel);
        ByteBuffer byteBuffer = ByteBuffer.allocate(n);
        int n2 = this.readUntilBufferFull(byteChannel, byteBuffer, instance, l);
        if (n2 != n) {
            String string = "Didn't read bootstrap info correctly from " + byteChannel + " only read " + n2 + " of " + n + " bytes";
            PackageInfo.LOGGER.log(DistcompLevel.TWO, string);
            throw new RemoteIsNotPeerMessagingException(byteChannel);
        }
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "received " + n2 + " of bootstrap information from " + byteChannel);
        byteBuffer.flip();
        int n3 = byteBuffer.getInt();
        if (n3 != 20) {
            String string = "Bootstrap info contained version " + n3 + " on " + byteChannel + " not the expected version " + 20;
            PackageInfo.LOGGER.log(DistcompLevel.TWO, string);
            throw new VersionMismatchException(byteChannel, n3, 20);
        }
        Instance instance2 = instance.decodeRemoteInstanceBootstrap(byteBuffer);
        if (!instance.getGroupUuid().equals(instance2.getGroupUuid())) {
            String string = "Bootstrap info from " + byteChannel + " did not contain the correct group UUID number. The value was " + instance2.getGroupUuid() + " not the expected " + instance.getGroupUuid();
            PackageInfo.LOGGER.log(DistcompLevel.TWO, string);
            throw new PeerGroupIdMismatchException(byteChannel);
        }
        return instance2;
    }

    private int receiveProtocolIdAndBootstrapLength(ByteChannel byteChannel, Instance instance, long l) throws HandShakeException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(8);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "About to receive protocol id and bootstrap length (8 bytes) from " + byteChannel);
        int n = this.readUntilBufferFull(byteChannel, byteBuffer, instance, l);
        if (8 != n) {
            String string = "Didn't read bootstrap length correctly - only read " + n + " of " + 8 + " bytes from " + byteChannel + ". Suspect a version mismatch.";
            PackageInfo.LOGGER.log(DistcompLevel.TWO, string);
            throw new RemoteIsNotPeerMessagingException(byteChannel);
        }
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "received " + n + " bytes of bootstrap information from " + byteChannel);
        byteBuffer.flip();
        int n2 = byteBuffer.getInt();
        if (n2 != instance.getProtocolId().getIdNumber()) {
            if (ProtocolId.isKnownProtocol(n2)) {
                ProtocolId protocolId = ProtocolId.getProtocolIdForNumber(n2);
                String string = "Bootstrap info on " + byteChannel + " contained protocol " + (Object)((Object)protocolId) + " not the expected protocol of " + (Object)((Object)instance.getProtocolId()) + ". Suspect a configuration problem or a version mismatch.";
                PackageInfo.LOGGER.log(DistcompLevel.TWO, string);
                throw new ProtocolMismatchException(byteChannel, protocolId, instance.getProtocolId());
            }
            String string = "Bootstrap info on " + byteChannel + " contained the unknown protocol number " + n2 + " not the expected protocol of " + (Object)((Object)instance.getProtocolId()) + ". Suspect a configuration problem or version mismatch.";
            PackageInfo.LOGGER.log(DistcompLevel.TWO, string);
            throw new RemoteIsNotPeerMessagingException(byteChannel);
        }
        int n3 = byteBuffer.getInt();
        if (this.getByteLengthOfBootstrap(instance) != n3) {
            if (n3 > Short.MAX_VALUE || n3 <= 0) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "The bootstrap length, " + n3 + " bytes, on " + byteChannel + " has a very suspicious value. Suspect a configuration problem.");
                throw new RemoteIsNotPeerMessagingException(byteChannel);
            }
            if (n3 < 12) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "The bootstrap length, " + n3 + " bytes, on " + byteChannel + " is too short to determine the version number. Suspect a configuration problem.");
                throw new RemoteIsNotPeerMessagingException(byteChannel);
            }
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "About to receive version while building an error message (4 bytes).");
            int n4 = this.readUntilBufferFull(byteChannel, byteBuffer2, instance, l);
            byteBuffer2.flip();
            if (n4 != 4) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "The bootstrap's length promised to be " + n3 + " bytes on " + byteChannel + " but it could only provide " + (8 + n4) + " bytes.");
                throw new RemoteIsNotPeerMessagingException(byteChannel);
            }
            PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Received version while building an error message (4 bytes).");
            int n5 = byteBuffer2.getInt();
            if (n5 != 20) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "The bootstrap length, " + n3 + " bytes, and version number, " + n5 + " on " + byteChannel + " do not match appropriate values for version " + 20 + ". Suspect a version mismatch.");
                throw new VersionMismatchException(byteChannel, n5, 20);
            }
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "The bootstrap length, " + n3 + " bytes, on " + byteChannel + " is incorrect even though the protocol id number and version number are correct. Suspect a configuration problem.");
            throw new RemoteIsNotPeerMessagingException(byteChannel);
        }
        return n3;
    }

    private void safeSendAcknowledge(ByteChannel byteChannel, boolean bl, Instance instance, long l) {
        try {
            this.sendAcknowledge(byteChannel, bl, instance, l);
        }
        catch (HandShakeException | RuntimeException exception) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Unable to send acknowledge code to " + byteChannel + ", but was already reporting problems.", exception);
        }
    }

    private void sendAcknowledge(ByteChannel byteChannel, boolean bl, Instance instance, long l) throws HandShakeException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        byteBuffer.putInt(bl ? 0 : 1);
        byteBuffer.flip();
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "About to send acknowledge (4 bytes).");
        this.writeUntilBufferEmpty(byteChannel, byteBuffer, instance, l);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Sent acknowledge (4 bytes).");
    }

    private void receiveAcknowledge(ByteChannel byteChannel, Instance instance, long l) throws HandShakeException {
        ByteBuffer byteBuffer = ByteBuffer.allocate(4);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "About to receive acknowledge (4 bytes).");
        int n = this.readUntilBufferFull(byteChannel, byteBuffer, instance, l);
        PackageInfo.LOGGER.log(DistcompLevel.FIVE, "Received acknowledge (4 bytes).");
        if (n != 4) {
            String string = byteChannel.toString() + " sent " + n + " bytes instead of the expected " + 4;
            PackageInfo.LOGGER.log(DistcompLevel.TWO, string);
            throw new RemoteFailedToAcknowledgeException(byteChannel);
        }
        byteBuffer.flip();
        int n2 = byteBuffer.getInt();
        if (n2 != 0) {
            String string = byteChannel.toString() + " did not accept this end's bootstrap.";
            PackageInfo.LOGGER.log(DistcompLevel.TWO, string);
            throw new RemoteFailedToAcknowledgeException(byteChannel);
        }
    }

    private int getByteLengthOfBootstrap(Instance instance) {
        return 12 + instance.getByteLengthOfInstanceBootstrap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readUntilBufferFull(ByteChannel byteChannel, ByteBuffer byteBuffer, Instance instance, long l) throws BrokenConnectionDuringHandShakeException {
        ScheduledFuture<?> scheduledFuture = this.scheduleChannelClose(byteChannel, l, instance);
        try {
            int n;
            int n2;
            int n3 = byteBuffer.remaining();
            int n4 = 0;
            for (n = 0; n < n3; n += n2) {
                if (n4 > 0) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Attempt " + (n4 + 1) + " to read " + n3 + " (currently got: " + n + ")");
                }
                try {
                    n2 = byteChannel.read(byteBuffer);
                    ++n4;
                    if (n2 != -1) continue;
                    String string = "End of stream reached on " + byteChannel;
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, string);
                    throw new EndOfStreamDuringHandShakeException(byteChannel);
                }
                catch (BrokenConnectionDuringHandShakeException brokenConnectionDuringHandShakeException) {
                    throw brokenConnectionDuringHandShakeException;
                }
                catch (AsynchronousCloseException asynchronousCloseException) {
                    String string = byteChannel + " closed during read";
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, string, asynchronousCloseException);
                    throw new TimeoutDuringHandShakeException(byteChannel, l, asynchronousCloseException);
                }
                catch (IOException iOException) {
                    String string = "Can not read from " + byteChannel;
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, string, iOException);
                    throw new TransferFailedDuringHandShakeException(byteChannel, iOException);
                }
            }
            n2 = n;
            return n2;
        }
        finally {
            boolean bl = scheduledFuture.cancel(false);
            SCHEDULED_EXECUTOR_SERVICE.purge();
            if (!bl) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Timed out trying to read from " + byteChannel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeUntilBufferEmpty(ByteChannel byteChannel, ByteBuffer byteBuffer, Instance instance, long l) throws BrokenConnectionDuringHandShakeException {
        ScheduledFuture<?> scheduledFuture = this.scheduleChannelClose(byteChannel, l, instance);
        try {
            int n = 0;
            int n2 = byteBuffer.remaining();
            int n3 = 0;
            while (n < n2) {
                if (n3 > 0) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Attempt " + (n3 + 1) + " to write " + n2 + " (currently sent: " + n + ")");
                }
                try {
                    n += byteChannel.write(byteBuffer);
                    ++n3;
                }
                catch (AsynchronousCloseException asynchronousCloseException) {
                    String string = byteChannel + " closed during write";
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, string, asynchronousCloseException);
                    throw new TimeoutDuringHandShakeException(byteChannel, l, asynchronousCloseException);
                }
                catch (IOException iOException) {
                    String string = "Can not write to" + byteChannel;
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, string, iOException);
                    throw new TransferFailedDuringHandShakeException(byteChannel, iOException);
                }
            }
            int n4 = n;
            return n4;
        }
        finally {
            boolean bl = scheduledFuture.cancel(false);
            SCHEDULED_EXECUTOR_SERVICE.purge();
            if (!bl) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Timed out trying to write to " + byteChannel);
            }
        }
    }

    private Runnable createChannelCloser(final ByteChannel byteChannel, final Instance instance, final long l) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    PackageInfo.LOGGER.log(DistcompLevel.SIX, this.getClass().getSimpleName() + "(" + instance + ") will close " + byteChannel + " due to timeout of " + l + " ms.");
                    byteChannel.close();
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, this.getClass().getSimpleName() + "(" + instance + ") closed " + byteChannel + " due to timeout of " + l + " ms.");
                }
                catch (IOException iOException) {
                    PackageInfo.LOGGER.log(DistcompLevel.TWO, "Interrupted while attempting to close", iOException);
                }
            }
        };
    }

    private ScheduledFuture<?> scheduleChannelClose(ByteChannel byteChannel, long l, Instance instance) throws DeadlineMissedDuringHandShakeException {
        long l2 = Math.max(0L, l - System.currentTimeMillis());
        if (l2 == 0L) {
            try {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, this.getClass().getSimpleName() + "(" + instance + ") 's deadline of " + new Date(l) + " passed before this operation was attempted." + byteChannel + " will be closed.");
                byteChannel.close();
                PackageInfo.LOGGER.log(DistcompLevel.TWO, this.getClass().getSimpleName() + "(" + instance + ") 's deadline of " + new Date(l) + " passed before this operation was attempted." + byteChannel + " was closed.");
            }
            catch (IOException iOException) {
                PackageInfo.LOGGER.log(DistcompLevel.TWO, "Interrupted while attempting to close", iOException);
            }
            throw new DeadlineMissedDuringHandShakeException(byteChannel, l);
        }
        return SCHEDULED_EXECUTOR_SERVICE.schedule(this.createChannelCloser(byteChannel, instance, l2), l2, TimeUnit.MILLISECONDS);
    }

    static {
        SCHEDULED_EXECUTOR_SERVICE.setKeepAliveTime(100000L, TimeUnit.MILLISECONDS);
        SCHEDULED_EXECUTOR_SERVICE.allowCoreThreadTimeOut(true);
    }

    private static final class ProtocolMismatchException
    extends HandShakeException {
        private final BaseMsgID fMessageID;

        private ProtocolMismatchException(ByteChannel byteChannel, ProtocolId protocolId, ProtocolId protocolId2) {
            super(byteChannel);
            this.fMessageID = new peermessaging.ProtocolMismatch(protocolId.getName(), protocolId2.getName(), this.getRemoteAddress().toString(), this.getLocalAddress().toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    public static final class VersionMismatchException
    extends HandShakeException {
        private final BaseMsgID fMessageID;
        private final int fReceivedValue;
        private final int fExpectedValue;

        private VersionMismatchException(ByteChannel byteChannel, int n, int n2) {
            super(byteChannel);
            this.fReceivedValue = n;
            this.fExpectedValue = n2;
            this.fMessageID = new peermessaging.VersionMismatch(this.getRemoteVersion(), this.getLocalVersion(), this.getRemoteAddress().toString(), this.getLocalAddress().toString());
        }

        public String getRemoteVersion() {
            String string = Version.getVersionStringFromNumber(this.fReceivedValue);
            if (string.isEmpty()) {
                string = String.valueOf(this.fReceivedValue);
            }
            return string;
        }

        public String getLocalVersion() {
            return Version.getVersionStringFromNumber(this.fExpectedValue);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static final class DeadlineMissedDuringHandShakeException
    extends BrokenConnectionDuringHandShakeException {
        private final BaseMsgID fMessageID;

        private DeadlineMissedDuringHandShakeException(ByteChannel byteChannel, long l) {
            super(byteChannel);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy MM dd HH:mm:ss.SSS z");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            Date date = new Date(l);
            this.fMessageID = new peermessaging.HandshakeDeadlineMissed(simpleDateFormat.format(date), this.getRemoteAddress().toString(), this.getLocalAddress().toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static final class TimeoutDuringHandShakeException
    extends BrokenConnectionDuringHandShakeException {
        private final Exception fCause;
        private final Date fDate;
        private final SimpleDateFormat fDateFormat = new SimpleDateFormat("yyyy MM dd HH:mm:ss.SSS z");
        private final String fRemoteAddressString;

        private TimeoutDuringHandShakeException(ByteChannel byteChannel, long l, Exception exception) {
            super(byteChannel, exception);
            this.fDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            this.fDate = new Date(l);
            this.fRemoteAddressString = this.getRemoteAddress() == null ? "null" : this.getRemoteAddress().toString();
            this.fCause = exception;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            String string = this.fCause == null ? "null" : this.fCause.getMessage();
            return new peermessaging.LocalClosedPossibleTimeout(this.fDateFormat.format(this.fDate), string, this.fRemoteAddressString, this.getLocalAddress().toString());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            String string = this.fCause == null ? "null" : this.fCause.getLocalizedMessage();
            return new peermessaging.LocalClosedPossibleTimeout(this.fDateFormat.format(this.fDate), string, this.fRemoteAddressString, this.getLocalAddress().toString());
        }
    }

    private static final class EndOfStreamDuringHandShakeException
    extends BrokenConnectionDuringHandShakeException {
        private final BaseMsgID fMessageID = new peermessaging.EndOfStreamDuringHandshake(this.getRemoteAddress().toString(), this.getLocalAddress().toString());

        private EndOfStreamDuringHandShakeException(ByteChannel byteChannel) {
            super(byteChannel);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static final class TransferFailedDuringHandShakeException
    extends BrokenConnectionDuringHandShakeException {
        private final Exception fCause;

        private TransferFailedDuringHandShakeException(ByteChannel byteChannel, Exception exception) {
            super(byteChannel, exception);
            this.fCause = exception;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.TransferFailed(this.fCause.getMessage(), this.getRemoteAddress().toString(), this.getLocalAddress().toString());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.TransferFailed(this.fCause.getLocalizedMessage(), this.getRemoteAddress().toString(), this.getLocalAddress().toString());
        }
    }

    private static abstract class BrokenConnectionDuringHandShakeException
    extends HandShakeException {
        private BrokenConnectionDuringHandShakeException(ByteChannel byteChannel) {
            super(byteChannel);
        }

        private BrokenConnectionDuringHandShakeException(ByteChannel byteChannel, Exception exception) {
            super(byteChannel, exception);
        }
    }

    private static final class RemoteFailedToAcknowledgeException
    extends SimpleHandShakeException {
        private final BaseMsgID fMessageID = new peermessaging.RemoteFailedToAcknowledge(this.getRemoteAddress().toString(), this.getLocalAddress().toString());

        private RemoteFailedToAcknowledgeException(ByteChannel byteChannel) {
            super(byteChannel);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static final class PeerGroupIdMismatchException
    extends SimpleHandShakeException {
        private final BaseMsgID fMessageID = new peermessaging.PeerGroupIdMismatch(this.getRemoteAddress().toString(), this.getLocalAddress().toString());

        private PeerGroupIdMismatchException(ByteChannel byteChannel) {
            super(byteChannel);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static final class RemoteIsNotPeerMessagingException
    extends SimpleHandShakeException {
        private final BaseMsgID fMessageID = new peermessaging.RemoteIsNotPeerMessaging(this.getRemoteAddress().toString(), this.getLocalAddress().toString());

        private RemoteIsNotPeerMessagingException(ByteChannel byteChannel) {
            super(byteChannel);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static abstract class SimpleHandShakeException
    extends HandShakeException {
        private SimpleHandShakeException(ByteChannel byteChannel) {
            super(byteChannel);
        }
    }

    public static abstract class HandShakeException
    extends PeerMessagingException {
        private final InetSocketAddress fRemoteAddress;
        private final InetSocketAddress fLocalAddress;

        private HandShakeException(ByteChannel byteChannel) {
            this.fRemoteAddress = ByteChannelHelper.extractRemoteAddress(byteChannel);
            this.fLocalAddress = ByteChannelHelper.extractLocalAddress(byteChannel);
        }

        private HandShakeException(ByteChannel byteChannel, Exception exception) {
            super(exception);
            this.fRemoteAddress = ByteChannelHelper.extractRemoteAddress(byteChannel);
            this.fLocalAddress = ByteChannelHelper.extractLocalAddress(byteChannel);
        }

        InetSocketAddress getRemoteAddress() {
            return this.fRemoteAddress;
        }

        InetSocketAddress getLocalAddress() {
            return this.fLocalAddress;
        }
    }
}

