/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.poolmessaging;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.NoSuchDestinationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class SessionRoleMapping {
    private final Map<ProcessInstance, Instance> fRoleMapping = new HashMap<ProcessInstance, Instance>();
    private final Map<Instance, ProcessInstance> fReverseMapping = new HashMap<Instance, ProcessInstance>();

    public synchronized void registerProcess(ProcessInstance processInstance, Instance instance) {
        if (!this.fRoleMapping.containsKey(processInstance)) {
            this.fRoleMapping.put(processInstance, instance);
            this.fReverseMapping.put(instance, processInstance);
        } else assert (this.fRoleMapping.get(processInstance).equals(instance) && this.fReverseMapping.get(instance).equals(processInstance));
    }

    public synchronized ProcessInstance instanceToRole(Instance instance) throws NoSuchDestinationException {
        if (this.fReverseMapping.containsKey(instance)) {
            return this.fReverseMapping.get(instance);
        }
        throw new NoEntryInAddressBookException(instance);
    }

    public synchronized Collection<ProcessInstance> instanceToRole(Collection<Instance> collection) throws NoSuchDestinationException {
        ArrayList<ProcessInstance> arrayList = new ArrayList<ProcessInstance>();
        for (Instance instance : collection) {
            arrayList.add(this.instanceToRole(instance));
        }
        return arrayList;
    }

    public synchronized List<Instance> roleToInstance(List<ProcessInstance> list) throws NoSuchDestinationException {
        ArrayList<Instance> arrayList = new ArrayList<Instance>();
        for (ProcessInstance processInstance : list) {
            arrayList.add(this.roleToInstance(processInstance));
        }
        return arrayList;
    }

    public synchronized Instance roleToInstance(ProcessInstance processInstance) throws NoSuchDestinationException {
        if (this.fRoleMapping.containsKey(processInstance)) {
            return this.fRoleMapping.get(processInstance);
        }
        throw new NotContactableException(processInstance);
    }

    private static final class NoEntryInAddressBookException
    extends NoSuchDestinationException {
        private final BaseMsgID fMessageID;

        private NoEntryInAddressBookException(Instance instance) {
            this.fMessageID = new peermessaging.NoEntryInAddressBook(instance.toString());
        }

        @Override
        public BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        public BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static final class NotContactableException
    extends NoSuchDestinationException {
        private final BaseMsgID fMessageID;

        private NotContactableException(ProcessInstance processInstance) {
            this.fMessageID = new peermessaging.NotContactable(processInstance.toString());
        }

        @Override
        public BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        public BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }
}

