/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabIdentifiedMessage;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public final class PeerSessionFatalErrorHandler
implements ErrorHandler {
    private final ExecutorService fShutdownExecutor;
    private final AtomicBoolean fIsShuttingDown = new AtomicBoolean(false);
    private ShutdownHandler fShutdownHandler = null;
    private boolean fHasBeenDeactivated = false;
    private boolean fHasError = false;
    private FatalError fError;

    public PeerSessionFatalErrorHandler(ExecutorService executorService) {
        this.fShutdownExecutor = executorService;
    }

    public PeerSessionFatalErrorHandler() {
        this.fShutdownExecutor = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " fShutdownExecutor-"), (Logger)PackageInfo.LOGGER));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readError(Instance instance, Throwable throwable) {
        String string;
        ShutdownHandler shutdownHandler;
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            shutdownHandler = this.fShutdownHandler;
            this.fError = throwable != null ? new ReadErrorWithCause(instance, throwable) : new ReadError(instance);
            string = this.fError.getMessage();
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Read error, forcing a shutdown.");
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeError(Instance instance, Throwable throwable) {
        String string;
        ShutdownHandler shutdownHandler;
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            shutdownHandler = this.fShutdownHandler;
            this.fError = throwable != null ? new WriteErrorWithCause(instance, throwable) : new WriteError(instance);
            string = this.fError.getMessage();
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Write error, forcing a shutdown.");
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void lostCommunication(Instance instance, Throwable throwable) {
        String string;
        ShutdownHandler shutdownHandler;
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            shutdownHandler = this.fShutdownHandler;
            this.fError = throwable != null ? new LostConnectionErrorWithCause(instance, throwable) : new LostConnectionError(instance);
            string = this.fError.getMessage();
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Lost communication, forcing a shutdown.");
            this.tryShutdown(shutdownHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRuntimeError(Throwable throwable) {
        String string;
        ShutdownHandler shutdownHandler;
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            if (this.fHasError || this.fHasBeenDeactivated) {
                return;
            }
            this.fHasError = true;
            shutdownHandler = this.fShutdownHandler;
            this.fError = throwable != null ? new InternalRuntimeErrorWithCause(throwable) : new InternalRuntimeError();
            string = this.fError.getMessage();
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, string);
        if (shutdownHandler != null) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Runtime error, forcing a shutdown.", throwable);
            this.tryShutdown(shutdownHandler);
        }
    }

    @Override
    public void executorError(Throwable throwable) {
        this.internalRuntimeError(throwable);
    }

    @Override
    public void communicationError(Error error) {
        this.internalRuntimeError(error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activate(ShutdownHandler shutdownHandler) {
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            if (!this.fHasError) {
                assert (!this.fHasBeenDeactivated) : "Attempt to activate a handler after it has been deactivated";
                this.fShutdownHandler = shutdownHandler;
                return;
            }
        }
        if (shutdownHandler != null) {
            this.tryShutdown(shutdownHandler);
        }
    }

    @Override
    public synchronized void deactivate() {
        this.fShutdownHandler = null;
        this.fHasBeenDeactivated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryShutdown(final ShutdownHandler shutdownHandler) {
        FatalError fatalError;
        assert (shutdownHandler != null) : "Shutdown handler was null during a call to tryShutdown";
        if (this.fIsShuttingDown.getAndSet(true)) {
            return;
        }
        PeerSessionFatalErrorHandler peerSessionFatalErrorHandler = this;
        synchronized (peerSessionFatalErrorHandler) {
            assert (this.fHasError) : "tryShutdown was called without an error";
            fatalError = this.fError;
        }
        this.fShutdownExecutor.execute(new Runnable(){

            @Override
            public void run() {
                shutdownHandler.forceShutdown(fatalError);
            }
        });
        this.fShutdownExecutor.shutdown();
    }

    public static final class InternalRuntimeErrorWithCause
    extends FatalError {
        private final Throwable fCause;

        public InternalRuntimeErrorWithCause(Throwable throwable) {
            this.fCause = throwable;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.InternalRuntimeErrorOccurredWithCause(this.fCause.getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.InternalRuntimeErrorOccurredWithCause(this.fCause.getLocalizedMessage());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            InternalRuntimeErrorWithCause internalRuntimeErrorWithCause = (InternalRuntimeErrorWithCause)object;
            return this.fCause.equals(internalRuntimeErrorWithCause.fCause);
        }

        public int hashCode() {
            return this.fCause.hashCode();
        }
    }

    public static final class InternalRuntimeError
    extends FatalError {
        private final BaseMsgID fMessageID = new peermessaging.InternalRuntimeErrorOccurred();

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            InternalRuntimeError internalRuntimeError = (InternalRuntimeError)object;
            return this.fMessageID.equals(internalRuntimeError.fMessageID);
        }

        public int hashCode() {
            return this.fMessageID.hashCode();
        }
    }

    public static final class WriteErrorWithCause
    extends FatalError {
        private final Instance fInstance;
        private final Throwable fCause;

        public WriteErrorWithCause(Instance instance, Throwable throwable) {
            this.fInstance = instance;
            this.fCause = throwable;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.WriteErrorOccurredWithCause(this.fInstance.toString(), this.fCause.getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.WriteErrorOccurredWithCause(this.fInstance.toString(), this.fCause.getLocalizedMessage());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            WriteErrorWithCause writeErrorWithCause = (WriteErrorWithCause)object;
            if (!this.fCause.equals(writeErrorWithCause.fCause)) {
                return false;
            }
            return this.fInstance.equals(writeErrorWithCause.fInstance);
        }

        public int hashCode() {
            int n = this.fInstance.hashCode();
            n = 31 * n + this.fCause.hashCode();
            return n;
        }
    }

    public static final class WriteError
    extends FatalError {
        private final BaseMsgID fMessageID;

        public WriteError(Instance instance) {
            this.fMessageID = new peermessaging.WriteErrorOccurred(instance.toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            WriteError writeError = (WriteError)object;
            return this.fMessageID.equals(writeError.fMessageID);
        }

        public int hashCode() {
            return this.fMessageID.hashCode();
        }
    }

    public static final class ReadErrorWithCause
    extends FatalError {
        private final Instance fInstance;
        private final Throwable fCause;

        public ReadErrorWithCause(Instance instance, Throwable throwable) {
            this.fInstance = instance;
            this.fCause = throwable;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.ReadErrorOccurredWithCause(this.fInstance.toString(), this.fCause.getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.ReadErrorOccurredWithCause(this.fInstance.toString(), this.fCause.getLocalizedMessage());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ReadErrorWithCause readErrorWithCause = (ReadErrorWithCause)object;
            if (!this.fCause.equals(readErrorWithCause.fCause)) {
                return false;
            }
            return this.fInstance.equals(readErrorWithCause.fInstance);
        }

        public int hashCode() {
            int n = this.fInstance.hashCode();
            n = 31 * n + this.fCause.hashCode();
            return n;
        }
    }

    public static final class ReadError
    extends FatalError {
        private final BaseMsgID fMessageID;

        public ReadError(Instance instance) {
            this.fMessageID = new peermessaging.ReadErrorOccurred(instance.toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            ReadError readError = (ReadError)object;
            return this.fMessageID.equals(readError.fMessageID);
        }

        public int hashCode() {
            return this.fMessageID.hashCode();
        }
    }

    public static final class LostConnectionErrorWithCause
    extends FatalError {
        private final Instance fInstance;
        private final Throwable fCause;

        public LostConnectionErrorWithCause(Instance instance, Throwable throwable) {
            this.fInstance = instance;
            this.fCause = throwable;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.LostConnectionWithCause(this.fInstance.toString(), this.fCause.getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.LostConnectionWithCause(this.fInstance.toString(), this.fCause.getLocalizedMessage());
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LostConnectionErrorWithCause lostConnectionErrorWithCause = (LostConnectionErrorWithCause)object;
            if (!this.fCause.equals(lostConnectionErrorWithCause.fCause)) {
                return false;
            }
            return this.fInstance.equals(lostConnectionErrorWithCause.fInstance);
        }

        public int hashCode() {
            int n = this.fInstance.hashCode();
            n = 31 * n + this.fCause.hashCode();
            return n;
        }
    }

    public static final class LostConnectionError
    extends FatalError {
        private final BaseMsgID fMessageID;

        public LostConnectionError(Instance instance) {
            this.fMessageID = new peermessaging.LostConnection(instance.toString());
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            LostConnectionError lostConnectionError = (LostConnectionError)object;
            return this.fMessageID.equals(lostConnectionError.fMessageID);
        }

        public int hashCode() {
            return this.fMessageID.hashCode();
        }
    }

    public static abstract class FatalError
    implements HasI18nMatlabIdentifiedMessage,
    Serializable {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();

        protected abstract BaseMsgID getFilledMessage();

        protected abstract BaseMsgID getFilledLocalizedMessage();

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.getFilledLocalizedMessage());
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.getFilledMessage());
        }

        public String getMessageID() {
            return this.getFilledMessage().getCatalogId() + ":" + this.getFilledMessage().getMessageId();
        }
    }
}

