/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.AbstractPeerAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.AsyncSelector;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.nio.channels.SocketChannel;

public final class PeerPassiveAcceptor
extends AbstractPeerAcceptor {
    private final AsyncSelector fAsyncSelector;

    public PeerPassiveAcceptor(String string, Instance instance, ServerSocketAcceptInfo serverSocketAcceptInfo) throws AbstractPeerAcceptor.InitializeServerSocketChannelException {
        this(string, instance, serverSocketAcceptInfo, new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Uncaught exception thrown in PeerPassiveAcceptor thread " + thread.toString(), throwable);
            }
        });
    }

    public PeerPassiveAcceptor(String string, Instance instance, ServerSocketAcceptInfo serverSocketAcceptInfo, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) throws AbstractPeerAcceptor.InitializeServerSocketChannelException {
        super(string, instance, serverSocketAcceptInfo);
        assert (serverSocketAcceptInfo.getDeadline() == Long.MAX_VALUE) : "PeerPassiveAcceptors should have no deadline, not " + serverSocketAcceptInfo.getRemainingTime() + " ms from now.";
        try {
            int n = 0;
            this.fAsyncSelector = new AsyncSelector(5000L, (long)n, uncaughtExceptionHandler);
        }
        catch (IOException iOException) {
            throw new CouldNotCreateAsyncSelectorException(string, instance, iOException);
        }
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "PeerPassiveAcceptor (" + instance + ") constructed.");
    }

    public void startAccepting(final ConnectionHandler connectionHandler) {
        this.fAsyncSelector.register(this.getServerSocketChannel(), 16, new AsyncSelector.SelectHandler(){

            @Override
            public void handleAccept(SocketChannel socketChannel) {
                try {
                    Connection connection = PeerPassiveAcceptor.this.createConnection(socketChannel);
                    connectionHandler.newConnection(connection);
                }
                catch (PeerMessagingException peerMessagingException) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "PeerMessagingException while creating the connection - closing socket channel " + socketChannel, peerMessagingException);
                    try {
                        socketChannel.close();
                    }
                    catch (IOException iOException) {
                        PackageInfo.LOGGER.log(DistcompLevel.ONE, "IOException while closing socket channel " + socketChannel, iOException);
                    }
                }
            }
        });
    }

    @Override
    public void close() {
        try {
            this.fAsyncSelector.close();
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "IOException closing AsyncSelector", iOException);
        }
        super.close();
    }

    public String toString() {
        return "[PassivePeerAcceptor for: " + this.getLocalPeerInstance() + " with ServerSocketChannel: " + this.getServerSocketChannel() + "]";
    }

    public static final class CouldNotCreateAsyncSelectorException
    extends AbstractPeerAcceptor.InitializeServerSocketChannelException {
        private final String fLocalHostname;
        private final Instance fLocalPeerInstance;

        private CouldNotCreateAsyncSelectorException(String string, Instance instance, IOException iOException) {
            super(iOException);
            this.fLocalHostname = string;
            this.fLocalPeerInstance = instance;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.CouldNotCreateAsyncSelectorException(this.fLocalPeerInstance.toString(), this.fLocalHostname, this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.CouldNotCreateAsyncSelectorException(this.fLocalPeerInstance.toString(), this.fLocalHostname, this.getCause().getLocalizedMessage());
        }
    }

    public static interface ConnectionHandler {
        public void newConnection(Connection var1);
    }
}

