/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.io.IoConstants;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectionFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.HandShake;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;

public final class PeerConnector {
    public PeerConnector() {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "PeerConnector constructed.");
    }

    private SocketChannel configureSocketChannel(InetSocketAddress inetSocketAddress) throws IOException {
        SocketChannel socketChannel = SocketChannel.open();
        try {
            int[] nArray = IoConstants.sSOCKET_PERFORMANCE_PREFS;
            PackageInfo.LOGGER.log(DistcompLevel.SIX, socketChannel + "for" + inetSocketAddress + " about to be configured.");
            socketChannel.socket().setPerformancePreferences(nArray[0], nArray[1], nArray[2]);
            socketChannel.socket().setTcpNoDelay(false);
            socketChannel.configureBlocking(true);
            PackageInfo.LOGGER.log(DistcompLevel.SIX, socketChannel + "for" + inetSocketAddress + " configured.");
            return socketChannel;
        }
        catch (IOException | RuntimeException exception) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to configure SocketChannel " + socketChannel + " for " + inetSocketAddress, exception);
            this.safeCloseSocketChannel(socketChannel);
            throw exception;
        }
    }

    private SocketChannel configureAndConnectSocketChannel(InetSocketAddress inetSocketAddress) throws IOException {
        SocketChannel socketChannel = this.configureSocketChannel(inetSocketAddress);
        try {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Trying to connect() : " + inetSocketAddress);
            socketChannel.socket().connect(inetSocketAddress, 10000);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Did connect() : " + inetSocketAddress + " : " + socketChannel);
            return socketChannel;
        }
        catch (IOException | RuntimeException exception) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to connect() : " + inetSocketAddress, exception);
            this.safeCloseSocketChannel(socketChannel);
            throw exception;
        }
    }

    private InetSocketAddress resolveLocally(InetSocketAddress inetSocketAddress) {
        return new InetSocketAddress(inetSocketAddress.getHostName(), inetSocketAddress.getPort());
    }

    private SocketChannel resolveLocallyAndAttemptToCreateSocketChannel(InetSocketAddress inetSocketAddress) throws IOException {
        InetSocketAddress inetSocketAddress2 = this.resolveLocally(inetSocketAddress);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Resolved " + inetSocketAddress2 + " locally. Attempting to connect.");
        return this.configureAndConnectSocketChannel(inetSocketAddress2);
    }

    private SocketChannel createSocketChannel(ServerSocketConnectInfo serverSocketConnectInfo) throws IOException {
        InetSocketAddress inetSocketAddress = serverSocketConnectInfo.getSocketAddress();
        try {
            return this.configureAndConnectSocketChannel(inetSocketAddress);
        }
        catch (IOException iOException) {
            if (iOException instanceof SocketException || iOException instanceof UnknownHostException || iOException instanceof SocketTimeoutException) {
                return this.resolveLocallyAndAttemptToCreateSocketChannel(inetSocketAddress);
            }
            throw iOException;
        }
        catch (UnresolvedAddressException unresolvedAddressException) {
            return this.resolveLocallyAndAttemptToCreateSocketChannel(inetSocketAddress);
        }
    }

    private Connection connectAndConfigureConnection(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance) throws HandShake.HandShakeException, ConnectRefusedRemotelyException, CouldNotConnectIOException, CouldNotConnectUnknownHostException {
        SocketChannel socketChannel;
        try {
            socketChannel = this.createSocketChannel(serverSocketConnectInfo);
        }
        catch (ConnectException connectException) {
            throw new ConnectRefusedRemotelyException(serverSocketConnectInfo, instance, connectException);
        }
        catch (UnknownHostException unknownHostException) {
            throw new CouldNotConnectUnknownHostException(serverSocketConnectInfo, instance, unknownHostException);
        }
        catch (IOException iOException) {
            throw new CouldNotConnectIOException(serverSocketConnectInfo, instance, iOException);
        }
        try {
            ConnectionFactory connectionFactory = serverSocketConnectInfo.getConnectorSecurityDescription().createConnectionFactoryForConnector();
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "activelyConnectTo(" + serverSocketConnectInfo + ") connectionFactory is  " + connectionFactory);
            return connectionFactory.createConnection(socketChannel, instance, serverSocketConnectInfo, true);
        }
        catch (HandShake.HandShakeException handShakeException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed hand shake with " + socketChannel, handShakeException);
            this.safeCloseSocketChannel(socketChannel);
            throw handShakeException;
        }
    }

    private void safeCloseSocketChannel(SocketChannel socketChannel) {
        try {
            socketChannel.close();
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to close " + socketChannel, iOException);
        }
    }

    public Connection activelyConnectTo(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance) throws CouldNotConnectException, HandShake.HandShakeException {
        PeerMessagingException peerMessagingException = null;
        int n = 0;
        while (n++ < serverSocketConnectInfo.getNumberOfAttempts()) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "activelyConnectTo(" + serverSocketConnectInfo + ") attempt " + n);
            try {
                return this.connectAndConfigureConnection(serverSocketConnectInfo, instance);
            }
            catch (HandShake.HandShakeException handShakeException) {
                if (peerMessagingException == null) {
                    peerMessagingException = handShakeException;
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo + ") caught exception during attempt " + n, handShakeException);
            }
            catch (ConnectRefusedRemotelyException connectRefusedRemotelyException) {
                if (peerMessagingException == null) {
                    peerMessagingException = connectRefusedRemotelyException;
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo + ") caught exception during attempt " + n, connectRefusedRemotelyException);
            }
        }
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to connect to " + serverSocketConnectInfo + " after " + n + " attempts.");
        if (peerMessagingException instanceof HandShake.HandShakeException) {
            throw peerMessagingException;
        }
        if (peerMessagingException instanceof ConnectRefusedRemotelyException) {
            throw (ConnectRefusedRemotelyException)peerMessagingException;
        }
        throw new IllegalStateException("firstException is " + peerMessagingException + " but code should never reach this point without setting firstException to a valid value.");
    }

    public Connection activelyConnectTo(ServerSocketConnectInfo serverSocketConnectInfo, long l, long l2, PeerInstance peerInstance) throws HandShake.HandShakeException, ConnectRefusedRemotelyException, ConnectAttemptsInterruptedException, CouldNotConnectIOException, CouldNotConnectUnknownHostException {
        long l3;
        ServerSocketConnectInfo serverSocketConnectInfo2 = serverSocketConnectInfo.createCopyWithReasonableDeadline();
        assert (l > 0L) : "poll interval must be greater than 0 but is " + l;
        assert (l2 > 0L) : "timeout must be greater than 0 but is " + l2;
        assert (l <= l2) : "poll interval " + l + " is greater than timeout " + l2 + ". It'll still try twice.";
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Starting to poll on accept every " + l + " ms for " + l2 + " ms");
        long l4 = System.currentTimeMillis();
        PeerMessagingException peerMessagingException = null;
        do {
            try {
                return this.connectAndConfigureConnection(serverSocketConnectInfo2, peerInstance);
            }
            catch (HandShake.HandShakeException handShakeException) {
                if (peerMessagingException == null) {
                    peerMessagingException = handShakeException;
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo2 + ") caught exception", handShakeException);
            }
            catch (ConnectRefusedRemotelyException connectRefusedRemotelyException) {
                if (peerMessagingException == null) {
                    peerMessagingException = connectRefusedRemotelyException;
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo2 + ") caught exception", connectRefusedRemotelyException);
            }
            try {
                Thread.sleep(l);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                throw new ConnectAttemptsInterruptedException(serverSocketConnectInfo2, peerInstance, interruptedException);
            }
        } while (l2 > (l3 = System.currentTimeMillis()) - l4);
        try {
            return this.connectAndConfigureConnection(serverSocketConnectInfo2, peerInstance);
        }
        catch (HandShake.HandShakeException handShakeException) {
            if (peerMessagingException == null) {
                peerMessagingException = handShakeException;
            }
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo2 + ") caught exception during last attempt", handShakeException);
        }
        catch (ConnectRefusedRemotelyException connectRefusedRemotelyException) {
            if (peerMessagingException == null) {
                peerMessagingException = connectRefusedRemotelyException;
            }
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "activelyConnectTo(" + serverSocketConnectInfo2 + ") caught exception during last attempt", connectRefusedRemotelyException);
        }
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Failed to connect to " + serverSocketConnectInfo2 + " after " + l2 + " ms");
        if (peerMessagingException instanceof HandShake.HandShakeException) {
            throw peerMessagingException;
        }
        if (peerMessagingException instanceof ConnectRefusedRemotelyException) {
            throw (ConnectRefusedRemotelyException)peerMessagingException;
        }
        throw new IllegalStateException("firstException is " + peerMessagingException + " but code should never reach this point without setting firstException to a valid value.");
    }

    public static final class CouldNotConnectIOException
    extends CouldNotConnectException {
        private CouldNotConnectIOException(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance, IOException iOException) {
            super(serverSocketConnectInfo, instance, iOException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.CouldNotConnectIOFailure(this.getLocalPeerInstance().toString(), this.getConnectInfo().getSocketAddress().toString(), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.CouldNotConnectIOFailure(this.getLocalPeerInstance().toString(), this.getConnectInfo().getSocketAddress().toString(), this.getCause().getLocalizedMessage());
        }
    }

    public static final class CouldNotConnectUnknownHostException
    extends CouldNotConnectException {
        private CouldNotConnectUnknownHostException(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance, IOException iOException) {
            super(serverSocketConnectInfo, instance, iOException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.CouldNotConnectUnknownHost(this.getLocalPeerInstance().toString(), this.getConnectInfo().getSocketAddress().toString(), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.CouldNotConnectUnknownHost(this.getLocalPeerInstance().toString(), this.getConnectInfo().getSocketAddress().toString(), this.getCause().getLocalizedMessage());
        }
    }

    public static final class ConnectAttemptsInterruptedException
    extends CouldNotConnectException {
        private ConnectAttemptsInterruptedException(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance, InterruptedException interruptedException) {
            super(serverSocketConnectInfo, instance, interruptedException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.ConnectAttemptsInterrupted(this.getLocalPeerInstance().toString(), this.getConnectInfo().getSocketAddress().toString(), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.ConnectAttemptsInterrupted(this.getLocalPeerInstance().toString(), this.getConnectInfo().getSocketAddress().toString(), this.getCause().getLocalizedMessage());
        }
    }

    public static final class ConnectRefusedRemotelyException
    extends CouldNotConnectException {
        private ConnectRefusedRemotelyException(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance, ConnectException connectException) {
            super(serverSocketConnectInfo, instance, connectException);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.ConnectRefusedRemotely(this.getLocalPeerInstance().toString(), this.getConnectInfo().getSocketAddress().toString(), this.getConnectInfo().getSocketAddress().toString(), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.ConnectRefusedRemotely(this.getLocalPeerInstance().toString(), this.getConnectInfo().getSocketAddress().toString(), this.getConnectInfo().getSocketAddress().toString(), this.getCause().getLocalizedMessage());
        }
    }

    public static abstract class CouldNotConnectException
    extends PeerMessagingException {
        private final ServerSocketConnectInfo fConnectInfo;
        private final Instance fLocalPeerInstance;

        CouldNotConnectException(ServerSocketConnectInfo serverSocketConnectInfo, Instance instance, Exception exception) {
            super(exception);
            this.fConnectInfo = serverSocketConnectInfo;
            this.fLocalPeerInstance = instance;
        }

        public ServerSocketConnectInfo getConnectInfo() {
            return this.fConnectInfo;
        }

        public Instance getLocalPeerInstance() {
            return this.fLocalPeerInstance;
        }
    }
}

