/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.peermessaging;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.io.IoConstants;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectionFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.HandShake;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public abstract class AbstractPeerAcceptor {
    private final ServerSocketChannel fServerSocketChannel;
    private final Instance fLocalPeerInstance;
    private final ServerSocketAcceptInfo fAcceptInfo;
    private final ServerSocketConnectInfo fInfoToConnect;
    private final ConnectionFactory fConnectionFactory;

    AbstractPeerAcceptor(String string, Instance instance, ServerSocketAcceptInfo serverSocketAcceptInfo) throws InitializeServerSocketChannelException {
        ServerSocketAcceptInfo serverSocketAcceptInfo2 = serverSocketAcceptInfo.createCopyWithReasonableDeadline();
        if (null == string || string.isEmpty()) {
            String string2 = this.getClass().getSimpleName() + ": hostname must be defined, but hostname is '" + string + "'";
            PackageInfo.LOGGER.log(DistcompLevel.TWO, string2);
            throw new IllegalArgumentException(string2);
        }
        this.fLocalPeerInstance = instance;
        this.fAcceptInfo = serverSocketAcceptInfo2;
        this.fConnectionFactory = serverSocketAcceptInfo2.getAcceptorSecurityDescription().createConnectionFactoryForAcceptor();
        try {
            this.fServerSocketChannel = ServerSocketChannel.open();
        }
        catch (IOException iOException) {
            throw new CouldNotOpenServerSocketChannelException(string, instance, iOException);
        }
        try {
            int[] nArray = IoConstants.sSOCKET_PERFORMANCE_PREFS;
            this.fServerSocketChannel.socket().setPerformancePreferences(nArray[0], nArray[1], nArray[2]);
            try {
                this.fServerSocketChannel.configureBlocking(false);
            }
            catch (IOException iOException) {
                throw new CouldNotConfigureNonblockingServerSocketChannelException(string, instance, iOException);
            }
            InetAddress inetAddress = null;
            boolean bl = false;
            IOException iOException = null;
            int n = Integer.MIN_VALUE;
            int n2 = serverSocketAcceptInfo2.getMinPort() + serverSocketAcceptInfo2.getPortOffset();
            while (!bl && n2 <= serverSocketAcceptInfo2.getMaxPort()) {
                InetSocketAddress inetSocketAddress = new InetSocketAddress(inetAddress, n2);
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "AbstractPeerAcceptor for " + this.fLocalPeerInstance + " to be bound to " + inetSocketAddress + " with backlog " + this.fAcceptInfo.getBacklog());
                try {
                    this.fServerSocketChannel.socket().bind(inetSocketAddress, this.fAcceptInfo.getBacklog());
                    bl = true;
                }
                catch (BindException bindException) {
                    PackageInfo.LOGGER.log(DistcompLevel.SIX, "AbstractPeerAcceptor for " + this.fLocalPeerInstance + " failed to bind to " + inetSocketAddress, bindException);
                    n2 += serverSocketAcceptInfo2.getPortStep();
                }
                catch (IOException iOException2) {
                    PackageInfo.LOGGER.log(DistcompLevel.THREE, "AbstractPeerAcceptor for " + this.fLocalPeerInstance + " failed to bind to " + inetSocketAddress, iOException2);
                    n2 += serverSocketAcceptInfo2.getPortStep();
                    if (iOException != null) continue;
                    iOException = iOException2;
                    n = n2;
                }
            }
            if (!bl) {
                if (iOException != null) {
                    throw new CouldNotBindServerSocketChannelGeneralException(string, instance, n, iOException);
                }
                if (serverSocketAcceptInfo2.getMinPort() + serverSocketAcceptInfo2.getPortOffset() == serverSocketAcceptInfo2.getMaxPort()) {
                    throw new CouldNotBindServerSocketChannelToOnePortException(string, instance, serverSocketAcceptInfo2);
                }
                throw new CouldNotBindServerSocketChannelToPortsException(string, instance, serverSocketAcceptInfo2);
            }
            int n3 = this.fServerSocketChannel.socket().getLocalPort();
            this.fInfoToConnect = ServerSocketConnectInfo.createServerSocketConnectInfo(serverSocketAcceptInfo2, string, n3);
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "AbstractPeerAcceptor for " + this.fLocalPeerInstance + " constructed using " + this.fInfoToConnect.getSocketAddress());
        }
        catch (InitializeServerSocketChannelException | RuntimeException exception) {
            AbstractPeerAcceptor.safeCloseServerSocketChannel(this.fServerSocketChannel);
            throw exception;
        }
    }

    public ServerSocketConnectInfo getInfoToConnect() {
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "getInfoToConnect() will return " + this.fInfoToConnect);
        return this.fInfoToConnect;
    }

    ServerSocketAcceptInfo getAcceptInfo() {
        return this.fAcceptInfo;
    }

    public void close() {
        AbstractPeerAcceptor.safeCloseServerSocketChannel(this.fServerSocketChannel);
    }

    private static void safeCloseServerSocketChannel(ServerSocketChannel serverSocketChannel) {
        try {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Closing " + serverSocketChannel);
            serverSocketChannel.close();
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "IOException closing server socket channel", iOException);
        }
    }

    protected Instance getLocalPeerInstance() {
        return this.fLocalPeerInstance;
    }

    protected ServerSocketChannel getServerSocketChannel() {
        return this.fServerSocketChannel;
    }

    protected Connection createConnection(SocketChannel socketChannel) throws HandShake.HandShakeException, CouldNotConfigureSocketChannelException {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, this.fLocalPeerInstance.toString() + " " + socketChannel + " about to be configured.");
        try {
            socketChannel.socket().setTcpNoDelay(false);
            socketChannel.configureBlocking(true);
        }
        catch (IOException iOException) {
            throw new CouldNotConfigureSocketChannelException(socketChannel, iOException);
        }
        PackageInfo.LOGGER.log(DistcompLevel.SIX, this.fLocalPeerInstance.toString() + " " + socketChannel + " configured.");
        return this.fConnectionFactory.createConnection(socketChannel, this.fLocalPeerInstance, this.fAcceptInfo, false);
    }

    public static final class CouldNotBindServerSocketChannelGeneralException
    extends InitializeServerSocketChannelException {
        private final String fLocalHostname;
        private final Instance fLocalPeerInstance;
        private final int fProblemPort;

        private CouldNotBindServerSocketChannelGeneralException(String string, Instance instance, int n, IOException iOException) {
            super(iOException);
            this.fLocalHostname = string;
            this.fLocalPeerInstance = instance;
            this.fProblemPort = n;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.SocketChannelBindingGeneralFailure(this.fLocalPeerInstance.toString(), this.fLocalHostname, Integer.toString(this.fProblemPort), this.getCause().getMessage());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.SocketChannelBindingGeneralFailure(this.fLocalPeerInstance.toString(), this.fLocalHostname, Integer.toString(this.fProblemPort), this.getCause().getLocalizedMessage());
        }
    }

    public static final class CouldNotBindServerSocketChannelToOnePortException
    extends InitializeServerSocketChannelException {
        private final BaseMsgID fMessageID;

        private CouldNotBindServerSocketChannelToOnePortException(String string, Instance instance, ServerSocketAcceptInfo serverSocketAcceptInfo) {
            this.fMessageID = new peermessaging.CouldNotBindServerSocketChannelToOnePort(instance.toString(), string, Integer.toString(serverSocketAcceptInfo.getMinPort() + serverSocketAcceptInfo.getPortOffset()));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    public static final class CouldNotBindServerSocketChannelToPortsException
    extends InitializeServerSocketChannelException {
        private final BaseMsgID fMessageID;

        private CouldNotBindServerSocketChannelToPortsException(String string, Instance instance, ServerSocketAcceptInfo serverSocketAcceptInfo) {
            this.fMessageID = new peermessaging.CouldNotBindServerSocketChannelToPorts(instance.toString(), string, Integer.toString(serverSocketAcceptInfo.getMinPort() + serverSocketAcceptInfo.getPortOffset()), Integer.toString(serverSocketAcceptInfo.getMaxPort()), Integer.toString(serverSocketAcceptInfo.getPortStep()));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    public static final class CouldNotConfigureNonblockingServerSocketChannelException
    extends InitializeServerSocketChannelException {
        private final BaseMsgID fMessageID;

        private CouldNotConfigureNonblockingServerSocketChannelException(String string, Instance instance, IOException iOException) {
            super(iOException);
            this.fMessageID = new peermessaging.NonblockingServerSocketChannelNotConfigured(instance.toString(), string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    public static final class CouldNotOpenServerSocketChannelException
    extends InitializeServerSocketChannelException {
        private final BaseMsgID fMessageID;

        private CouldNotOpenServerSocketChannelException(String string, Instance instance, IOException iOException) {
            super(iOException);
            this.fMessageID = new peermessaging.SocketChannelOpeningFailed(instance.toString(), string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    public static abstract class InitializeServerSocketChannelException
    extends PeerMessagingException {
        InitializeServerSocketChannelException(IOException iOException) {
            super(iOException);
        }

        private InitializeServerSocketChannelException() {
        }
    }

    public static final class CouldNotConfigureSocketChannelException
    extends PeerMessagingException {
        private final InetSocketAddress fRemoteSocketAddress;
        private final InetSocketAddress fLocalSocketAddress;

        private CouldNotConfigureSocketChannelException(SocketChannel socketChannel, IOException iOException) {
            super(iOException);
            this.fLocalSocketAddress = (InetSocketAddress)socketChannel.socket().getLocalSocketAddress();
            this.fRemoteSocketAddress = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return new peermessaging.SocketChannelConfigurationFailed(this.getCause().getMessage(), this.fRemoteSocketAddress.toString(), this.fLocalSocketAddress.toString());
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return new peermessaging.SocketChannelConfigurationFailed(this.getCause().getLocalizedMessage(), this.fRemoteSocketAddress.toString(), this.fLocalSocketAddress.toString());
        }
    }
}

