/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.matlabpool.sessions;

import com.mathworks.toolbox.distcomp.pmode.CannotAcquireLabsException;
import com.mathworks.toolbox.distcomp.pmode.FatalErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.NonFatalErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.ParforController;
import com.mathworks.toolbox.distcomp.pmode.ParforControllerImpl;
import com.mathworks.toolbox.distcomp.pmode.SessionDestroyedException;
import com.mathworks.toolbox.distcomp.pmode.SessionFactory;
import com.mathworks.toolbox.distcomp.pmode.SessionInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.matlabpool.sessions.ConnectionTopology;
import com.mathworks.toolbox.distcomp.pmode.matlabpool.sessions.Log;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.KeepAlive;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ConnectionManager;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.MatlabPoolPeerInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.SessionRoleMapping;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionServicesFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionStartupFailedException;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ClientSessionBuilder {
    private ClientSessionBuilder() {
    }

    public static Future<SessionService> initiate(ConnectionManager.Acceptor acceptor, boolean bl, SessionInfo sessionInfo) {
        return ClientSessionBuilder.initiate(acceptor, bl, sessionInfo, new AtomicInteger(0), ConnectionTopology.ALL_WORKERS_CONNECT_TO_CLIENT);
    }

    public static Future<SessionService> initiate(ConnectionManager.Acceptor acceptor, boolean bl, SessionInfo sessionInfo, AtomicInteger atomicInteger, ConnectionTopology connectionTopology) {
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)"ClientSessionBuilder.initiate-", (Logger)Log.LOGGER));
        Future<SessionService> future = executorService.submit(new ClientSessionTask(acceptor, bl, sessionInfo, atomicInteger, connectionTopology));
        executorService.shutdown();
        return future;
    }

    private static class SimpleParforFactory
    implements ParforController.Factory {
        private final ParforControllerImpl.BroadcastPolicy fParforBroadcastPolicy;

        private SimpleParforFactory(ParforControllerImpl.BroadcastPolicy broadcastPolicy) {
            this.fParforBroadcastPolicy = broadcastPolicy;
        }

        @Override
        public ParforController build(SessionService sessionService) throws SessionDestroyedException, CannotAcquireLabsException {
            return ParforControllerImpl.create(sessionService, this.fParforBroadcastPolicy);
        }
    }

    private static final class ClientSessionServicesFactory
    implements SessionServicesFactory {
        private final List<Instance> fInitialDirectInstances = new ArrayList<Instance>();
        private final boolean fEnableSpmd;
        private final ConnectionTopology fConnectionTopology;

        private ClientSessionServicesFactory(List<Connection> list, boolean bl, ConnectionTopology connectionTopology) {
            for (Connection connection : list) {
                this.fInitialDirectInstances.add(connection.getRemoteInstance());
            }
            this.fEnableSpmd = bl;
            this.fConnectionTopology = connectionTopology;
        }

        @Override
        public SessionErrorHandler buildErrorHandler(SessionRoleMapping sessionRoleMapping) {
            boolean bl = true;
            if (this.fEnableSpmd) {
                return new FatalErrorHandler(bl, sessionRoleMapping);
            }
            if (this.fConnectionTopology == ConnectionTopology.ALL_WORKERS_CONNECT_TO_CLIENT) {
                List<Instance> list = Collections.emptyList();
                return new NonFatalErrorHandler(bl, sessionRoleMapping, this.fInitialDirectInstances, list);
            }
            return new NonFatalErrorHandler(bl, sessionRoleMapping, this.fInitialDirectInstances, this.fInitialDirectInstances);
        }

        @Override
        public KeepAlive buildKeepAlive(OutputGroup outputGroup) {
            return new KeepAlive(outputGroup, this.fInitialDirectInstances);
        }

        @Override
        public ParforController.Factory getParforControllerFactory() {
            if (this.fConnectionTopology == ConnectionTopology.ALL_WORKERS_CONNECT_TO_CLIENT) {
                return new SimpleParforFactory(ParforControllerImpl.BroadcastPolicy.FOLD_WITH_FIRST_INTERVAL);
            }
            return new SimpleParforFactory(ParforControllerImpl.BroadcastPolicy.SEND_TO_ALL);
        }
    }

    private static final class ClientSessionTask
    implements Callable<SessionService> {
        private final ConnectionManager.Acceptor fAcceptor;
        private final boolean fEnableSpmd;
        private final SessionInfo fStartupInfo;
        private final AtomicInteger fCounter;
        private final List<Connection> fConnections;
        private final ConnectionTopology fStrategy;

        private ClientSessionTask(ConnectionManager.Acceptor acceptor, boolean bl, SessionInfo sessionInfo, AtomicInteger atomicInteger, ConnectionTopology connectionTopology) {
            this.fAcceptor = acceptor;
            this.fEnableSpmd = bl;
            this.fStartupInfo = sessionInfo;
            this.fCounter = atomicInteger;
            this.fConnections = new LinkedList<Connection>();
            this.fStrategy = connectionTopology;
        }

        private int getConnection() throws InterruptedException, IOException {
            Log.LOGGER.info("In ClientSessionTask.getConnection()");
            while (true) {
                Connection connection;
                if ((connection = this.fAcceptor.activelyAccept()) != null) {
                    Log.LOGGER.info("In ClientSessionTask.getConnection() - got Connection.");
                    return this.handleConnection(connection);
                }
                Log.LOGGER.fine("In ClientSessionTask.getConnection() - no Connection.");
                Thread.sleep(10L);
            }
        }

        private int handleConnection(Connection connection) throws IOException {
            Instance instance = connection.getRemoteInstance();
            if (instance instanceof MatlabPoolPeerInstance) {
                MatlabPoolPeerInstance matlabPoolPeerInstance = (MatlabPoolPeerInstance)instance;
                Log.LOGGER.info("In ClientSessionTask.handleConnection() - got matlabPoolPeerInstance: " + matlabPoolPeerInstance);
                int n = matlabPoolPeerInstance.getNumberOfLabs();
                this.fConnections.add(connection);
                int n2 = this.fCounter.incrementAndGet();
                Log.LOGGER.info("In ClientSessionTask.handleConnection() - now connected to: " + n2);
                return n;
            }
            connection.close();
            throw new BadInstanceClassException();
        }

        private void getConnections() throws InterruptedException, BadInstanceClassException, IOException {
            int n = this.getConnection();
            if (this.fStrategy == ConnectionTopology.WORKERS_PROXIED_BY_LAB_ONE) {
                Log.LOGGER.info("In ClientSessionTask.getConnections() - proxied workers, returning now.");
                return;
            }
            Log.LOGGER.info("In ClientSessionTask.getConnections() - expecting " + n + " connections.");
            for (int i = 2; i <= n; ++i) {
                int n2 = this.getConnection();
                assert (n2 == n);
            }
        }

        @Override
        public SessionService call() throws InterruptedException, IOException, SessionStartupFailedException {
            try {
                Log.LOGGER.warning("In ClientSessionTask.call()");
                this.getConnections();
            }
            catch (IOException | InterruptedException | RuntimeException exception) {
                Log.LOGGER.log(Level.WARNING, "ClientSessionTask.call() caught exception, about to closeConnections.", exception);
                this.closeConnections();
                throw exception;
            }
            return SessionFactory.createClientSession(new ClientSessionServicesFactory(this.fConnections, this.fEnableSpmd, this.fStrategy), this.fConnections, this.fAcceptor.getLocalInstance(), this.fEnableSpmd, this.fStartupInfo);
        }

        private void closeConnections() {
            for (Connection connection : this.fConnections) {
                try {
                    Log.LOGGER.warning("ClientSessionTask closing a single connection: " + connection);
                    connection.close();
                }
                catch (IOException iOException) {
                    Log.LOGGER.log(Level.SEVERE, "ClientSessionTask caught exception closing a connection.", iOException);
                }
            }
        }
    }

    private static final class BadInstanceClassException
    extends RuntimeException {
        private BadInstanceClassException() {
        }
    }
}

