/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io.broker;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerCompletedRequestReply;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerException;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerMessage;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerPeerSessionFactory;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerRegisteredAcceptorReply;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectInfoRequest;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredConnectReadyToAcceptReply;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokeredSocketConnectInfo;
import com.mathworks.toolbox.distcomp.pmode.io.broker.Log;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerConnector;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerMessagingRuntimeException;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.shared.AbstractMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.ConnectorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.util.concurrent.SignalingAtomicBoolean;
import java.util.List;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class BrokeredActiveAcceptor
extends AbstractMessageObserver {
    private static final AtomicLong SEQUENCE_NUMBER_SOURCE = new AtomicLong(0L);
    private final PeerSession fBrokerPeerSession;
    private final BrokeredAcceptInfo fBrokeredAcceptInfo;
    private final BrokeredSocketConnectInfo fConnectInfo;
    private final Instance fLocalPeer;
    private final String fLogId;
    private final SignalingAtomicBoolean fHasBrokerAcknowledgedRequest = new SignalingAtomicBoolean(false);
    private final ThreadPoolExecutor fConnectionExecutor;
    private final BlockingDeque<ExceptionOrConnection> fConnectionQueue = new LinkedBlockingDeque<ExceptionOrConnection>();

    public static BrokeredActiveAcceptor createBrokeredActiveAcceptor(Instance instance, BrokeredAcceptInfo brokeredAcceptInfo) throws PeerMessagingException, InterruptedException {
        String string = BrokeredActiveAcceptor.class.getSimpleName() + " for " + instance;
        BrokeredActiveAcceptor brokeredActiveAcceptor = new BrokeredActiveAcceptor(instance, brokeredAcceptInfo);
        try {
            if (!brokeredActiveAcceptor.awaitBrokerAcknowledgeOfRequest()) {
                throw new BrokerDidNotAckException(instance, brokeredAcceptInfo);
            }
            Log.LOGGER.finest(string + " in createBrokeredActiveAcceptor() broker has acknowledged " + brokeredAcceptInfo);
        }
        catch (InterruptedException interruptedException) {
            Log.LOGGER.log(Level.FINE, string + "Interrupted while waiting for broker to acknowledge", interruptedException);
            throw interruptedException;
        }
        return brokeredActiveAcceptor;
    }

    private BrokeredActiveAcceptor(Instance instance, BrokeredAcceptInfo brokeredAcceptInfo) throws PeerMessagingException {
        BrokeredAcceptInfo brokeredAcceptInfo2 = brokeredAcceptInfo.createCopyWithReasonableDeadline();
        this.fLogId = this.getClass().getSimpleName() + " for " + instance;
        this.fLocalPeer = instance;
        this.fBrokeredAcceptInfo = brokeredAcceptInfo2;
        Log.LOGGER.finest(this.fLogId + " starting BrokeredActiveAcceptor with " + this.fBrokeredAcceptInfo + " for " + instance);
        this.fConnectionExecutor = new ThreadPoolExecutor(32, 32, brokeredAcceptInfo2.getBrokeredConnectAcceptorTimeout(), TimeUnit.MILLISECONDS, new LinkedBlockingDeque<Runnable>(), (ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)"BrokeredActiveAcceptor connect pool", (Logger)Log.LOGGER));
        this.fConnectionExecutor.allowCoreThreadTimeOut(true);
        Log.LOGGER.finer(this.fLogId + " started ConnectionExecutor thread pool");
        this.fConnectInfo = new BrokeredSocketConnectInfo(this.fBrokeredAcceptInfo);
        PeerInstance peerInstance = BrokerPeerSessionFactory.createPeerOfBroker(this.fBrokeredAcceptInfo.getBrokerClientInfo());
        Connection connection = BrokerPeerSessionFactory.createConnectionToBroker(peerInstance, this.fBrokeredAcceptInfo.getBrokerClientInfo(), this.fLogId);
        this.fBrokerPeerSession = BrokerPeerSessionFactory.createPeerSessionWithBroker(peerInstance, connection, this.fLogId);
        Log.LOGGER.finest(this.fLogId + " created session " + this.fBrokerPeerSession + " with " + this.fBrokeredAcceptInfo.getBrokerClientInfo() + " for " + this.fBrokeredAcceptInfo.getGroupUUID() + " " + instance);
        BrokeredConnectInfoRequest brokeredConnectInfoRequest = new BrokeredConnectInfoRequest(this.fBrokeredAcceptInfo.getGroupUUID(), SEQUENCE_NUMBER_SOURCE.getAndIncrement());
        this.fBrokerPeerSession.getOutputGroup().sendTo(connection.getRemoteInstance(), (ObservableMessage)brokeredConnectInfoRequest, (MessageObserver)this);
        Log.LOGGER.finest(this.fLogId + " sent " + brokeredConnectInfoRequest + " to " + this.fBrokeredAcceptInfo.getBrokerClientInfo() + " for " + this.fBrokeredAcceptInfo.getGroupUUID() + " " + instance);
    }

    public BrokeredSocketConnectInfo getInfoToConnect() {
        return this.fConnectInfo;
    }

    private boolean awaitBrokerAcknowledgeOfRequest() throws InterruptedException {
        boolean bl = this.fHasBrokerAcknowledgedRequest.awaitTrue(this.fBrokeredAcceptInfo.getBrokerClientInfo().getBrokerConnectTimeout(), TimeUnit.MILLISECONDS);
        if (!bl) {
            Log.LOGGER.log(Level.WARNING, this.fLogId + "The broker failed to acknowledge before the timeout of " + this.fBrokeredAcceptInfo.getBrokerClientInfo().getBrokerConnectTimeout());
        }
        return bl;
    }

    private void brokerAcknowledgedRequest() {
        this.fHasBrokerAcknowledgedRequest.set(true);
    }

    public Connection activelyAcceptOnce() throws PeerMessagingException {
        ExceptionOrConnection exceptionOrConnection = this.fConnectionQueue.poll();
        if (exceptionOrConnection == null) {
            Log.LOGGER.finest(this.fLogId + " activelyAcceptOnce for " + this.fConnectInfo + " polled " + null);
            return null;
        }
        Connection connection = exceptionOrConnection.getConnection();
        Log.LOGGER.fine(this.fLogId + " activelyAcceptOnce for " + this.fConnectInfo + " connected to " + connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            this.shutdownPeerSessionWithBroker();
        }
        finally {
            List<Runnable> list = this.fConnectionExecutor.shutdownNow();
            Log.LOGGER.finer(this.fLogId + " shut down executor with " + list.size() + " remaining to do.");
        }
    }

    private void shutdownPeerSessionWithBroker() {
        Log.LOGGER.finest(this.fLogId + " will shut down " + this.fBrokerPeerSession);
        this.fBrokerPeerSession.normalShutdown();
        Log.LOGGER.fine(this.fLogId + " shut down " + this.fBrokerPeerSession);
    }

    @Override
    public void completed(ReturnMessage returnMessage, Instance instance) {
        Object object;
        Log.LOGGER.finer(this.fLogId + " received " + returnMessage + " from " + instance);
        if (returnMessage instanceof BrokerMessage) {
            object = (BrokerMessage)((Object)returnMessage);
            if (!object.getGroupUuid().equals(this.fBrokeredAcceptInfo.getGroupUUID())) {
                String string = this.fLogId + ": Got reply for the wrong group. Expected " + this.fBrokeredAcceptInfo.getGroupUUID() + " got " + object.getGroupUuid();
                assert (object.getGroupUuid().equals(this.fBrokeredAcceptInfo.getGroupUUID())) : string;
                Log.LOGGER.warning(string);
            }
        } else {
            Log.LOGGER.warning(this.fLogId + " Expected " + returnMessage + " to be a " + BrokerMessage.class.getSimpleName() + " but it is a " + returnMessage.getClass());
        }
        if (returnMessage instanceof BrokerRegisteredAcceptorReply) {
            this.brokerAcknowledgedRequest();
        } else if (returnMessage instanceof BrokeredConnectReadyToAcceptReply) {
            object = new RunsConnect(this.fConnectionQueue, (BrokeredConnectReadyToAcceptReply)returnMessage, this.fBrokeredAcceptInfo, this.fLocalPeer, this.fLogId);
            this.fConnectionExecutor.execute((Runnable)object);
            Log.LOGGER.finest(this.fLogId + " submitted " + returnMessage);
        } else if (returnMessage instanceof BrokerCompletedRequestReply) {
            this.shutdownPeerSessionWithBroker();
        } else {
            throw new UnsupportedOperationException(this.fLogId + " Unknown message type: " + returnMessage.getClass());
        }
    }

    private static final class BrokerDidNotAckException
    extends BrokerException {
        private final BaseMsgID fMessageID;

        private BrokerDidNotAckException(Instance instance, BrokeredAcceptInfo brokeredAcceptInfo) {
            this.fMessageID = new peermessaging.BrokerDidNotAck(instance.toString(), brokeredAcceptInfo.getBrokerClientInfo().getConnectToBrokerInfo().getSocketAddress().toString(), Long.toString(brokeredAcceptInfo.getBrokerClientInfo().getBrokerConnectTimeout()));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }

    private static final class ExceptionOrConnection {
        private final Connection fConnection;
        private final PeerMessagingException fPeerMessagingException;
        private final RuntimeException fRuntimeException;

        private ExceptionOrConnection(Connection connection) {
            this.fConnection = connection;
            this.fPeerMessagingException = null;
            this.fRuntimeException = null;
        }

        private ExceptionOrConnection(PeerMessagingException peerMessagingException) {
            this.fConnection = null;
            this.fPeerMessagingException = peerMessagingException;
            this.fRuntimeException = null;
        }

        private ExceptionOrConnection(RuntimeException runtimeException) {
            this.fConnection = null;
            this.fPeerMessagingException = null;
            this.fRuntimeException = runtimeException;
        }

        private Connection getConnection() throws PeerMessagingException {
            if (this.fRuntimeException != null) {
                throw new PeerMessagingRuntimeException("Could not accept using the broker.", this.fRuntimeException);
            }
            if (this.fPeerMessagingException != null) {
                throw this.fPeerMessagingException;
            }
            return this.fConnection;
        }

        public String toString() {
            return "ExceptionOrConnection{fConnection=" + this.fConnection + ", fPeerMessagingException=" + this.fPeerMessagingException + ", fRuntimeException=" + this.fRuntimeException + '}';
        }
    }

    private static class RunsConnect
    implements Runnable {
        private final BlockingDeque<ExceptionOrConnection> fConnectionQueue;
        private final BrokeredConnectReadyToAcceptReply fReply;
        private final BrokeredAcceptInfo fBrokeredAcceptInfo;
        private final Instance fLocalPeer;
        private final String fLogId;

        private RunsConnect(BlockingDeque<ExceptionOrConnection> blockingDeque, BrokeredConnectReadyToAcceptReply brokeredConnectReadyToAcceptReply, BrokeredAcceptInfo brokeredAcceptInfo, Instance instance, String string) {
            this.fConnectionQueue = blockingDeque;
            this.fReply = brokeredConnectReadyToAcceptReply;
            this.fBrokeredAcceptInfo = brokeredAcceptInfo;
            this.fLocalPeer = instance;
            this.fLogId = string;
        }

        @Override
        public void run() {
            try {
                PeerConnector peerConnector = new PeerConnector();
                ConnectorSecurityDescription connectorSecurityDescription = this.fBrokeredAcceptInfo.getAcceptorSecurityDescription().createConnectorSecurityDescription();
                ServerSocketConnectInfo serverSocketConnectInfo = this.fReply.getConnectInfo().createCopyReplaceSecurityDescription(connectorSecurityDescription).createCopyReplaceGroupImplementation(this.fBrokeredAcceptInfo.getGroupImplementation());
                Log.LOGGER.finer(this.fLogId + " CallsConnect for " + this.fBrokeredAcceptInfo + " will attempt to connect to " + serverSocketConnectInfo.getSocketAddress());
                Connection connection = peerConnector.activelyConnectTo(serverSocketConnectInfo, this.fLocalPeer);
                Log.LOGGER.fine(this.fLogId + " CallsConnect for " + this.fBrokeredAcceptInfo + " connected to " + connection);
                this.fConnectionQueue.add(new ExceptionOrConnection(connection));
            }
            catch (RuntimeException runtimeException) {
                this.fConnectionQueue.add(new ExceptionOrConnection(runtimeException));
            }
            catch (PeerMessagingException peerMessagingException) {
                this.fConnectionQueue.add(new ExceptionOrConnection(peerMessagingException));
            }
        }
    }
}

