/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode.io;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.peermessaging;
import com.mathworks.toolbox.distcomp.pmode.io.Log;
import com.mathworks.toolbox.distcomp.pmode.io.TopologyGraph;
import com.mathworks.toolbox.distcomp.pmode.io.TopologyMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.NoSuchDestinationException;
import com.mathworks.toolbox.distcomp.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

final class RoutingTable {
    private final TopologyGraph<Instance> fTopologyGraph = new TopologyGraph();
    private final Instance fLocalInstance;

    RoutingTable(Instance instance) {
        this.fLocalInstance = instance;
        this.fTopologyGraph.addVertices(Collections.singleton(instance));
    }

    void handleTopologyMessage(TopologyMessage topologyMessage) {
        Collection<Instance> collection = topologyMessage.getTargets();
        switch (topologyMessage.getType()) {
            case ESTABLISHED_COMMUNICATION: {
                Instance instance = topologyMessage.getSource();
                Log.LOGGER.info("Established Connection from " + instance + " to " + collection);
                this.fTopologyGraph.addVertices(Collections.singleton(instance));
                this.fTopologyGraph.addVertices(collection);
                this.fTopologyGraph.addEdges(instance, collection);
                break;
            }
            case LOST_COMMUNICATION: {
                Log.LOGGER.info("Lost Connection from to " + collection);
                this.fTopologyGraph.removeVertices(collection);
            }
        }
    }

    List<Instance> getAllKnownInstances() {
        return Collections.unmodifiableList(this.fTopologyGraph.getAllVertices());
    }

    Pair<Collection<Instance>, Collection<Instance>> mapDestinations(Collection<Instance> collection) throws NoSuchDestinationException {
        try {
            return this.fTopologyGraph.mapNextHopWherePossible(this.fLocalInstance, collection);
        }
        catch (TopologyGraph.NoVertexException noVertexException) {
            HashSet<Instance> hashSet = new HashSet<Instance>(collection);
            hashSet.removeAll(this.fTopologyGraph.getAllVertices());
            peermessaging.UnexpectedRoutingFailure unexpectedRoutingFailure = hashSet.isEmpty() ? new peermessaging.UnexpectedRoutingFailure() : new peermessaging.UnableToFindRoute(((Instance)hashSet.iterator().next()).toString());
            RoutingFailedException routingFailedException = new RoutingFailedException((BaseMsgID)unexpectedRoutingFailure);
            routingFailedException.initCause(noVertexException);
            throw routingFailedException;
        }
    }

    void filterForwardList(Instance instance, List<Instance> list) {
        HashSet<Instance> hashSet = new HashSet<Instance>();
        for (Instance instance2 : list) {
            try {
                if (!(this.fTopologyGraph.getDistance(instance, instance2) <= this.fTopologyGraph.getDistance(this.fLocalInstance, instance2))) continue;
                hashSet.add(instance2);
            }
            catch (TopologyGraph.NoVertexException noVertexException) {
                Log.LOGGER.warning("No route when filtering forwarding list." + noVertexException);
                hashSet.add(instance2);
            }
        }
        list.removeAll(hashSet);
    }

    void clear() {
        HashSet<Instance> hashSet = new HashSet<Instance>(this.fTopologyGraph.getAllVertices());
        hashSet.remove(this.fLocalInstance);
        this.fTopologyGraph.removeVertices(hashSet);
    }

    private static final class RoutingFailedException
    extends NoSuchDestinationException {
        private final BaseMsgID fMessageID;

        private RoutingFailedException(BaseMsgID baseMsgID) {
            this.fMessageID = baseMsgID;
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fMessageID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fMessageID;
        }
    }
}

