/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.CompletionObserver;
import com.mathworks.jmi.MatlabMCR;
import com.mathworks.toolbox.distcomp.pmode.BufferTransferCommand;
import com.mathworks.toolbox.distcomp.pmode.DependencyCommandResult;
import com.mathworks.toolbox.distcomp.pmode.FileDependenciesAssistant;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.distcomp.util.FileUtils;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.File;
import java.io.IOException;
import java.io.ObjectStreamException;

public final class UpdateFileDependencyCommand
extends BufferTransferCommand {
    private static final String CLEAR_COMMAND = "clear";
    private transient File fDependency;
    private transient File fChangedFile;
    private final String fDependencyStr;
    private final String fChangedFileStr;

    public UpdateFileDependencyCommand(ByteBufferHandle byteBufferHandle, File file, File file2) {
        super(byteBufferHandle);
        this.fChangedFile = file;
        this.fChangedFileStr = file.getPath();
        assert (this.fChangedFile.getPath().startsWith(file2.getPath())) : "File MUST begin with the same string as provided to find it in dependency list";
        this.fDependency = file2;
        this.fDependencyStr = file2.getPath();
    }

    private File getLocalFile(FileDependenciesAssistant fileDependenciesAssistant) throws IOException {
        File file = fileDependenciesAssistant.getLocalFileFromRemoteFile(this.fChangedFile, this.fDependency);
        if (!file.exists()) {
            FileUtils.createNewFileAndParent(file);
        }
        if (!file.canWrite()) {
            throw new IOException(file.getPath() + " is not writeable");
        }
        return file;
    }

    @Override
    public void dispatch(final ReturnGroup returnGroup, Instance instance, SessionService sessionService) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Dispatch of UpdateFileDependencyCommand for fChangedFile: " + this.fChangedFile + " in fDependency: " + this.fDependency);
        final DependencyCommandResult dependencyCommandResult = new DependencyCommandResult(this.getSequenceNumber());
        try {
            assert (this.fBuffer != null) : "Input ByteBuffer was null";
            final File file = this.getLocalFile(sessionService.getFileDependenciesAssistant());
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "UpdateFileDependencyCommand: localFile: " + file);
            MatlabMCR matlabMCR = MatlabRefStore.getMatlabRef();
            matlabMCR.feval(CLEAR_COMMAND, new Object[]{file.getPath()}, new CompletionObserver(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed(int n, Object object) {
                    try {
                        PackageInfo.LOGGER.log(DistcompLevel.ONE, "MATLAB clear complete, about to write file.");
                        UpdateFileDependencyCommand.this.writeBufferToFile(file);
                    }
                    catch (Throwable throwable) {
                        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Throwable caught during completion observer execution.", throwable);
                        dependencyCommandResult.setException(throwable);
                    }
                    finally {
                        returnGroup.returnTo(UpdateFileDependencyCommand.this.getSourceProcess(), (ReturnMessage)dependencyCommandResult);
                        UpdateFileDependencyCommand.this.fBuffer.free();
                    }
                }
            });
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "Throwable caught during dispatch.", throwable);
            dependencyCommandResult.setException(throwable);
            returnGroup.returnTo(this.getSourceProcess(), (ReturnMessage)dependencyCommandResult);
            this.fBuffer.free();
        }
    }

    private Object readResolve() throws ObjectStreamException {
        this.fDependency = new File(this.fDependencyStr);
        this.fChangedFile = new File(this.fChangedFileStr);
        return this;
    }
}

