/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.CannotAcquireLabsException;
import com.mathworks.toolbox.distcomp.pmode.CmdWinOutput;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutput;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutputImpl;
import com.mathworks.toolbox.distcomp.pmode.FevalResult;
import com.mathworks.toolbox.distcomp.pmode.LanguageControllerProvider;
import com.mathworks.toolbox.distcomp.pmode.MFevalCommand;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.RemoteCompositeAssistant;
import com.mathworks.toolbox.distcomp.pmode.SessionDestroyedException;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.SpmdBlock;
import com.mathworks.toolbox.distcomp.pmode.SpmdBlockResult;
import com.mathworks.toolbox.distcomp.pmode.SpmdController;
import com.mathworks.toolbox.distcomp.pmode.SpmdInterrupt;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.AbstractRoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleCommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleMessageObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.RoleOutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ResourceManager;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.ByteBufferHandle;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.Nullable;

public final class SpmdControllerImpl
implements SpmdController {
    private static final AtomicInteger TAG_GEN = new AtomicInteger(0);
    private final int fTag;
    private final ResourceManager fResourceManager;
    private final RoleOutputGroup fOutGroup;
    private final SessionService fSessionService;
    private final RemoteCompositeAssistant fRemoteCompositeAssistant;
    private final Map<ProcessInstance, Integer> fLabs;
    private int fNumlabs;
    private int fNumLabsNotified;
    private DrainableOutput fDrainableOutput;
    private long fBlockSequences;
    private MessageTracker fBlockExecutionTracker;
    private MessageTracker fCleanupTracker;
    private MessageTracker fKeyFlushTracker;
    private AtomicBoolean fInterruptsSent;
    private AtomicBoolean fInterruptsWaited;
    private Semaphore fBlockSendCompleted;
    private Semaphore fInterruptSendCompleted;
    private ProcessInstance fProcessCausingInterrupt = null;
    private ReturnMessage fMessageCausingInterrupt = null;

    @Override
    public synchronized ProcessInstance getProcessCausingInterrupt() {
        return this.fProcessCausingInterrupt;
    }

    @Override
    public synchronized ReturnMessage getMessageCausingInterrupt() {
        return this.fMessageCausingInterrupt;
    }

    static SpmdController create(SessionService sessionService, LanguageControllerProvider languageControllerProvider) throws SessionDestroyedException, CannotAcquireLabsException {
        Object object;
        int n = TAG_GEN.incrementAndGet();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Creating a new SpmdControllerImpl " + n);
        ResourceManager resourceManager = sessionService.getResourceManager();
        RemoteCompositeAssistant remoteCompositeAssistant = languageControllerProvider.getCompositeAssistant();
        RoleCommunicationGroup roleCommunicationGroup = sessionService.getRoleCommGroup();
        if (!sessionService.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        try {
            object = resourceManager.acquireCurrentHolderToken(60000L);
        }
        catch (InterruptedException interruptedException) {
            object = null;
        }
        if (object == null) {
            throw new CannotAcquireLabsException(60000L);
        }
        SpmdControllerImpl spmdControllerImpl = new SpmdControllerImpl(remoteCompositeAssistant, resourceManager, sessionService, roleCommunicationGroup, n);
        resourceManager.setCurrentHolder(spmdControllerImpl, object);
        spmdControllerImpl.notifyAcquiredWorkers(sessionService.getPoolSize());
        return spmdControllerImpl;
    }

    private SpmdControllerImpl(RemoteCompositeAssistant remoteCompositeAssistant, ResourceManager resourceManager, SessionService sessionService, RoleOutputGroup roleOutputGroup, int n) {
        this.fTag = n;
        this.fResourceManager = resourceManager;
        this.fOutGroup = roleOutputGroup;
        this.fSessionService = sessionService;
        this.fRemoteCompositeAssistant = remoteCompositeAssistant;
        this.fLabs = new TreeMap<ProcessInstance, Integer>();
        this.fBlockSequences = -1L;
        this.fNumlabs = -1;
    }

    @Override
    public ReturnMessage getCleanupResult(ProcessInstance processInstance) {
        return this.fCleanupTracker.getResult(processInstance);
    }

    @Override
    public ReturnMessage getBlockResult(ProcessInstance processInstance) {
        return this.fBlockExecutionTracker.getResult(processInstance);
    }

    @Override
    public ReturnMessage getKeyFlushResult(ProcessInstance processInstance) {
        return this.fKeyFlushTracker.getResult(processInstance);
    }

    public boolean acquireLabs(ProcessInstance processInstance) throws SessionDestroyedException {
        return this.acquireLabs(new ProcessInstance[]{processInstance});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean acquireLabs(ProcessInstance[] processInstanceArray) throws SessionDestroyedException {
        if (!this.fSessionService.isSessionRunning()) {
            throw new SessionDestroyedException();
        }
        Map<ProcessInstance, Integer> map = this.fLabs;
        synchronized (map) {
            for (int i = 0; i < processInstanceArray.length; ++i) {
                this.fLabs.put(processInstanceArray[i], i);
            }
        }
        this.fNumlabs = processInstanceArray.length;
        boolean bl = true;
        this.fDrainableOutput = new DrainableOutputImpl(Arrays.asList(processInstanceArray), bl, 1000000);
        this.fBlockExecutionTracker = new MessageTracker(this.fNumlabs);
        this.fCleanupTracker = new MessageTracker(this.fNumlabs);
        this.fKeyFlushTracker = new MessageTracker(this.fNumlabs);
        this.fInterruptsSent = new AtomicBoolean(false);
        this.fInterruptsWaited = new AtomicBoolean(false);
        this.fBlockSendCompleted = new Semaphore(0);
        this.fInterruptSendCompleted = new Semaphore(0);
        this.notifyReleaseWorkers();
        this.notifyAcquiredWorkers(this.fNumlabs);
        return true;
    }

    private void notifyAcquiredWorkers(int n) {
        this.fNumLabsNotified = n;
        this.fSessionService.getSessionWorkerNotifier().notifyAcquiredWorkers(n);
    }

    private void notifyReleaseWorkers() {
        this.fSessionService.getSessionWorkerNotifier().notifyReleasedWorkers(this.fNumLabsNotified);
        this.fNumLabsNotified = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void initiateRemoteSpmdBlock(ByteBufferHandle[] abstractRoleMessageObserver, ByteBufferHandle[] byteBufferHandleArray) {
        boolean bl = this.fBlockExecutionTracker.markSent();
        assert (!bl) : "Attempt to send block twice";
        try {
            AbstractRoleMessageObserver abstractRoleMessageObserver2 = new AbstractRoleMessageObserver(){

                @Override
                public void completed(ReturnMessage returnMessage, ProcessInstance processInstance) {
                    SpmdControllerImpl.this.handleBlockReturn(returnMessage, processInstance);
                }
            };
            HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
            ArrayList<ProcessInstance> arrayList = new ArrayList<ProcessInstance>(this.fLabs.keySet());
            for (ProcessInstance processInstance : arrayList) {
                hashMap.put(processInstance.getLabIndex(), this.fRemoteCompositeAssistant.returnRemoteClearKeys(processInstance));
            }
            SpmdBlock spmdBlock = new SpmdBlock((ByteBufferHandle[])abstractRoleMessageObserver, (ByteBufferHandle[])byteBufferHandleArray, hashMap);
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + "sending execution with sequence " + spmdBlock.getSequenceNumber());
            this.fOutGroup.sendTo(arrayList, (ObservableMessage)spmdBlock, (RoleMessageObserver)abstractRoleMessageObserver2);
            this.fBlockSequences = spmdBlock.getSequenceNumber();
            this.fCleanupTracker.markSent();
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD " + this.fTag + " release fBlockSendCompleted semaphore");
            this.fBlockSendCompleted.release();
        }
        catch (Throwable throwable) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD " + this.fTag + " release fBlockSendCompleted semaphore");
            this.fBlockSendCompleted.release();
            for (ByteBufferHandle byteBufferHandle : abstractRoleMessageObserver) {
                byteBufferHandle.free();
            }
            for (ByteBufferHandle byteBufferHandle : byteBufferHandleArray) {
                byteBufferHandle.free();
            }
            throw throwable;
        }
        for (ByteBufferHandle byteBufferHandle : abstractRoleMessageObserver) {
            byteBufferHandle.free();
        }
        for (ByteBufferHandle byteBufferHandle : byteBufferHandleArray) {
            byteBufferHandle.free();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initiateKeyFlush() {
        Object object = null;
        try {
            object = this.fResourceManager.acquireCurrentHolderToken(60000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (object == null) {
            this.fKeyFlushTracker.skip();
            return;
        }
        this.fResourceManager.setCurrentHolder(this, object);
        this.notifyAcquiredWorkers(this.fNumlabs);
        boolean bl = false;
        try {
            boolean bl2 = this.fKeyFlushTracker.markSent();
            assert (!bl2) : "Attempt to send block twice";
            AbstractRoleMessageObserver abstractRoleMessageObserver = new AbstractRoleMessageObserver(){

                @Override
                public void completed(ReturnMessage returnMessage, ProcessInstance processInstance) {
                    SpmdControllerImpl.this.handleKeyFlushReturn(returnMessage, processInstance);
                }
            };
            for (ProcessInstance processInstance : this.fLabs.keySet()) {
                Object object2 = this.fRemoteCompositeAssistant.returnRemoteClearKeys(processInstance);
                if (object2 != null) {
                    MFevalCommand mFevalCommand = new MFevalCommand("spmdlang.remoteClear", new Object[]{object2}, 2);
                    this.fOutGroup.sendTo(processInstance, (ObservableMessage)mFevalCommand, (RoleMessageObserver)abstractRoleMessageObserver);
                    bl = true;
                    continue;
                }
                this.fKeyFlushTracker.messageReturned(processInstance, null);
            }
        }
        finally {
            if (!bl) {
                this.notifyReleaseWorkers();
                this.fResourceManager.releaseCurrentHolder(this);
            }
        }
    }

    public boolean awaitKeyFlush(long l, TimeUnit timeUnit) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " key flush...");
        boolean bl = this.fKeyFlushTracker.await(l, timeUnit);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " block: " + bl);
        return bl;
    }

    @Override
    public void interrupt() {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Executing " + this.fTag + " block interrupt");
        if (!this.fBlockExecutionTracker.alreadySent()) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Interrupt for SPMD " + this.fTag + " but block was never sent - simply dispose");
        } else {
            this.sendInterrupt();
        }
    }

    private void sendInterrupt() {
        boolean bl = this.fInterruptsSent.getAndSet(true);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD sendInterrupt() - interrupts already sent? " + bl);
        if (!bl) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD sendInterrupt() - actually sending interrupt for tag " + this.fTag);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD sendInterrupt() - acquiring semaphore");
                    try {
                        SpmdControllerImpl.this.fBlockSendCompleted.acquire();
                    }
                    catch (InterruptedException interruptedException) {
                        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD sendInterrupt() - caught InterruptedException", interruptedException);
                    }
                    PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD sendInterrupt() - acquired semaphore");
                    try {
                        for (ProcessInstance processInstance : SpmdControllerImpl.this.fLabs.keySet()) {
                            SpmdInterrupt spmdInterrupt = new SpmdInterrupt(SpmdControllerImpl.this.fBlockSequences);
                            SpmdControllerImpl.this.fOutGroup.sendTo(processInstance, (Message)spmdInterrupt);
                        }
                        PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD sendInterrupt() - finished sending interrupts for " + SpmdControllerImpl.this.fTag);
                    }
                    finally {
                        SpmdControllerImpl.this.fInterruptSendCompleted.release();
                        PackageInfo.LOGGER.log(DistcompLevel.SIX, "SPMD sendInterrupt() - released fInterruptSendCompleted " + SpmdControllerImpl.this.fTag);
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.start();
        }
    }

    private void waitForInterruptsToCompleteSending() {
        boolean bl;
        boolean bl2 = this.fInterruptsSent.get();
        if (bl2 && !(bl = this.fInterruptsWaited.getAndSet(true))) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + " interrupts were sent but not yet waited, waiting for them to complete");
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + " wait - fInterruptSendCompleted.availablePermits(): " + this.fInterruptSendCompleted.availablePermits());
            try {
                this.fInterruptSendCompleted.acquire();
            }
            catch (InterruptedException interruptedException) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD waitForInterruptsToCompleteSending() - caught InterruptedException", interruptedException);
            }
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + " interrupts were completely sent");
        }
    }

    @Override
    public void dispose() {
        if (!this.fBlockExecutionTracker.alreadySent() || !this.fSessionService.isSessionRunning()) {
            this.fBlockExecutionTracker.skip();
            this.fCleanupTracker.skip();
            this.fKeyFlushTracker.skip();
            this.notifyReleaseWorkers();
            this.fResourceManager.releaseCurrentHolder(this);
        } else if (this.fSessionService.isSessionRunning()) {
            if (!this.fBlockExecutionTracker.isComplete()) {
                this.interrupt();
            }
            this.waitForInterruptsToCompleteSending();
        }
    }

    private void handleKeyFlushReturn(ReturnMessage returnMessage, ProcessInstance processInstance) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + " dealing with key flush return " + returnMessage.getOriginalSequenceNumber() + " from " + processInstance);
        if (returnMessage instanceof FevalResult) {
            this.fKeyFlushTracker.messageReturned(processInstance, returnMessage);
        }
        if (this.fKeyFlushTracker.isComplete()) {
            this.notifyReleaseWorkers();
            this.fResourceManager.releaseCurrentHolder(this);
        }
    }

    private void handleBlockReturn(ReturnMessage returnMessage, ProcessInstance processInstance) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD " + this.fTag + " dealing with block return sequence " + returnMessage.getOriginalSequenceNumber() + " from " + processInstance);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD handleBlockReturn( " + returnMessage.getClass() + " )");
        if (returnMessage instanceof FevalResult) {
            this.fCleanupTracker.messageReturned(processInstance, returnMessage);
            if (!this.fBlockExecutionTracker.hasReturnFrom(processInstance)) {
                this.fBlockExecutionTracker.messageReturned(processInstance, SpmdBlockResult.NO_ERROR_RESULT);
            }
            if (this.fCleanupTracker.isComplete()) {
                this.notifyReleaseWorkers();
                this.fResourceManager.releaseCurrentHolder(this);
            }
        } else if (returnMessage instanceof SpmdBlockResult) {
            this.fBlockExecutionTracker.messageReturned(processInstance, returnMessage);
            if (((SpmdBlockResult)returnMessage).isError()) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "SPMD - spotted an error, interrupting");
                this.setInterruptInfo(returnMessage, processInstance);
                this.interrupt();
            } else assert (false) : "An SpmdBlockResult was returned when an error did not occur";
        } else if (returnMessage instanceof CmdWinOutput) {
            this.fDrainableOutput.addOutput(processInstance, ((CmdWinOutput)returnMessage).getStrings());
        }
    }

    private synchronized void setInterruptInfo(ReturnMessage returnMessage, ProcessInstance processInstance) {
        this.fProcessCausingInterrupt = processInstance;
        this.fMessageCausingInterrupt = returnMessage;
    }

    @Override
    public boolean awaitBlock(long l, TimeUnit timeUnit) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " block...");
        boolean bl = this.fBlockExecutionTracker.await(l, timeUnit);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " block: " + bl);
        return bl;
    }

    @Override
    public boolean awaitCleanup(long l, TimeUnit timeUnit) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " interrupt send completion if necessary");
        this.waitForInterruptsToCompleteSending();
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " cleanup...");
        boolean bl = this.fCleanupTracker.await(l, timeUnit);
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Awaiting " + this.fTag + " cleanup: " + bl);
        return bl;
    }

    public void drainIO(boolean bl) {
        String[] stringArray = bl ? this.fDrainableOutput.drainAllOutput() : this.fDrainableOutput.drainOutput();
        for (String string : stringArray) {
            if (string.isEmpty()) continue;
            System.out.println(string);
        }
    }

    public String toString() {
        return this.getClass().getName() + "[fTag = " + this.fTag + ", fNumlabs = " + this.fNumlabs + "]";
    }

    private static final class MessageTracker {
        private CountDownLatch fMessageCounter;
        private AtomicBoolean fMessagesSent;
        private Map<ProcessInstance, ReturnMessage> fResultMap;

        MessageTracker(int n) {
            this.fMessageCounter = new CountDownLatch(n);
            this.fMessagesSent = new AtomicBoolean(false);
            this.fResultMap = new ConcurrentHashMap<ProcessInstance, ReturnMessage>();
        }

        boolean alreadySent() {
            return this.fMessagesSent.get();
        }

        boolean markSent() {
            return this.fMessagesSent.getAndSet(true);
        }

        void skip() {
            this.markSent();
            while (!this.isComplete()) {
                this.fMessageCounter.countDown();
            }
        }

        void messageReturned(ProcessInstance processInstance, @Nullable ReturnMessage returnMessage) {
            if (returnMessage != null) {
                this.fResultMap.put(processInstance, returnMessage);
            }
            this.fMessageCounter.countDown();
        }

        boolean hasReturnFrom(ProcessInstance processInstance) {
            return this.fResultMap.containsKey(processInstance);
        }

        ReturnMessage getResult(ProcessInstance processInstance) {
            assert (this.isComplete()) : "Attempt to get result prior to completion";
            return this.fResultMap.get(processInstance);
        }

        boolean isComplete() {
            return this.await(0L, TimeUnit.SECONDS);
        }

        boolean await(long l, TimeUnit timeUnit) {
            boolean bl = false;
            try {
                bl = this.fMessageCounter.await(l, timeUnit);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return bl;
        }
    }
}

