/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.Session;
import com.mathworks.toolbox.distcomp.pmode.SessionCreatedEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionCreationListener;
import com.mathworks.toolbox.distcomp.pmode.SessionEvent;
import com.mathworks.toolbox.distcomp.pmode.SessionInfo;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionServicesFactory;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionStartupFailedException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SessionFactory {
    private static final Set<SessionCreationListener> SESSION_CREATION_LISTENER_SET = Collections.synchronizedSet(new HashSet());

    private SessionFactory() {
    }

    public static SessionService createClientSession(SessionServicesFactory sessionServicesFactory, List<Connection> list, Instance instance, boolean bl, SessionInfo sessionInfo) throws InterruptedException, SessionStartupFailedException {
        assert (list != null) : "Array of Connection to labs should not be null.";
        assert (!list.isEmpty()) : "Array of Connection to labs should not empty.";
        for (Connection connection : list) {
            assert (connection != null) : "Received a null Connection to one of the labs";
        }
        if (!sessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
            sessionInfo = SessionInfo.started(sessionInfo, list.size());
        }
        Session session = Session.create(sessionServicesFactory, list, instance, bl, sessionInfo);
        if (!sessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
            SessionFactory.notifySessionCreated(session, session.getClientSessionInfo());
        }
        return session;
    }

    public static SessionService createLabSession(SessionServicesFactory sessionServicesFactory, List<Connection> list, int n, Instance instance) throws InterruptedException, SessionStartupFailedException {
        assert (list != null && !list.isEmpty()) : "Lab connections to other processes should not be empty.";
        assert (n > 0) : "Labindex should be > 0.";
        return Session.create(sessionServicesFactory, list, n, instance);
    }

    public static boolean addSessionCreationListener(SessionCreationListener sessionCreationListener) {
        return SESSION_CREATION_LISTENER_SET.add(sessionCreationListener);
    }

    public static boolean removeSessionCreationListener(SessionCreationListener sessionCreationListener) {
        return SESSION_CREATION_LISTENER_SET.remove(sessionCreationListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifySessionCreated(SessionService sessionService, SessionInfo sessionInfo) {
        SessionCreatedEvent sessionCreatedEvent = new SessionCreatedEvent(sessionInfo, sessionService);
        SessionCreationListener[] sessionCreationListenerArray = SESSION_CREATION_LISTENER_SET;
        synchronized (SESSION_CREATION_LISTENER_SET) {
            SessionCreationListener[] sessionCreationListenerArray2 = SESSION_CREATION_LISTENER_SET.toArray(new SessionCreationListener[SESSION_CREATION_LISTENER_SET.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (SessionCreationListener sessionCreationListener : sessionCreationListenerArray2) {
                try {
                    sessionCreationListener.sessionCreated(sessionCreatedEvent);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionInfo notifySessionStarting(String string, String string2, long l, boolean bl, boolean bl2) {
        SessionInfo sessionInfo = SessionInfo.starting(string, string2, l, bl, bl2);
        SessionEvent sessionEvent = new SessionEvent(sessionInfo);
        SessionCreationListener[] sessionCreationListenerArray = SESSION_CREATION_LISTENER_SET;
        synchronized (SESSION_CREATION_LISTENER_SET) {
            SessionCreationListener[] sessionCreationListenerArray2 = SESSION_CREATION_LISTENER_SET.toArray(new SessionCreationListener[SESSION_CREATION_LISTENER_SET.size()]);
            // ** MonitorExit[var9_7] (shouldn't be in output)
            for (SessionCreationListener sessionCreationListener : sessionCreationListenerArray2) {
                try {
                    sessionCreationListener.sessionStarting(sessionEvent);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return sessionInfo;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SessionInfo notifySessionFailedToStart(SessionInfo sessionInfo, String string) {
        SessionInfo sessionInfo2 = SessionInfo.failedToStart(sessionInfo, string);
        SessionEvent sessionEvent = new SessionEvent(sessionInfo2);
        SessionCreationListener[] sessionCreationListenerArray = SESSION_CREATION_LISTENER_SET;
        synchronized (SESSION_CREATION_LISTENER_SET) {
            SessionCreationListener[] sessionCreationListenerArray2 = SESSION_CREATION_LISTENER_SET.toArray(new SessionCreationListener[SESSION_CREATION_LISTENER_SET.size()]);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (SessionCreationListener sessionCreationListener : sessionCreationListenerArray2) {
                try {
                    sessionCreationListener.sessionFailedToStart(sessionEvent);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return sessionInfo2;
        }
    }

    public static void notifySessionAbortedByUser(SessionInfo sessionInfo, String string) {
        if (sessionInfo.getState().equals((Object)SessionInfo.SessionState.STARTING) || sessionInfo.equals(SessionInfo.NULL_SESSION_INFO)) {
            SessionFactory.notifySessionFailedToStart(sessionInfo, string);
        }
    }
}

