/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.MatlabOutputWriters;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.concurrent.atomic.AtomicBoolean;

public class SendingWriterManager {
    private long fSequence;
    private Instance fProcess;
    private AtomicBoolean fEnabled;
    private ReturnGroup fReturnGroup;
    private BufferedWriter fBuffered;
    private InnerWriter fInnerWriter = new InnerWriter();

    public SendingWriterManager(ReturnGroup returnGroup) {
        this.fBuffered = new BufferedWriter(this.fInnerWriter);
        this.fReturnGroup = returnGroup;
        this.fEnabled = new AtomicBoolean(false);
    }

    public SendingWriterManager(ReturnGroup returnGroup, long l, Instance instance) {
        this(returnGroup);
        this.enable(l, instance);
    }

    public synchronized Writer getSendingWriter() {
        return this.fBuffered;
    }

    public synchronized void enable(long l, Instance instance) {
        try {
            this.fBuffered.flush();
            this.fInnerWriter.hardFlush();
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "SendingWriterManager.enable() encountered a problem", iOException);
        }
        this.fSequence = l;
        this.fProcess = instance;
        this.fEnabled.set(true);
    }

    public synchronized void disable() {
        try {
            this.fBuffered.flush();
            this.fInnerWriter.hardFlush();
        }
        catch (IOException iOException) {
            PackageInfo.LOGGER.log(DistcompLevel.ONE, "SendingWriterManager.disable() encountered a problem", iOException);
        }
        this.fSequence = -1L;
        this.fProcess = null;
        this.fEnabled.set(false);
    }

    private void sendCommandOutput(String string) {
        if (this.fEnabled.get()) {
            assert (this.fProcess != null) : "Need process to return output to";
            MatlabOutputWriters.returnCommandOutput(string, this.fReturnGroup, this.fSequence, this.fProcess);
        }
    }

    private class InnerWriter
    extends StringWriter {
        private long fLastSendTime = System.currentTimeMillis();
        private static final long SEND_INTERVAL_MILLIS = 1000L;
        private static final int SEND_THRESHOLD_CHARS = 16384;

        private InnerWriter() {
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
            super.write(cArray, n, n2);
            this.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            Object object = this.lock;
            synchronized (object) {
                if (System.currentTimeMillis() > this.fLastSendTime + 1000L || this.getBuffer().length() > 16384) {
                    this.hardFlush();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void hardFlush() {
            Object object = this.lock;
            synchronized (object) {
                StringBuffer stringBuffer = this.getBuffer();
                if (stringBuffer.length() > 0) {
                    SendingWriterManager.this.sendCommandOutput(stringBuffer.toString());
                    stringBuffer.setLength(0);
                    this.fLastSendTime = System.currentTimeMillis();
                }
            }
        }

        @Override
        public void close() throws IOException {
            this.hardFlush();
            super.close();
        }
    }
}

