/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.DrainableOutput;
import com.mathworks.toolbox.distcomp.pmode.DrainableOutputImpl;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.LabsCompletionObserver;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class RunOnAllCompletionObserver
implements LabsCompletionObserver {
    private CountDownLatch fNumLabsFinished = null;
    private final CountDownLatch fGotNumLabs = new CountDownLatch(1);
    private final boolean fUseDrainableOutput;
    private DrainableOutput fDrainableOutput;

    public RunOnAllCompletionObserver(boolean bl) {
        this.fUseDrainableOutput = bl;
    }

    public boolean waitForCompletion(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.fGotNumLabs.await(l, timeUnit) && this.fNumLabsFinished.await(l, timeUnit);
    }

    @Override
    public void handleLabList(List<ProcessInstance> list) {
        this.fNumLabsFinished = new CountDownLatch(list.size());
        this.fDrainableOutput = this.fUseDrainableOutput ? new DrainableOutputImpl(list, false) : null;
        this.fGotNumLabs.countDown();
    }

    @Override
    public void handleOutput(String string, ProcessInstance processInstance) {
        if (this.fUseDrainableOutput) {
            String[] stringArray = new String[]{string};
            this.fDrainableOutput.addOutput(processInstance, stringArray);
        } else {
            System.out.print(string);
        }
    }

    @Override
    public void handleExecStatus(int n, ProcessInstance processInstance) {
        this.fNumLabsFinished.countDown();
    }

    public DrainableOutput getDrainableOutput() {
        return this.fDrainableOutput;
    }

    @Override
    public void handleLabAborted(ProcessInstance processInstance) {
        this.fNumLabsFinished.countDown();
    }
}

