/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.CommunicationObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.FinalReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessageRegistry;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.LimitedQueueExecutor;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;

public class ReturnMessageDispatcherImpl
implements Dispatcher<ReturnMessage>,
ObservableMessageRegistry,
CommunicationObserver {
    private ExecutorService fDispatchExec;
    private ErrorHandler fErrorHandler;
    private final ConcurrentHashMap<Pair<Long, Instance>, List<MessageObserver>> fMessageObserverMap = new ConcurrentHashMap();
    private final Object fNewMessageObserverListLock = new Object();
    private List<MessageObserver> fNewMessageObserverList = Collections.synchronizedList(new LinkedList());

    public static ReturnMessageDispatcherImpl create(ExecutorService executorService, ErrorHandler errorHandler) {
        return new ReturnMessageDispatcherImpl(executorService, errorHandler);
    }

    protected ReturnMessageDispatcherImpl(ExecutorService executorService, ErrorHandler errorHandler) {
        this.fDispatchExec = new LimitedQueueExecutor(executorService, 50);
        this.fErrorHandler = errorHandler;
    }

    @Override
    public void dispatch(final ReturnMessage returnMessage, final Instance instance) {
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Received a ReturnMessage with ID:" + returnMessage.getOriginalSequenceNumber() + " from src:" + instance);
        Pair pair = new Pair((Object)returnMessage.getOriginalSequenceNumber(), (Object)instance);
        final List<MessageObserver> list = returnMessage instanceof FinalReturnMessage ? this.fMessageObserverMap.remove(pair) : this.fMessageObserverMap.get(pair);
        if (list == null) {
            PackageInfo.LOGGER.log(DistcompLevel.SIX, "No observers for message with ID:" + returnMessage.getOriginalSequenceNumber() + " from src:" + instance);
            return;
        }
        try {
            this.fDispatchExec.execute(new Runnable(){

                @Override
                public void run() {
                    for (MessageObserver messageObserver : list) {
                        try {
                            if (messageObserver == null) continue;
                            PackageInfo.LOGGER.log(DistcompLevel.SIX, "Message " + returnMessage.getClass().getSimpleName() + " " + returnMessage.getOriginalSequenceNumber() + " dispatched to " + messageObserver);
                            messageObserver.completed(returnMessage, instance);
                        }
                        catch (Throwable throwable) {
                            PackageInfo.LOGGER.log(DistcompLevel.ONE, "ReturnMessageObserver threw a Throwable.", throwable);
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.fErrorHandler.executorError(rejectedExecutionException);
        }
    }

    @Override
    public void addReturnMessageObserver(ObservableMessage observableMessage, Collection<Instance> collection, MessageObserver messageObserver) {
        for (Instance instance : collection) {
            this.addOneReturnMessageObserver(observableMessage, instance, messageObserver);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOneReturnMessageObserver(ObservableMessage observableMessage, Instance instance, MessageObserver messageObserver) {
        List<MessageObserver> list;
        Pair pair = new Pair((Object)observableMessage.getSequenceNumber(), (Object)instance);
        Object object = this.fNewMessageObserverListLock;
        synchronized (object) {
            list = this.fMessageObserverMap.putIfAbsent((Pair<Long, Instance>)pair, this.fNewMessageObserverList);
            if (list == null) {
                list = this.fNewMessageObserverList;
                this.fNewMessageObserverList = Collections.synchronizedList(new LinkedList());
            }
        }
        list.add(messageObserver);
        PackageInfo.LOGGER.log(DistcompLevel.SIX, "Size of MessageObserverMap = " + this.fMessageObserverMap.size());
    }

    @Override
    public Dispatcher<ReturnMessage> getDispatcher() {
        return this;
    }

    @Override
    public void destroy() {
        this.fMessageObserverMap.clear();
    }

    @Override
    public void communicationLost(final Instance instance, Throwable throwable) {
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "ReturnMessageDispatcherImpl.communicationLost(" + instance + ", ...)", throwable);
        Set set = this.fMessageObserverMap.keySet();
        final LinkedList<Pair> linkedList = new LinkedList<Pair>();
        for (Pair pair : set) {
            if (!((Instance)pair.getSecond()).equals(instance)) continue;
            List<MessageObserver> list = this.fMessageObserverMap.get(pair);
            linkedList.add(new Pair(list, pair.getFirst()));
            this.fMessageObserverMap.remove(pair);
        }
        try {
            this.fDispatchExec.execute(new Runnable(){

                @Override
                public void run() {
                    for (Pair pair : linkedList) {
                        long l = (Long)pair.getSecond();
                        for (MessageObserver messageObserver : (List)pair.getFirst()) {
                            try {
                                messageObserver.aborted(l, instance);
                            }
                            catch (Throwable throwable) {
                                PackageInfo.LOGGER.log(DistcompLevel.ONE, "ReturnMessageObserver threw a Throwable.", throwable);
                            }
                        }
                    }
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            this.fErrorHandler.executorError(rejectedExecutionException);
        }
    }

    @Override
    public void communicationEstablished(Instance instance) {
    }
}

