/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.Matlab;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.poolmessaging.ProcessInstance;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class RawMatlabStatusTracker {
    private static final Integer[] sEXEC_STATES_NO_CTRLC = new Integer[]{0, 2};
    private static final Integer[] sEXEC_STATES_W_CTRLC = new Integer[]{0, 2, 4, 3};
    private static final Integer[] sCOMPLETE_PROMPT_STATE_W_CTRLC = new Integer[]{Matlab.BASE_PROMPT, Matlab.NO_PROMPT};
    private Map<ProcessInstance, Integer> fRawStatus = new HashMap<ProcessInstance, Integer>();
    private boolean fCurrentPossiblyInterrupted;
    private boolean fPreviousPossiblyInterrupted;

    public RawMatlabStatusTracker(List<ProcessInstance> list) {
        for (ProcessInstance processInstance : list) {
            this.fRawStatus.put(processInstance, 0);
        }
        this.fCurrentPossiblyInterrupted = false;
        this.fPreviousPossiblyInterrupted = false;
    }

    public void prepareForNewCommand() {
        for (ProcessInstance processInstance : this.fRawStatus.keySet()) {
            this.fRawStatus.put(processInstance, 0);
        }
        this.fPreviousPossiblyInterrupted = this.fCurrentPossiblyInterrupted;
        this.fCurrentPossiblyInterrupted = false;
    }

    public void setStatus(int n, ProcessInstance processInstance) {
        Integer n2 = this.fRawStatus.put(processInstance, n);
        assert (n2 != null);
    }

    public void setPossiblyInterrupted() {
        this.fCurrentPossiblyInterrupted = true;
    }

    public boolean isOK() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        boolean bl = this.fCurrentPossiblyInterrupted || this.fPreviousPossiblyInterrupted;
        String string = "Ctrl-C " + (bl ? "is" : " is not ") + " accepted.";
        hashSet.clear();
        for (Integer n : this.fRawStatus.values()) {
            hashSet.add(Matlab.getInputRequester((int)n));
        }
        boolean bl2 = bl ? RawMatlabStatusTracker.areStatusesInSet(hashSet, sCOMPLETE_PROMPT_STATE_W_CTRLC) : RawMatlabStatusTracker.areAllStatusesEqualTo(hashSet, Matlab.BASE_PROMPT);
        boolean bl3 = RawMatlabStatusTracker.areAllStatusesEqualTo(hashSet, Matlab.INCOMPLETE_BLOCK_PROMPT);
        if (!bl2 && !bl3) {
            String string2 = "Returning false in command consistency checking due to prompt status. " + string;
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, string2);
            return false;
        }
        hashSet.clear();
        for (Integer n : this.fRawStatus.values()) {
            hashSet.add(Matlab.getCodeBlockStatus((int)n));
        }
        boolean bl4 = RawMatlabStatusTracker.areAllStatusesEqualTo(hashSet, 0);
        boolean bl5 = RawMatlabStatusTracker.areAllStatusesEqualTo(hashSet, 1);
        boolean bl6 = RawMatlabStatusTracker.areAllStatusesEqualTo(hashSet, 2);
        if (!(bl4 || bl5 || bl6)) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Returning false in command consistency checking due to block status.");
            return false;
        }
        if (bl3 != bl5) {
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Returning false in command consistency checking due to the combination of prompt and block status.");
            return false;
        }
        hashSet.clear();
        for (Integer n : this.fRawStatus.values()) {
            hashSet.add(Matlab.getExecutionStatus((int)n));
        }
        Integer[] integerArray = bl ? sEXEC_STATES_W_CTRLC : sEXEC_STATES_NO_CTRLC;
        boolean bl7 = RawMatlabStatusTracker.areStatusesInSet(hashSet, integerArray);
        boolean bl8 = RawMatlabStatusTracker.areAllStatusesEqualTo(hashSet, 1);
        if (!bl8 && !bl7) {
            String string3 = "Returning false in command consistency checking due to command execution status.  " + string;
            PackageInfo.LOGGER.log(DistcompLevel.ZERO, string3);
            return false;
        }
        return true;
    }

    public String toString() {
        String string = "Execution statuses: ";
        for (Integer n : this.fRawStatus.values()) {
            string = string + "  " + Matlab.getExecutionStatus((int)n);
        }
        string = string + "\nCode block statuses: ";
        for (Integer n : this.fRawStatus.values()) {
            string = string + "  " + Matlab.getCodeBlockStatus((int)n);
        }
        string = string + "\nPrompts: ";
        for (Integer n : this.fRawStatus.values()) {
            string = string + "  " + Matlab.getInputRequester((int)n);
        }
        string = string + "\nCurrent possibly interrupted: " + this.fCurrentPossiblyInterrupted + "\nPrevious possibly interrupted: " + this.fPreviousPossiblyInterrupted;
        return string;
    }

    private static boolean areStatusesInSet(Set<Integer> set, Integer[] integerArray) {
        HashSet<Integer> hashSet = new HashSet<Integer>(Arrays.asList(integerArray));
        return hashSet.containsAll(set);
    }

    private static boolean areAllStatusesEqualTo(Set<Integer> set, int n) {
        return Collections.frequency(set, n) == set.size();
    }

    public void communicationLost(ProcessInstance processInstance) {
        this.fRawStatus.remove(processInstance);
    }

    public void communicationEstablished(ProcessInstance processInstance) {
        this.fRawStatus.put(processInstance, 0);
    }
}

