/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.mvm.MVM;
import com.mathworks.mvm.exec.FutureResult;
import com.mathworks.mvm.exec.MatlabFevalRequest;
import com.mathworks.mvm.exec.MatlabRequest;
import com.mathworks.toolbox.distcomp.pmode.FevalResult;
import com.mathworks.toolbox.distcomp.pmode.FevalSmallDataResult;
import com.mathworks.toolbox.distcomp.pmode.MDispatchableCommand;
import com.mathworks.toolbox.distcomp.pmode.SendingWriterManager;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.util.FutureWaiter;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import org.jetbrains.annotations.Nullable;

public class MFevalCommand
extends MDispatchableCommand {
    private final String fFunction;
    private final Object[] fInputArguments;
    private final int fNlhs;
    private final ConsoleOutput fConsoleOutput;

    public MFevalCommand(String string, @Nullable Object[] objectArray, int n) {
        this(string, objectArray, n, ConsoleOutput.Discard);
    }

    public MFevalCommand(String string, @Nullable Object[] objectArray, int n, ConsoleOutput consoleOutput) {
        this.fFunction = string;
        this.fInputArguments = objectArray != null ? Arrays.copyOf(objectArray, objectArray.length) : null;
        this.fNlhs = n;
        this.fConsoleOutput = consoleOutput;
    }

    @Override
    public void dispatch(final ReturnGroup returnGroup, Instance instance, SessionService sessionService) {
        final Writer writer = this.fConsoleOutput == ConsoleOutput.Return ? new SendingWriterManager(returnGroup, this.getSequenceNumber(), instance).getSendingWriter() : MatlabRequest.NULL_WRITER;
        MVM mVM = MatlabRefStore.getMVMRef();
        FutureWaiter.OnFutureCompletion onFutureCompletion = new FutureWaiter.OnFutureCompletion(){

            @Override
            public void run(Object object, Exception exception) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                FevalResult fevalResult = MFevalCommand.this.buildResult(exception, object, MFevalCommand.this.fNlhs, MFevalCommand.this.getSequenceNumber());
                returnGroup.returnTo(MFevalCommand.this.getSourceProcess(), (ReturnMessage)fevalResult);
                fevalResult.dispose();
            }
        };
        sessionService.getFutureWaiter().waitAndTrigger((FutureResult)mVM.getExecutor().submit(new MatlabFevalRequest(this.fFunction, Integer.valueOf(this.fNlhs), writer, writer, this.getInputArguments())), onFutureCompletion);
    }

    protected FevalResult buildResult(Exception exception, Object object, int n, long l) {
        return new FevalSmallDataResult(exception, object, n, l);
    }

    protected Object[] getInputArguments() {
        return this.fInputArguments;
    }

    public static enum ConsoleOutput {
        Return,
        Discard;

    }
}

