/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.lang.matlabpool;
import com.mathworks.toolbox.distcomp.pmode.ClosableSessionConnections;
import com.mathworks.toolbox.distcomp.pmode.InitiateLabShutdown;
import com.mathworks.toolbox.distcomp.pmode.LabFinishSessionWithMonitoring;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.PrepareForLabShutdown;
import com.mathworks.toolbox.distcomp.pmode.SessionConstants;
import com.mathworks.toolbox.distcomp.pmode.ShutdownACKFromLab;
import com.mathworks.toolbox.distcomp.pmode.shared.Dispatcher;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionShutdownEvent;
import com.mathworks.toolbox.distcomp.pmode.shared.Shutdown;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabIdentifiedMessage;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;

public class LabShutdownHandlerImpl
implements ShutdownHandler,
Dispatcher<Shutdown> {
    private final ReturnGroup fReturnGroup;
    private final ErrorHandler fErrorHandler;
    private final AtomicBoolean fHasShutdownSequenceStarted = new AtomicBoolean(false);
    private final ClosableSessionConnections fClosableConnections;
    private final CountDownLatch fRemoteStartupComplete;

    static LabShutdownHandlerImpl create(ErrorHandler errorHandler, ReturnGroup returnGroup, ClosableSessionConnections closableSessionConnections) {
        LabShutdownHandlerImpl labShutdownHandlerImpl = new LabShutdownHandlerImpl(errorHandler, returnGroup, closableSessionConnections);
        labShutdownHandlerImpl.init();
        return labShutdownHandlerImpl;
    }

    private LabShutdownHandlerImpl(ErrorHandler errorHandler, ReturnGroup returnGroup, ClosableSessionConnections closableSessionConnections) {
        this.fReturnGroup = returnGroup;
        this.fClosableConnections = closableSessionConnections;
        this.fErrorHandler = errorHandler;
        this.fRemoteStartupComplete = new CountDownLatch(1);
    }

    @Override
    public void sessionStartupComplete() {
        this.fRemoteStartupComplete.countDown();
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Cancelled shutdown.");
    }

    private void init() {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Starting the startup checker thread.");
        ExecutorService executorService = Executors.newSingleThreadExecutor((ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)this.getClass().getSimpleName(), (Logger)PackageInfo.LOGGER));
        executorService.submit(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                boolean bl2 = false;
                try {
                    bl = LabShutdownHandlerImpl.this.fRemoteStartupComplete.await(SessionConstants.sLAB_CONNECT_TIMEOUT, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException interruptedException) {
                    bl2 = true;
                }
                if (!bl) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Startup failed ... shutting down.");
                    LabShutdownError labShutdownError = new LabShutdownError();
                    LabShutdownHandlerImpl.this.forceShutdown(labShutdownError);
                } else {
                    PackageInfo.LOGGER.log(DistcompLevel.THREE, "Startup was successful.");
                }
                if (bl2) {
                    Thread.interrupted();
                }
            }
        });
        executorService.shutdown();
    }

    @Override
    public boolean normalShutdown() {
        assert (false) : "ShutdownHandlerImpl.normalShutdown called on a lab.";
        return false;
    }

    @Override
    public void forceShutdown(HasI18nMatlabIdentifiedMessage hasI18nMatlabIdentifiedMessage) {
        if (this.fHasShutdownSequenceStarted.getAndSet(true)) {
            return;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Initiating a forced shutdown.");
        this.fErrorHandler.deactivate();
        this.labShutdown(new SessionShutdownEvent(this, SessionShutdownEvent.ShutdownState.ERROR, hasI18nMatlabIdentifiedMessage));
    }

    @Override
    public void dispatch(Shutdown shutdown, Instance instance) {
        this.fErrorHandler.deactivate();
        this.fReturnGroup.returnTo(instance, (ReturnMessage)new ShutdownACKFromLab(shutdown.getSequenceNumber()));
        if (shutdown instanceof InitiateLabShutdown) {
            PackageInfo.LOGGER.info("Received InitiateLabShutdown.");
            if (this.fHasShutdownSequenceStarted.getAndSet(true)) {
                return;
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                PackageInfo.LOGGER.info("Interrupted while sleeping to give client a chance to receive ACK.");
            }
            this.labShutdown(new SessionShutdownEvent(this, SessionShutdownEvent.ShutdownState.NORMAL));
        } else if (shutdown instanceof PrepareForLabShutdown) {
            PackageInfo.LOGGER.info("Received PrepareForLabShutdown.");
        } else assert (false) : "Received an unexpected class " + shutdown.getClass().getName();
    }

    @Override
    public boolean hasShutdownBegun() {
        return this.fHasShutdownSequenceStarted.get();
    }

    private void labShutdown(SessionShutdownEvent sessionShutdownEvent) {
        this.fRemoteStartupComplete.countDown();
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Closing IO and stopping executors.");
        try {
            this.fClosableConnections.run(sessionShutdownEvent);
        }
        catch (RuntimeException runtimeException) {
            assert (false) : "Caught when calling Runnable to close IO and stop executors." + runtimeException.getClass().getName();
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Caught when calling Runnable to close IO and stop executors.", runtimeException);
        }
        LabFinishSessionWithMonitoring.create();
    }

    boolean sessionStartupIsComplete() throws InterruptedException {
        return this.fRemoteStartupComplete.await(0L, TimeUnit.NANOSECONDS);
    }

    private static final class LabShutdownError
    implements HasI18nMatlabIdentifiedMessage,
    Serializable {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();
        private final BaseMsgID fMessageID = new matlabpool.StartupFailed();

        LabShutdownError() {
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.fMessageID);
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.fMessageID);
        }

        public String getMessageID() {
            return this.fMessageID.getCatalogId() + ":" + this.fMessageID.getMessageId();
        }
    }
}

