/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.pmode;

import com.mathworks.jmi.MatlabException;
import com.mathworks.jmi.MatlabWorker;
import com.mathworks.toolbox.distcomp.pmode.ClosableSessionConnections;
import com.mathworks.toolbox.distcomp.pmode.InitiateLabShutdown;
import com.mathworks.toolbox.distcomp.pmode.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.PrepareForLabShutdown;
import com.mathworks.toolbox.distcomp.pmode.SessionService;
import com.mathworks.toolbox.distcomp.pmode.shared.ErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.shared.Instance;
import com.mathworks.toolbox.distcomp.pmode.shared.LabsResponseVector;
import com.mathworks.toolbox.distcomp.pmode.shared.MessageObserver;
import com.mathworks.toolbox.distcomp.pmode.shared.ObservableMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.OutputGroup;
import com.mathworks.toolbox.distcomp.pmode.shared.ReturnMessage;
import com.mathworks.toolbox.distcomp.pmode.shared.SessionShutdownEvent;
import com.mathworks.toolbox.distcomp.pmode.shared.Shutdown;
import com.mathworks.toolbox.distcomp.pmode.shared.ShutdownHandler;
import com.mathworks.toolbox.distcomp.util.MatlabRefStore;
import com.mathworks.toolbox.distcomp.util.i18n.HasI18nMatlabIdentifiedMessage;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class ClientShutdownHandlerImpl
implements ShutdownHandler {
    private final OutputGroup fOutGroup;
    private final ErrorHandler fErrorHandler;
    private volatile LabsResponseVector<Instance> fShutdownACKFromLabFromLabs;
    private final AtomicBoolean fHasShutdown = new AtomicBoolean(false);
    private final ClosableSessionConnections fClosableConnections;
    private final List<Instance> fPreciousInstances;

    ClientShutdownHandlerImpl(SessionService sessionService, OutputGroup outputGroup, ClosableSessionConnections closableSessionConnections, List<Instance> list) {
        this.fOutGroup = outputGroup;
        this.fClosableConnections = closableSessionConnections;
        this.fErrorHandler = sessionService.getErrorHandler();
        this.fPreciousInstances = Collections.unmodifiableList(new ArrayList<Instance>(list));
        PackageInfo.LOGGER.info("ClientShutdownHandlerImpl() precious instances: " + this.fPreciousInstances);
        this.fShutdownACKFromLabFromLabs = null;
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Sending shutdown cancellation message.");
    }

    @Override
    public boolean normalShutdown() {
        if (this.fHasShutdown.getAndSet(true)) {
            LabsResponseVector<Instance> labsResponseVector = this.fShutdownACKFromLabFromLabs;
            return labsResponseVector == null || labsResponseVector.hasAllResponses();
        }
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Initiating a shutdown.");
        this.fErrorHandler.deactivate();
        this.tellLabsToShutdown();
        this.shutdownClient(new SessionShutdownEvent(this, SessionShutdownEvent.ShutdownState.NORMAL));
        this.cleanupStateInMatlabNoError();
        return this.fShutdownACKFromLabFromLabs.hasAllResponses();
    }

    @Override
    public void forceShutdown(HasI18nMatlabIdentifiedMessage hasI18nMatlabIdentifiedMessage) {
        if (this.fHasShutdown.getAndSet(true)) {
            return;
        }
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Initiating a forced shutdown.");
        this.fErrorHandler.deactivate();
        this.shutdownClient(new SessionShutdownEvent(this, SessionShutdownEvent.ShutdownState.ERROR, hasI18nMatlabIdentifiedMessage));
        this.cleanupStateInMatlabAndError(hasI18nMatlabIdentifiedMessage);
    }

    @Override
    public boolean hasShutdownBegun() {
        return this.fHasShutdown.get();
    }

    @Override
    public void sessionStartupComplete() {
    }

    private void shutdownClient(SessionShutdownEvent sessionShutdownEvent) {
        if (this.fShutdownACKFromLabFromLabs != null) {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "ClientShutdownHandlerImpl: did we receive ACK from all labs: " + this.fShutdownACKFromLabFromLabs.hasAllResponses());
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.THREE, "ClientShutdownHandlerImpl: didn't ask labs to shut down");
        }
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Closing IO and stopping executors.");
        try {
            this.fClosableConnections.run(sessionShutdownEvent);
        }
        catch (RuntimeException runtimeException) {
            assert (false) : "Caught when calling Runnable to close IO and stop executors." + runtimeException.getClass().getName();
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Caught a RuntimeException when calling Runnable to close IO and stop executors.", runtimeException);
        }
    }

    private void tellLabsToShutdown() {
        PackageInfo.LOGGER.log(DistcompLevel.THREE, "Sending shutdown to all labs.");
        List<Instance> list = this.fOutGroup.getConnectedInstances();
        ArrayList<Instance> arrayList = new ArrayList<Instance>(list);
        arrayList.removeAll(this.fPreciousInstances);
        ArrayList<Instance> arrayList2 = new ArrayList<Instance>(list);
        arrayList2.removeAll(arrayList);
        PackageInfo.LOGGER.info("tellLabsToShutdown() telling labs to prepare for shutdown " + arrayList2);
        LabsResponseVector<Instance> labsResponseVector = null;
        if (!arrayList.isEmpty() && !arrayList2.isEmpty()) {
            labsResponseVector = this.sendAndWaitForResponses(arrayList2, new PrepareForLabShutdown());
        }
        PackageInfo.LOGGER.info("tellLabsToShutdown() shutting down first round: " + arrayList);
        if (!arrayList.isEmpty()) {
            labsResponseVector = this.sendAndWaitForResponses(arrayList, new InitiateLabShutdown());
        }
        PackageInfo.LOGGER.info("tellLabsToShutdown() shutting down second round: " + arrayList2);
        if (!arrayList2.isEmpty()) {
            labsResponseVector = this.sendAndWaitForResponses(arrayList2, new InitiateLabShutdown());
        }
        this.fShutdownACKFromLabFromLabs = labsResponseVector;
    }

    private LabsResponseVector<Instance> sendAndWaitForResponses(final List<Instance> list, Shutdown shutdown) {
        final LabsResponseVector<Instance> labsResponseVector = new LabsResponseVector<Instance>(list);
        this.fOutGroup.sendTo(list, (ObservableMessage)shutdown, new MessageObserver(){

            @Override
            public void completed(ReturnMessage returnMessage, Instance instance) {
                labsResponseVector.receivedResponse(instance);
            }

            @Override
            public void aborted(long l, Instance instance) {
                labsResponseVector.receivedResponse(instance);
            }

            @Override
            public void expectReturnsFrom(long l, List<Instance> list2) {
                HashSet hashSet = new HashSet(list);
                hashSet.removeAll(list2);
                for (Instance instance : hashSet) {
                    labsResponseVector.receivedResponse(instance);
                }
            }
        });
        labsResponseVector.waitTillHasAllResponses(60000L);
        return labsResponseVector;
    }

    private void cleanupStateInMatlabAndError(final HasI18nMatlabIdentifiedMessage hasI18nMatlabIdentifiedMessage) {
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(MatlabRefStore.getMatlabRef()){

            public Object runOnMatlabThread() throws Exception {
                try {
                    2.eval((String)"parallel.internal.pool.exitLeaveGuiOpen();");
                }
                catch (MatlabException matlabException) {
                    // empty catch block
                }
                try {
                    int n = 0;
                    boolean bl = true;
                    2.feval((String)"error", (Object[])new Object[]{hasI18nMatlabIdentifiedMessage.getMessageID(), "%s", hasI18nMatlabIdentifiedMessage.getLocalizedMessage()}, (int)n, (boolean)bl);
                }
                catch (MatlabException matlabException) {
                    // empty catch block
                }
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        };
        matlabWorker.start();
    }

    private void cleanupStateInMatlabNoError() {
        MatlabWorker<Object> matlabWorker = new MatlabWorker<Object>(MatlabRefStore.getMatlabRef()){

            public Object runOnMatlabThread() throws Exception {
                try {
                    3.eval((String)"parallel.internal.pool.PoolArrayManager.cleanupStalePools();");
                }
                catch (MatlabException matlabException) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Error thrown when cleaning up stale pools", matlabException);
                }
                return null;
            }

            public void runOnAWTEventDispatchThread(Object object) {
            }
        };
        matlabWorker.start();
    }
}

