/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.parallelui;

import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.toolbox.distcomp.parallelui.CommandHistoryTable;
import com.mathworks.toolbox.distcomp.parallelui.IntSet;
import com.mathworks.toolbox.distcomp.parallelui.IntSetPopup;
import com.mathworks.toolbox.distcomp.parallelui.ParallelUI;
import com.mathworks.toolbox.distcomp.parallelui.Prompt;
import com.mathworks.toolbox.distcomp.parallelui.Utilities;
import com.mathworks.toolbox.distcomp.pmode.Labs;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class PromptPanel
extends MJPanel {
    private final Labs fLabs;
    private final Prompt fPrompt;
    private boolean fAlignWithHistory;
    private final CommandHistoryTable fHistoryTable;
    private JLabel fArrowLabel;
    private final JLabel fPromptLabel;
    private final String fLongestPrompt;

    PromptPanel(Labs labs, Prompt prompt, CommandHistoryTable commandHistoryTable) {
        this.fLabs = labs;
        this.fPrompt = prompt;
        this.fHistoryTable = commandHistoryTable;
        this.fLongestPrompt = Prompt.getLongestString(labs.getNumLabs());
        this.setLayout(null);
        if (labs.getNumLabs() > 1) {
            Icon icon = this.isPromptSelectable() ? Utilities.DOWN_ARROW_ICON : new ImageIcon(PromptPanel.class.getResource("resources/downarrowplaceholder.gif"));
            this.fArrowLabel = new MJLabel(icon);
            this.fArrowLabel.setHorizontalAlignment(0);
            this.fArrowLabel.setVerticalAlignment(0);
            this.fArrowLabel.setOpaque(false);
            this.add(this.fArrowLabel);
        }
        this.fPromptLabel = new MJLabel(prompt.toString());
        this.fPromptLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 4));
        this.fPromptLabel.setHorizontalAlignment(4);
        this.fPromptLabel.setOpaque(false);
        this.add(this.fPromptLabel);
        this.updateTip();
        if (this.fArrowLabel != null && this.isPromptSelectable()) {
            this.fArrowLabel.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    final IntSetPopup intSetPopup = new IntSetPopup(1, PromptPanel.this.fLabs.getNumLabs(), ParallelUI.sRes.getString("label.ThisLab"), ParallelUI.sRes.getString("title.SelectTargetLabs"));
                    intSetPopup.setValue(PromptPanel.this.fPrompt.getTargetLabs());
                    intSetPopup.show(PromptPanel.this.fArrowLabel, 0, PromptPanel.this.fArrowLabel.getHeight(), new ChangeListener(){

                        @Override
                        public void stateChanged(ChangeEvent changeEvent) {
                            PromptPanel.this.fPrompt.setTargetLabs(intSetPopup.getValue());
                            PromptPanel.this.updateTip();
                        }
                    });
                }
            });
        }
        this.fPrompt.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                PromptPanel.this.fPromptLabel.setText(PromptPanel.this.fPrompt.toString());
                PromptPanel.this.updateTip();
            }
        });
    }

    void setAlignWithHistory(boolean bl) {
        if (bl != this.fAlignWithHistory) {
            this.fAlignWithHistory = bl;
            this.revalidate();
            this.repaint();
        }
    }

    public void setForeground(Color color) {
        if (this.fPromptLabel != null) {
            this.fPromptLabel.setForeground(color);
        }
    }

    public void setFont(Font font) {
        if (this.fPromptLabel != null) {
            this.fPromptLabel.setFont(font);
        }
    }

    public Dimension getPreferredSize() {
        int n = this.fPromptLabel.getPreferredSize().height;
        int n2 = 0;
        if (this.fAlignWithHistory) {
            n2 = this.fHistoryTable.getRepeatColumnWidth() + this.fHistoryTable.getPromptColumnWidth();
        } else {
            n2 = this.getLongestPromptWidth();
            if (this.isPromptSelectable() && this.fArrowLabel != null) {
                n2 += this.fArrowLabel.getPreferredSize().width;
            }
        }
        return new Dimension(n2, n);
    }

    public void doLayout() {
        int n;
        int n2 = this.getWidth();
        int n3 = this.getHeight();
        if (this.fArrowLabel != null) {
            n = 0;
            if (this.fAlignWithHistory) {
                n = this.fHistoryTable.getRepeatColumnWidth() - 1;
            } else if (this.isPromptSelectable()) {
                n = this.fArrowLabel.getPreferredSize().width;
            }
            this.fArrowLabel.setBounds(0, 0, n, n3);
        }
        n = this.getLongestPromptWidth();
        this.fPromptLabel.setBounds(n2 - n, 0, n - 1, n3);
    }

    private boolean isPromptSelectable() {
        return false;
    }

    private int getLongestPromptWidth() {
        Graphics graphics = this.fPromptLabel.getGraphics();
        FontMetrics fontMetrics = graphics.getFontMetrics(this.fPromptLabel.getFont());
        int n = fontMetrics.stringWidth(this.fLongestPrompt) + 10;
        graphics.dispose();
        return n;
    }

    private void updateTip() {
        String string = ParallelUI.sRes.getString("tip.TargetIsThis");
        IntSet intSet = this.fPrompt.getTargetLabs();
        String string2 = Utilities.labsToString(intSet, Utilities.allLabs(this.fLabs));
        String string3 = MessageFormat.format(string, string2);
        this.fPromptLabel.setToolTipText(string3);
        if (this.fArrowLabel != null && this.isPromptSelectable()) {
            string = ParallelUI.sRes.getString("tip.SelectThisTarget");
            string3 = MessageFormat.format(string, string2);
            this.fArrowLabel.setToolTipText(string3);
        }
    }
}

