/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.cwo;

import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.cwo.Log;
import com.mathworks.toolbox.distcomp.mjs.cwo.NotifyingWritablePipedStream;
import com.mathworks.toolbox.distcomp.mjs.cwo.ReadablePipedStream;
import com.mathworks.toolbox.distcomp.mjs.cwo.TaskCWOStreamIdentifier;
import com.mathworks.toolbox.distcomp.workunit.TaskAccessLocal;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;

public class CWOStreamingWriter
extends OutputStreamWriter {
    private TaskCWOStreamIdentifier fTaskCWOStreamId;
    private TaskAccessLocal fTaskAccess;

    private CWOStreamingWriter(TaskCWOStreamIdentifier taskCWOStreamIdentifier, TaskAccessLocal taskAccessLocal, OutputStream outputStream) throws IOException, MJSException {
        super(outputStream, Charset.forName("UTF-16LE"));
        this.fTaskCWOStreamId = taskCWOStreamIdentifier;
        this.fTaskAccess = taskAccessLocal;
    }

    public static synchronized Writer create(Uuid uuid, TaskAccessLocal taskAccessLocal, int n) throws MJSException, IOException {
        TaskCWOStreamIdentifier taskCWOStreamIdentifier = new TaskCWOStreamIdentifier(uuid, UuidFactory.generate());
        NotifyingWritablePipedStream notifyingWritablePipedStream = new NotifyingWritablePipedStream(taskCWOStreamIdentifier, taskAccessLocal, n);
        ReadablePipedStream readablePipedStream = new ReadablePipedStream(notifyingWritablePipedStream);
        taskAccessLocal.addCommandWindowOutputStreamToTask(new TaskCWOStreamIdentifier[]{taskCWOStreamIdentifier}, new InputStream[]{readablePipedStream});
        return new CWOStreamingWriter(taskCWOStreamIdentifier, taskAccessLocal, notifyingWritablePipedStream);
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
    }

    @Override
    public void write(char[] cArray) throws IOException {
        super.write(cArray, 0, cArray.length);
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        super.write(cArray, n, n2);
    }

    @Override
    public void close() throws IOException {
        try {
            Log.LOGGER.log(DistcompLevel.SIX, "Removing CWO output stream from task: " + this.fTaskCWOStreamId);
            this.fTaskAccess.removeCommandWindowOutputStreamFromTask(new TaskCWOStreamIdentifier[]{this.fTaskCWOStreamId});
        }
        catch (MJSException mJSException) {
            Log.LOGGER.log(DistcompLevel.ONE, "Failed to remove output stream from task because: ", mJSException);
        }
        super.close();
    }
}

