/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.client;

import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.ByteBufferOutputStream;
import com.mathworks.toolbox.distcomp.mjs.client.LargeDataAccessor;
import com.mathworks.toolbox.distcomp.mjs.client.ReadDataException;
import com.mathworks.toolbox.distcomp.mjs.datastore.ByteBufferItem;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import java.io.IOException;
import java.io.OutputStream;

public class WorkUnitLargeDataAccessor {
    private WorkUnitLargeDataAccessor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LargeData getJobLargeData(JobImpl jobImpl, LargeDataAccessor<JobImpl> largeDataAccessor) throws MJSException {
        int n = largeDataAccessor.getDataSize(jobImpl);
        try (ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(n);){
            largeDataAccessor.getDataViaStream(jobImpl, byteBufferOutputStream, n);
            ByteBufferItem byteBufferItem = byteBufferOutputStream.getByteBufferItem();
            return byteBufferItem;
        }
        catch (MJSException | IOException exception) {
            throw new ReadDataException(exception);
        }
    }

    public static LargeDataAccessor<JobImpl> createJobScopeDataAccessor() {
        return new LargeDataAccessor<JobImpl>(){

            @Override
            public int getDataSize(JobImpl jobImpl) {
                return jobImpl.getJobScopeDataSize();
            }

            @Override
            public void getDataViaStream(JobImpl jobImpl, OutputStream outputStream, int n) throws MJSException {
                jobImpl.getJobScopeData(outputStream, n);
            }
        };
    }

    public static LargeDataAccessor<JobImpl> createAttachedFilePathDataAccessor() {
        return new LargeDataAccessor<JobImpl>(){

            @Override
            public int getDataSize(JobImpl jobImpl) {
                return jobImpl.getAttachedFilePathsSize();
            }

            @Override
            public void getDataViaStream(JobImpl jobImpl, OutputStream outputStream, int n) throws MJSException {
                jobImpl.getAttachedFilePaths(outputStream, n);
            }
        };
    }

    public static LargeDataAccessor<JobImpl> createFileDepDataAccessor() {
        return new LargeDataAccessor<JobImpl>(){

            @Override
            public int getDataSize(JobImpl jobImpl) {
                return jobImpl.getFileDepDataSize();
            }

            @Override
            public void getDataViaStream(JobImpl jobImpl, OutputStream outputStream, int n) throws MJSException {
                jobImpl.getFileDepData(outputStream, n);
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LargeData getTaskLargeData(TaskImpl taskImpl, LargeDataAccessor<TaskImpl> largeDataAccessor) throws MJSException {
        int n = largeDataAccessor.getDataSize(taskImpl);
        try (ByteBufferOutputStream byteBufferOutputStream = new ByteBufferOutputStream(n);){
            largeDataAccessor.getDataViaStream(taskImpl, byteBufferOutputStream, n);
            ByteBufferItem byteBufferItem = byteBufferOutputStream.getByteBufferItem();
            return byteBufferItem;
        }
        catch (MJSException | IOException exception) {
            throw new ReadDataException(exception);
        }
    }

    public static LargeDataAccessor<TaskImpl> createCommandWindowOutputDataAccessor() {
        return new LargeDataAccessor<TaskImpl>(){

            @Override
            public int getDataSize(TaskImpl taskImpl) {
                return taskImpl.getCommandWindowOutputSize();
            }

            @Override
            public void getDataViaStream(TaskImpl taskImpl, OutputStream outputStream, int n) throws MJSException {
                taskImpl.getCommandWindowOutput(outputStream, n);
            }
        };
    }

    public static LargeDataAccessor<TaskImpl> createInputDataAccessor() {
        return new LargeDataAccessor<TaskImpl>(){

            @Override
            public int getDataSize(TaskImpl taskImpl) {
                return taskImpl.getInputDataSize();
            }

            @Override
            public void getDataViaStream(TaskImpl taskImpl, OutputStream outputStream, int n) throws MJSException {
                taskImpl.getInputData(outputStream, n);
            }
        };
    }

    public static LargeDataAccessor<TaskImpl> createOutputDataAccessor() {
        return new LargeDataAccessor<TaskImpl>(){

            @Override
            public int getDataSize(TaskImpl taskImpl) {
                return taskImpl.getOutputDataSize();
            }

            @Override
            public void getDataViaStream(TaskImpl taskImpl, OutputStream outputStream, int n) throws MJSException {
                taskImpl.getOutputData(outputStream, n);
            }
        };
    }

    public static LargeDataAccessor<TaskImpl> createLogOutputDataAccessor() {
        return new LargeDataAccessor<TaskImpl>(){

            @Override
            public int getDataSize(TaskImpl taskImpl) {
                return taskImpl.getLogOutputSize();
            }

            @Override
            public void getDataViaStream(TaskImpl taskImpl, OutputStream outputStream, int n) throws MJSException {
                taskImpl.getLogOutput(outputStream, n);
            }
        };
    }

    public static LargeDataAccessor<TaskImpl> createMLFunctionDataAccessor() {
        return new LargeDataAccessor<TaskImpl>(){

            @Override
            public int getDataSize(TaskImpl taskImpl) {
                return taskImpl.getMLFunctionSize();
            }

            @Override
            public void getDataViaStream(TaskImpl taskImpl, OutputStream outputStream, int n) throws MJSException {
                taskImpl.getMLFunction(outputStream, n);
            }
        };
    }
}

