/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.mjs.client;

import com.mathworks.toolbox.distcomp.mjs.MJSException;
import com.mathworks.toolbox.distcomp.mjs.client.ReadOnlyClientWorkUnitAccess;
import com.mathworks.toolbox.distcomp.mjs.client.WorkUnitLargeDataAccessor;
import com.mathworks.toolbox.distcomp.mjs.datastore.LargeData;
import com.mathworks.toolbox.distcomp.storage.DatabaseStorage;
import com.mathworks.toolbox.distcomp.workunit.JobImpl;
import com.mathworks.toolbox.distcomp.workunit.JobInfo;
import com.mathworks.toolbox.distcomp.workunit.TaskImpl;
import com.mathworks.toolbox.distcomp.workunit.TaskInfo;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitImpl;
import com.mathworks.toolbox.distcomp.workunit.WorkUnitInfo;
import java.rmi.RemoteException;
import java.util.Date;
import net.jini.id.Uuid;
import org.jetbrains.annotations.NotNull;

public abstract class GDSClientWorkUnitAccess
implements ReadOnlyClientWorkUnitAccess {
    private final DatabaseStorage fDatabaseStorage;

    public GDSClientWorkUnitAccess(DatabaseStorage databaseStorage) {
        this.fDatabaseStorage = databaseStorage;
    }

    @Override
    public String[] getName(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        String[] stringArray = new String[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            WorkUnitImpl workUnitImpl = this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            stringArray[i] = workUnitImpl.getName();
        }
        return stringArray;
    }

    @Override
    public WorkUnitInfo[] getWorkUnitInfoSmallItems(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        WorkUnitInfo[] workUnitInfoArray = new WorkUnitInfo[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            WorkUnitImpl workUnitImpl = this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            workUnitInfoArray[i] = workUnitImpl.getWorkUnitInfo();
        }
        return workUnitInfoArray;
    }

    @Override
    public WorkUnitInfo[] getWorkUnitInfo(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        WorkUnitInfo[] workUnitInfoArray = new WorkUnitInfo[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            LargeData largeData;
            LargeData largeData2;
            LargeData largeData3;
            WorkUnitImpl workUnitImpl;
            WorkUnitInfo workUnitInfo;
            WorkUnitImpl workUnitImpl2 = this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            workUnitInfoArray[i] = workUnitImpl2.getWorkUnitInfo();
            if (workUnitInfoArray[i] instanceof JobInfo) {
                workUnitInfo = (JobInfo)workUnitInfoArray[i];
                workUnitImpl = (JobImpl)workUnitImpl2;
                largeData3 = WorkUnitLargeDataAccessor.getJobLargeData(workUnitImpl, WorkUnitLargeDataAccessor.createJobScopeDataAccessor());
                largeData2 = WorkUnitLargeDataAccessor.getJobLargeData(workUnitImpl, WorkUnitLargeDataAccessor.createFileDepDataAccessor());
                largeData = WorkUnitLargeDataAccessor.getJobLargeData(workUnitImpl, WorkUnitLargeDataAccessor.createAttachedFilePathDataAccessor());
                ((JobInfo)workUnitInfo).setJobScopeData(largeData3);
                ((JobInfo)workUnitInfo).setFileDepData(largeData2);
                ((JobInfo)workUnitInfo).setAttachedFilePaths(largeData);
                continue;
            }
            if (workUnitInfoArray[i] instanceof TaskInfo) {
                workUnitInfo = (TaskInfo)workUnitInfoArray[i];
                workUnitImpl = (TaskImpl)workUnitImpl2;
                largeData3 = WorkUnitLargeDataAccessor.getTaskLargeData((TaskImpl)workUnitImpl, WorkUnitLargeDataAccessor.createCommandWindowOutputDataAccessor());
                largeData2 = WorkUnitLargeDataAccessor.getTaskLargeData((TaskImpl)workUnitImpl, WorkUnitLargeDataAccessor.createInputDataAccessor());
                largeData = WorkUnitLargeDataAccessor.getTaskLargeData((TaskImpl)workUnitImpl, WorkUnitLargeDataAccessor.createOutputDataAccessor());
                LargeData largeData4 = WorkUnitLargeDataAccessor.getTaskLargeData((TaskImpl)workUnitImpl, WorkUnitLargeDataAccessor.createLogOutputDataAccessor());
                LargeData largeData5 = WorkUnitLargeDataAccessor.getTaskLargeData((TaskImpl)workUnitImpl, WorkUnitLargeDataAccessor.createMLFunctionDataAccessor());
                ((TaskInfo)workUnitInfo).setCommandWindowOutput(largeData3);
                ((TaskInfo)workUnitInfo).setInputData(largeData2);
                ((TaskInfo)workUnitInfo).setOutputData(largeData);
                ((TaskInfo)workUnitInfo).setLogOutput(largeData4);
                ((TaskInfo)workUnitInfo).setMLFunction(largeData5);
                continue;
            }
            throw new IllegalArgumentException("Can only get large data items for jobInfo or taskInfo objects");
        }
        return workUnitInfoArray;
    }

    @Override
    public long[] getTimeout(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        long[] lArray = new long[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            WorkUnitImpl workUnitImpl = this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            lArray[i] = workUnitImpl.getTimeout();
        }
        return lArray;
    }

    @Override
    public long[] getNum(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        long[] lArray = new long[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            WorkUnitImpl workUnitImpl = this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            lArray[i] = workUnitImpl.getNum();
        }
        return lArray;
    }

    @Override
    public int[] getState(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        int[] nArray = new int[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            WorkUnitImpl workUnitImpl = this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            nArray[i] = workUnitImpl.getState();
        }
        return nArray;
    }

    @Override
    public Date[] getCreateTime(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        Date[] dateArray = new Date[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            WorkUnitImpl workUnitImpl = this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            dateArray[i] = workUnitImpl.getCreateTime();
        }
        return dateArray;
    }

    @Override
    public Date[] getStartTime(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        Date[] dateArray = new Date[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            WorkUnitImpl workUnitImpl = this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            dateArray[i] = workUnitImpl.getStartTime();
        }
        return dateArray;
    }

    @Override
    public Date[] getFinishTime(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        Date[] dateArray = new Date[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            WorkUnitImpl workUnitImpl = this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            dateArray[i] = workUnitImpl.getFinishTime();
        }
        return dateArray;
    }

    @Override
    public long[] getRunningDuration(@NotNull Uuid[] uuidArray) throws RemoteException, MJSException {
        long[] lArray = new long[uuidArray.length];
        for (int i = 0; i < uuidArray.length; ++i) {
            WorkUnitImpl workUnitImpl = this.fDatabaseStorage.readWorkUnit(uuidArray[i]);
            lArray[i] = workUnitImpl.getRunningDuration();
        }
        return lArray;
    }
}

