/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.AbstractConcurrentJobCommand;
import com.mathworks.toolbox.distcomp.local.PackageInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class ConcurrentJobCommand
extends AbstractConcurrentJobCommand {
    public static ConcurrentJobCommand getNewInstance(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, int[] nArray) throws IOException {
        if (nArray == null || nArray.length != 2) {
            throw new IllegalStateException("Invalid number of workers argument supplied");
        }
        ConcurrentJobCommand concurrentJobCommand = new ConcurrentJobCommand(stringArray, stringArray2, stringArray3, string, nArray[0], nArray[1]);
        ConcurrentJobCommand.addCommandToScheduler(concurrentJobCommand);
        return concurrentJobCommand;
    }

    private ConcurrentJobCommand(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, int n, int n2) throws IOException {
        super(stringArray, stringArray2, stringArray3, string, n, n2);
    }

    @Override
    protected void waitUntilJobShouldTerminate(Vector<Future<Integer>> vector) throws InterruptedException {
        long l = 5L;
        do {
            try {
                for (Future<Integer> future : vector) {
                    if (future.isDone()) continue;
                    future.get(l, TimeUnit.SECONDS);
                }
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "ConcurrentJobCommand all done.");
                return;
            }
            catch (TimeoutException timeoutException) {
            }
            catch (ExecutionException executionException) {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "ConcurrentJobCommand - wait got Throwable: ", executionException);
            }
            catch (CancellationException cancellationException) {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "ConcurrentJobCommand - wait got Throwable: ", cancellationException);
            }
            catch (InterruptedException interruptedException) {
                PackageInfo.LOGGER.log(DistcompLevel.SIX, "ConcurrentJobCommand - wait got InterruptedException: ", interruptedException);
                throw interruptedException;
            }
        } while (!this.isCancelled() && !this.isDestroyed());
        PackageInfo.LOGGER.log(DistcompLevel.FOUR, "ConcurrentJobCommand - cancelled (" + this.isCancelled() + ") or destroyed (" + this.isDestroyed() + ")");
    }
}

