/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.local;

import com.mathworks.toolbox.distcomp.local.AbstractExecutableCommand;
import com.mathworks.toolbox.distcomp.local.AbstractLocalCommand;
import com.mathworks.toolbox.distcomp.local.ConcurrentTaskCommand;
import com.mathworks.toolbox.distcomp.local.PackageInfo;
import com.mathworks.toolbox.parallel.pctutil.concurrent.NamedThreadFactory;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;

public abstract class AbstractConcurrentJobCommand
extends AbstractExecutableCommand {
    private ConcurrentTaskCommand[] fTaskCommands;

    protected AbstractConcurrentJobCommand(String[] stringArray, String[] stringArray2, String[] stringArray3, String string, int n, int n2) throws IOException {
        super(stringArray, stringArray2, stringArray3, string, n, n2);
    }

    @Override
    protected synchronized AbstractLocalCommand.State getStateEnum() {
        if (this.isDone()) {
            if (this.isCancelled()) {
                return AbstractLocalCommand.State.CANCELLED_STATE;
            }
            for (ConcurrentTaskCommand concurrentTaskCommand : this.fTaskCommands) {
                Process process = concurrentTaskCommand.getProcess();
                if (process != null && process.exitValue() == 0) continue;
                return AbstractLocalCommand.State.FAILED_STATE;
            }
            return AbstractLocalCommand.State.FINISHED_STATE;
        }
        return super.getStateEnum();
    }

    protected abstract void waitUntilJobShouldTerminate(Vector<Future<Integer>> var1) throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndRunTasks(int n) throws IOException, InterruptedException {
        ExecutorService executorService = Executors.newFixedThreadPool(n, (ThreadFactory)NamedThreadFactory.createDaemonThreadFactory((String)(this.getClass().getSimpleName() + " service-"), (Logger)PackageInfo.LOGGER));
        Vector<Future<Integer>> vector = new Vector<Future<Integer>>(n);
        try (FileOutputStream fileOutputStream = new FileOutputStream(this.fLogFile, true);){
            AbstractConcurrentJobCommand abstractConcurrentJobCommand = this;
            synchronized (abstractConcurrentJobCommand) {
                this.fTaskCommands = new ConcurrentTaskCommand[n];
                for (int i = 0; i < n; ++i) {
                    this.fTaskCommands[i] = new ConcurrentTaskCommand(i, n, this, fileOutputStream);
                    vector.add(executorService.submit(this.fTaskCommands[i]));
                }
            }
            this.waitUntilJobShouldTerminate(vector);
        }
        finally {
            this.destroyAllProcesses();
            executorService.shutdownNow();
        }
    }

    @Override
    public Object onRun(int n) throws IOException, InterruptedException {
        block3: {
            assert (n > 0) : "Unexpectedly didn't get any tokens";
            try {
                this.createAndRunTasks(n);
            }
            catch (IOException iOException) {
                if (this.isDestroyed() || Thread.currentThread().isInterrupted()) break block3;
                PackageInfo.LOGGER.log(DistcompLevel.ZERO, "Failed to create or run tasks", iOException);
                throw iOException;
            }
        }
        return null;
    }

    private synchronized void destroyAllProcesses() {
        for (ConcurrentTaskCommand concurrentTaskCommand : this.fTaskCommands) {
            Process process;
            if (concurrentTaskCommand == null || (process = concurrentTaskCommand.getProcess()) == null) continue;
            process.destroy();
        }
    }
}

