/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.jobmanager.JobManagerAcceptorSSLSecurityDescription;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerClientOutputGroupFactory;
import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.pmode.io.DirectCommunicationGroup;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerConnectInfoDispatcher;
import com.mathworks.toolbox.distcomp.pmode.io.broker.BrokerConnectInfoErrorHandler;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.AbstractPeerAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerDispatcher;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerInstance;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerPassiveAcceptor;
import com.mathworks.toolbox.distcomp.pmode.peermessaging.PeerSession;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorPlainSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.AcceptorSecurityDescription;
import com.mathworks.toolbox.distcomp.pmode.shared.Connection;
import com.mathworks.toolbox.distcomp.pmode.shared.Message;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketAcceptInfo;
import com.mathworks.toolbox.distcomp.pmode.shared.ServerSocketConnectInfo;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.io.IOException;
import java.security.cert.Certificate;
import java.util.HashSet;
import javax.net.ssl.SSLContext;

final class JobManagerImplPeerSession {
    private final PeerInstance fPeerInstance;
    private final SSLContext fSSLContext;
    private final Certificate fCertificate;
    private PeerSession fPeerSession;
    private PeerPassiveAcceptor fPeerSessionAcceptor;

    JobManagerImplPeerSession(PeerInstance peerInstance, SSLContext sSLContext, Certificate certificate) {
        this.fPeerInstance = peerInstance;
        this.fSSLContext = sSLContext;
        this.fCertificate = certificate;
    }

    void start(String string, int n, int n2, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) throws AbstractPeerAcceptor.InitializeServerSocketChannelException {
        AcceptorSecurityDescription acceptorSecurityDescription;
        if (this.fPeerSession != null) {
            throw new IllegalStateException("PeerSession has already been started.");
        }
        if (this.fSSLContext == null) {
            acceptorSecurityDescription = new AcceptorPlainSecurityDescription();
        } else {
            PackageInfo.LOGGER.log(DistcompLevel.TWO, "Configuring PeerSession to use SSL");
            acceptorSecurityDescription = new JobManagerAcceptorSSLSecurityDescription(this.fSSLContext, false, this.fCertificate);
        }
        ServerSocketAcceptInfo serverSocketAcceptInfo = ServerSocketAcceptInfo.createServerSocketAcceptInfo(DirectCommunicationGroup.class, this.fPeerInstance.getGroupUuid(), n, n2, acceptorSecurityDescription);
        PackageInfo.LOGGER.log(DistcompLevel.ONE, "Initializing peer session: " + this.fPeerInstance);
        HashSet<PeerDispatcher<? extends Message>> hashSet = new HashSet<PeerDispatcher<? extends Message>>(1);
        BrokerConnectInfoDispatcher brokerConnectInfoDispatcher = new BrokerConnectInfoDispatcher();
        hashSet.add(brokerConnectInfoDispatcher);
        BrokerConnectInfoErrorHandler brokerConnectInfoErrorHandler = new BrokerConnectInfoErrorHandler(brokerConnectInfoDispatcher);
        this.fPeerSession = new PeerSession(serverSocketAcceptInfo, this.fPeerInstance, brokerConnectInfoErrorHandler, hashSet);
        JobManagerClientOutputGroupFactory.setOutputGroup(this.fPeerSession.getOutputGroup());
        this.fPeerSessionAcceptor = new PeerPassiveAcceptor(string, this.fPeerInstance, serverSocketAcceptInfo, uncaughtExceptionHandler);
        PackageInfo.LOGGER.log(DistcompLevel.TWO, "Accepting peer session connections on " + n);
        this.fPeerSessionAcceptor.startAccepting(this.createConnectionHandler());
    }

    ServerSocketConnectInfo getConnectInfo() {
        return this.fPeerSessionAcceptor.getInfoToConnect();
    }

    private PeerPassiveAcceptor.ConnectionHandler createConnectionHandler() {
        return new PeerPassiveAcceptor.ConnectionHandler(){

            @Override
            public void newConnection(Connection connection) {
                PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Accepted " + connection.getLogString());
                try {
                    JobManagerImplPeerSession.this.fPeerSession.addConnection(connection);
                }
                catch (RuntimeException runtimeException) {
                    PackageInfo.LOGGER.log(DistcompLevel.ONE, "Failed to add " + connection + " to session.", runtimeException);
                    this.safeCloseConnection(connection);
                }
            }

            private void safeCloseConnection(Connection connection) {
                try {
                    connection.close();
                }
                catch (IOException iOException) {
                    PackageInfo.LOGGER.log(DistcompLevel.FOUR, "Failed to close " + connection.getLogString(), iOException);
                }
            }
        };
    }

    void stop() {
        this.fPeerSessionAcceptor.close();
        this.fPeerSession.normalShutdown();
    }
}

