/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.jobmanager;

import com.mathworks.toolbox.distcomp.distcompobjects.DistcompException;
import com.mathworks.toolbox.distcomp.jobmanager.ForwardingJobManagerProxy;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerAddress;
import com.mathworks.toolbox.distcomp.jobmanager.JobManagerLocal;
import com.mathworks.toolbox.distcomp.jobmanager.PackageInfo;
import com.mathworks.toolbox.distcomp.jobmanager.TestedJobManager;
import com.mathworks.toolbox.distcomp.jobmanager.TestedJobManagerProxy;
import com.mathworks.toolbox.distcomp.service.ServiceAccessor;
import com.mathworks.toolbox.distcomp.storage.Cache;
import com.mathworks.toolbox.distcomp.storage.LRUCache;
import com.mathworks.toolbox.distcomp.util.Accessor;
import com.mathworks.toolbox.distcomp.util.AccessorException;
import com.mathworks.toolbox.distcomp.util.MCRShutdownHandler;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;

public class CachedJobManagerProxy
extends ForwardingJobManagerProxy {
    private static final int CACHE_SIZE = 10;
    private static final Cache<JobManagerAddress, JobManagerLocal> CACHE = new LRUCache<JobManagerAddress, JobManagerLocal>(10);
    private static final AtomicBoolean SHUTDOWN_HOOK_ADDED = new AtomicBoolean(false);

    private CachedJobManagerProxy(JobManagerLocal jobManagerLocal) {
        super(jobManagerLocal);
    }

    public static List<TestedJobManager> create(String string, String string2, ServiceAccessor.AccessorFactory accessorFactory) throws DistcompException, AccessorException {
        Object object;
        Object object2;
        TestedJobManager testedJobManager = null;
        if (string != null && string2 != null && !string.isEmpty() && !string2.isEmpty()) {
            object2 = new JobManagerAddress(string, string2);
            object = CACHE.lock((JobManagerAddress)object2);
            Throwable throwable = null;
            try {
                testedJobManager = CachedJobManagerProxy.getAndTestJobManagerFromCache((Cache.CacheToken<JobManagerAddress>)object);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object != null) {
                    if (throwable != null) {
                        try {
                            object.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        object.close();
                    }
                }
            }
        }
        object2 = new ArrayList<TestedJobManager>();
        if (testedJobManager == null || !testedJobManager.isOk()) {
            object = accessorFactory.getAccessor();
            object2.addAll(CachedJobManagerProxy.getJobManagersFromAccessor(string, string2, (Accessor)object));
        } else {
            object2.add(testedJobManager);
        }
        return object2;
    }

    private static List<TestedJobManager> getJobManagersFromAccessor(String string, String string2, Accessor accessor) throws DistcompException, AccessorException {
        Object[] objectArray;
        ArrayList<TestedJobManager> arrayList = new ArrayList<TestedJobManager>();
        for (Object object : objectArray = accessor.getJobManagers(string2)) {
            JobManagerLocal jobManagerLocal = (JobManagerLocal)object;
            TestedJobManager testedJobManager = CachedJobManagerProxy.getOrReplaceCachedProxy(jobManagerLocal, string);
            arrayList.add(testedJobManager);
        }
        return arrayList;
    }

    private static TestedJobManager getOrReplaceCachedProxy(JobManagerLocal jobManagerLocal, String string) {
        TestedJobManager testedJobManager;
        JobManagerAddress jobManagerAddress = CachedJobManagerProxy.createCacheKey(string, jobManagerLocal);
        try (Cache.CacheToken<JobManagerAddress> cacheToken = CACHE.lock(jobManagerAddress);){
            TestedJobManager testedJobManager2 = CachedJobManagerProxy.getAndTestJobManagerFromCache(cacheToken);
            if (testedJobManager2 == null || !testedJobManager2.isOk()) {
                PackageInfo.LOGGER.log(Level.FINEST, "No cached proxy, or proxy failed tests for " + jobManagerAddress.toString() + " testing and caching new proxy.");
                testedJobManager = TestedJobManagerProxy.create(new CachedJobManagerProxy(jobManagerLocal));
                if (testedJobManager.isVersionOk()) {
                    if (testedJobManager.isOneWayCommunicationOk() && testedJobManager.isTwoWayCommunicationOk()) {
                        PackageInfo.LOGGER.log(Level.FINE, "New job manager: " + jobManagerLocal.toString() + " passed communication tests, putting in cache.");
                        CACHE.put(jobManagerAddress, jobManagerLocal);
                    } else {
                        PackageInfo.LOGGER.log(Level.WARNING, "New job manager: " + jobManagerLocal.toString() + " failed communication tests, not putting in cache.");
                    }
                }
            } else {
                testedJobManager = testedJobManager2;
            }
        }
        return testedJobManager;
    }

    private static TestedJobManager getAndTestJobManagerFromCache(Cache.CacheToken<JobManagerAddress> cacheToken) {
        TestedJobManagerProxy testedJobManagerProxy = null;
        JobManagerLocal jobManagerLocal = CACHE.get(cacheToken);
        if (jobManagerLocal != null && !(testedJobManagerProxy = TestedJobManagerProxy.create(new CachedJobManagerProxy(jobManagerLocal))).isOk()) {
            PackageInfo.LOGGER.log(DistcompLevel.FOUR, "JobManagerProxy test failed for: " + cacheToken.getKey() + ", removing from cache.");
            CACHE.remove(cacheToken);
        }
        return testedJobManagerProxy;
    }

    private static JobManagerAddress createCacheKey(String string, JobManagerLocal jobManagerLocal) {
        String string2 = string == null || string.isEmpty() ? jobManagerLocal.getLookupURL() : string;
        String string3 = jobManagerLocal.getName();
        return new JobManagerAddress(string2, string3);
    }

    @Override
    public void dispose() {
    }

    @Override
    public void addShutdownHookForCurrentMCR() {
        CachedJobManagerProxy.addShutdownHookOnce();
    }

    private static void addShutdownHookOnce() {
        boolean bl = SHUTDOWN_HOOK_ADDED.getAndSet(true);
        if (!bl) {
            JobManagerProxyDisposer jobManagerProxyDisposer = new JobManagerProxyDisposer(CACHE);
            MCRShutdownHandler.addShutdownHookForCurrentMCR(new Thread(jobManagerProxyDisposer));
        }
    }

    private static class JobManagerProxyDisposer
    implements Runnable {
        private final Cache<JobManagerAddress, JobManagerLocal> fCache;

        JobManagerProxyDisposer(Cache<JobManagerAddress, JobManagerLocal> cache) {
            this.fCache = cache;
        }

        @Override
        public void run() {
            List<JobManagerLocal> list = this.fCache.removeAll();
            for (JobManagerLocal jobManagerLocal : list) {
                jobManagerLocal.dispose();
            }
        }
    }
}

