/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.distcompobjects;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.distcompobjects.Distcomp;
import com.mathworks.toolbox.distcomp.util.Version;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;

public abstract class DistcompProxy
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int VERSION_NUM_ON_ORIGIN = 20;
    private String VERSION_STRING_ON_ORIGIN = Version.VERSION_STRING;
    private byte[] fSerializedProxy;

    protected DistcompProxy(Distcomp distcomp) throws SerializeProxyException {
        this.setSerializedProxy(distcomp);
    }

    protected Object getSerializedProxy() throws DeserializeProxyException {
        Object var1_1 = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(this.fSerializedProxy));
            var1_1 = ((MarshalledObject)objectInputStream.readObject()).get();
            objectInputStream.close();
        }
        catch (IOException | ClassNotFoundException exception) {
            throw new DeserializeProxyException(exception);
        }
        return var1_1;
    }

    protected void setSerializedProxy(Object object) throws SerializeProxyException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(new MarshalledObject<Object>(object));
            objectOutputStream.close();
            this.fSerializedProxy = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new SerializeProxyException(iOException);
        }
    }

    public boolean checkVersion() {
        return 20 == this.VERSION_NUM_ON_ORIGIN;
    }

    public String getVersionString() {
        return this.VERSION_STRING_ON_ORIGIN;
    }

    public int getVersionNumber() {
        return this.VERSION_NUM_ON_ORIGIN;
    }

    public static class DeserializeProxyException
    extends I18nRemoteException {
        public DeserializeProxyException() {
            super((BaseMsgID)new mjs.UnableToDeserializeProxy());
        }

        public DeserializeProxyException(Throwable throwable) {
            super((BaseMsgID)new mjs.UnableToDeserializeProxy(), throwable);
        }
    }

    public static class SerializeProxyException
    extends I18nRemoteException {
        public SerializeProxyException() {
            super((BaseMsgID)new mjs.UnableToSerializeProxy());
        }

        public SerializeProxyException(Throwable throwable) {
            super((BaseMsgID)new mjs.UnableToSerializeProxy(), throwable);
        }
    }

    private static class I18nRemoteException
    extends RemoteException
    implements I18nMatlabIdentifiedException {
        private final XMLMessageCreator fErrorMessageCreator = new XMLMessageCreator();
        private final BaseMsgID fMessageID;

        protected I18nRemoteException(BaseMsgID baseMsgID) {
            this.fMessageID = baseMsgID;
        }

        protected I18nRemoteException(BaseMsgID baseMsgID, Throwable throwable) {
            super("", throwable);
            this.fMessageID = baseMsgID;
        }

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.fMessageID);
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.fMessageID);
        }

        public String getMessageID() {
            return this.fMessageID.getCatalogId() + ":" + this.fMessageID.getMessageId();
        }
    }
}

