/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.servicerequest;

import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.control.servicerequest.RequestResponse;
import com.mathworks.toolbox.distcomp.remote.Command;
import com.mathworks.toolbox.distcomp.remote.Future;
import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutionException;
import com.mathworks.toolbox.distcomp.remote.RemoteExecutor;
import java.util.concurrent.Callable;

public abstract class Request<R extends RequestResponse>
implements Callable<R> {
    private Host fHost;
    private ParameterMap fParameterMap;

    public Request(Host host) {
        this.fHost = host;
        this.fParameterMap = new ParameterMap();
    }

    public String getHostName() {
        return this.fHost.getHostname();
    }

    public Host getHost() {
        return this.fHost;
    }

    public ParameterMap getParameterMap() {
        return this.fParameterMap;
    }

    public <V> void addParameterValue(Parameter<V> parameter, V v) {
        assert (parameter != null);
        this.fParameterMap.put(parameter, v);
    }

    public void addParameterMap(ParameterMap parameterMap) {
        if (parameterMap == null) {
            return;
        }
        this.fParameterMap.putAll(parameterMap);
    }

    protected final Future execute(Command command) throws RemoteExecutionException {
        assert (command != null);
        return RemoteExecutor.executeUsingRecommendedProtocol(command, this.getHostName(), this.getParameterMap());
    }

    public abstract R failedToExecute(Throwable var1);
}

