/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.serviceinfo;

import com.mathworks.toolbox.distcomp.control.MDCSFuture;
import com.mathworks.toolbox.distcomp.control.MDCSParameter;
import com.mathworks.toolbox.distcomp.control.StatusCommand;
import com.mathworks.toolbox.distcomp.control.serviceinfo.MDCSServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.StatusRequestResponse;
import com.mathworks.toolbox.distcomp.control.serviceinfo.VersionMismatchException;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.control.servicerequest.Request;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.Ping;

public final class StatusRequest
extends Request<StatusRequestResponse> {
    private static final Integer STATUS_REQUEST_TIMEOUT_SECS = 60;
    private boolean fHostReachable = false;
    private StatusCommand fStatusCommand;

    public StatusRequest(Host host) {
        super(host);
        this.createRemoteMDCSCommand();
        this.addParameterValue(MDCSParameter.SOCKET_TIMEOUT_SECS, STATUS_REQUEST_TIMEOUT_SECS);
    }

    @Override
    public synchronized StatusRequestResponse call() {
        StatusRequestResponse statusRequestResponse;
        try {
            Ping.checkIfHostIsResolvable(this.getHostName());
            this.fHostReachable = true;
            MDCSFuture mDCSFuture = (MDCSFuture)this.execute(this.fStatusCommand);
            statusRequestResponse = (StatusRequestResponse)mDCSFuture.getResults();
        }
        catch (Throwable throwable) {
            statusRequestResponse = this.failedToExecute(throwable);
        }
        return statusRequestResponse;
    }

    @Override
    public synchronized StatusRequestResponse failedToExecute(Throwable throwable) {
        StatusRequestResponse statusRequestResponse = new StatusRequestResponse(false);
        MDCSServiceInfo mDCSServiceInfo = this.handleVersionMismatchException(throwable);
        if (mDCSServiceInfo == null) {
            mDCSServiceInfo = MDCSServiceInfo.createUnknownInfo(this.getHost(), throwable, this.fHostReachable);
        }
        statusRequestResponse.addServiceInfo(mDCSServiceInfo);
        return statusRequestResponse;
    }

    private void createRemoteMDCSCommand() {
        int n = 3;
        String string = this.getHostName();
        this.fStatusCommand = new StatusCommand(n);
        this.fStatusCommand.produceStatusRequestResponse(true);
        this.fStatusCommand.setUserSpecifiedHostName(string);
    }

    private MDCSServiceInfo handleVersionMismatchException(Throwable throwable) {
        if (throwable != null && throwable.getCause() instanceof DistcompDiagnosticException && throwable.getCause().getCause() instanceof VersionMismatchException) {
            VersionMismatchException versionMismatchException = (VersionMismatchException)throwable.getCause().getCause();
            return MDCSServiceInfo.createUnsupportedVersionInfo(this.getHost(), versionMismatchException, this.fHostReachable, versionMismatchException.getRemoteVersion());
        }
        return null;
    }
}

