/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.serviceinfo;

import com.mathworks.toolbox.distcomp.control.MDCSHostInfo;
import com.mathworks.toolbox.distcomp.control.ServiceType;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceInfo;
import com.mathworks.toolbox.distcomp.control.serviceinfo.ServiceStatus;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.util.SystemArchitecture;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class MDCSServiceInfo
extends ServiceInfo {
    private static final long serialVersionUID = -8260330315338546906L;
    private static final String SERVICE_NAME = "MDCS";
    private static final ServiceType SERVICE_TYPE = ServiceType.PHOENIX;
    private final Throwable fException;
    private final boolean fHostResolvable;
    private final List<String> fJobManagerNames;
    private final List<String> fWorkerNames;
    private final Integer fNumCores;
    private final String[] fHostAddresses;
    private final Boolean fHasLookup;
    private final Integer fSecurityLevel;
    private final String fVersion;
    private final String fMatlabRoot;
    private final SystemArchitecture fSystemArch;
    private final String fMdceDefFile;

    private MDCSServiceInfo(Host host, Date date, Throwable throwable, boolean bl, ServiceStatus serviceStatus, Boolean bl2, MDCSHostInfo mDCSHostInfo, Integer n, String string, String string2, String string3) {
        super(SERVICE_NAME, host, date, serviceStatus);
        this.fException = throwable;
        this.fJobManagerNames = new ArrayList<String>();
        this.fWorkerNames = new ArrayList<String>();
        this.fHostResolvable = bl;
        this.fHasLookup = bl2;
        this.fSystemArch = mDCSHostInfo.getSystemArchitecture();
        this.fNumCores = mDCSHostInfo.getNumberOfProcessors();
        this.fHostAddresses = mDCSHostInfo.getHostAddresses();
        this.fSecurityLevel = n;
        this.fVersion = string;
        this.fMatlabRoot = string2;
        this.fMdceDefFile = string3;
    }

    private MDCSServiceInfo(Host host, Throwable throwable, boolean bl, ServiceStatus serviceStatus) {
        super(SERVICE_NAME, host, null, serviceStatus);
        assert (serviceStatus != ServiceStatus.RUNNING);
        this.fException = throwable;
        this.fHostResolvable = bl;
        this.fJobManagerNames = new ArrayList<String>();
        this.fWorkerNames = new ArrayList<String>();
        this.fNumCores = null;
        this.fHostAddresses = null;
        this.fHasLookup = null;
        this.fSecurityLevel = null;
        this.fVersion = null;
        this.fMatlabRoot = null;
        this.fSystemArch = null;
        this.fMdceDefFile = null;
    }

    private MDCSServiceInfo(Host host, Throwable throwable, boolean bl, ServiceStatus serviceStatus, String string) {
        super(SERVICE_NAME, host, null, serviceStatus);
        assert (serviceStatus != ServiceStatus.RUNNING);
        this.fException = throwable;
        this.fHostResolvable = bl;
        this.fJobManagerNames = new ArrayList<String>();
        this.fWorkerNames = new ArrayList<String>();
        this.fNumCores = null;
        this.fHostAddresses = null;
        this.fHasLookup = null;
        this.fSecurityLevel = null;
        this.fVersion = string;
        this.fMatlabRoot = null;
        this.fSystemArch = null;
        this.fMdceDefFile = null;
    }

    public static MDCSServiceInfo createRunningInfo(Host host, Date date, Boolean bl, MDCSHostInfo mDCSHostInfo, Integer n, String string, String string2, String string3) {
        assert (host != null) : "host was null";
        return new MDCSServiceInfo(host, date, null, true, ServiceStatus.RUNNING, bl, mDCSHostInfo, n, string, string2, string3);
    }

    public static MDCSServiceInfo createStoppedInfo(Host host) {
        assert (host != null) : "host was null";
        Throwable throwable = null;
        boolean bl = true;
        ServiceStatus serviceStatus = ServiceStatus.STOPPED;
        return new MDCSServiceInfo(host, throwable, bl, serviceStatus);
    }

    public static MDCSServiceInfo createNotRunningInfo(Host host) {
        assert (host != null) : "host was null";
        Throwable throwable = null;
        boolean bl = true;
        ServiceStatus serviceStatus = ServiceStatus.NOT_RUNNING;
        return new MDCSServiceInfo(host, throwable, bl, serviceStatus);
    }

    public static MDCSServiceInfo createUnknownInfo(Host host, Throwable throwable, boolean bl) {
        ServiceStatus serviceStatus = ServiceStatus.UNKNOWN;
        return new MDCSServiceInfo(host, throwable, bl, serviceStatus);
    }

    public static MDCSServiceInfo createUnsupportedVersionInfo(Host host, Throwable throwable, boolean bl, String string) {
        ServiceStatus serviceStatus = ServiceStatus.UNSUPPORTED_VERSION;
        return new MDCSServiceInfo(host, throwable, bl, serviceStatus, string);
    }

    public Throwable getException() {
        return this.fException;
    }

    public boolean isHostResolvable() {
        return this.fHostResolvable;
    }

    public List<String> getJobManagerNames() {
        return this.fJobManagerNames;
    }

    public List<String> getWorkerNames() {
        return this.fWorkerNames;
    }

    void addJobManagerName(String string) {
        if (!this.fJobManagerNames.contains(string)) {
            this.fJobManagerNames.add(string);
        }
    }

    void addWorkerName(String string) {
        if (!this.fWorkerNames.contains(string)) {
            this.fWorkerNames.add(string);
        }
    }

    @Override
    protected ServiceType getServiceType() {
        return SERVICE_TYPE;
    }

    @Override
    public String toString() {
        String string = "MDCS:       " + super.toString();
        string = string + " | " + this.isHostResolvable();
        if (this.getStatus() == ServiceStatus.RUNNING) {
            string = string + " | " + this.getJobManagerNames().size() + " | " + this.getWorkerNames().size();
        } else {
            String string2 = "-";
            if (this.fException != null) {
                string2 = this.getException().toString();
                Throwable throwable = this.getException().getCause();
                if (throwable != null) {
                    string2 = string2 + " (cause: " + throwable + ")";
                }
            }
            string = string + " | " + string2.replaceAll("\n", " ");
        }
        return string;
    }

    public Integer getNumCores() {
        return this.fNumCores;
    }

    public String[] getHostAddresses() {
        return this.fHostAddresses;
    }

    public Boolean getHasLookup() {
        return this.fHasLookup;
    }

    public Integer getSecurityLevel() {
        return this.fSecurityLevel;
    }

    public String getVersion() {
        return this.fVersion;
    }

    public String getMatlabRoot() {
        return this.fMatlabRoot;
    }

    public SystemArchitecture getSystemArchitecture() {
        return this.fSystemArch;
    }

    public String getMdceDefFile() {
        return this.fMdceDefFile;
    }
}

