/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control.remoteprotocol.scremote.client;

import com.mathworks.toolbox.distcomp.remote.Parameter;
import com.mathworks.toolbox.distcomp.remote.ParameterImpl;
import com.mathworks.toolbox.distcomp.remote.ParameterMap;
import com.mathworks.toolbox.distcomp.remote.spi.HostParameterKey;
import com.mathworks.toolbox.distcomp.remote.util.PathUtils;
import java.io.File;

public final class PeerSCHostParameterKey
implements HostParameterKey {
    private final String fHostname;
    private final ParameterMap fParameterMap;
    private final ParameterMap fModifiedParameterMap;

    public PeerSCHostParameterKey(String string, ParameterMap parameterMap) {
        this.fHostname = string;
        this.fParameterMap = parameterMap;
        this.fModifiedParameterMap = PeerSCHostParameterKey.replaceMATLABRootParameter(parameterMap);
    }

    private static ParameterMap replaceMATLABRootParameter(ParameterMap parameterMap) {
        ParameterMap parameterMap2 = parameterMap.createCopy();
        if (parameterMap2.containsKey(PathUtils.MatlabRootParameter.MATLAB_ROOT)) {
            String string = parameterMap2.remove(PathUtils.MatlabRootParameter.MATLAB_ROOT);
            File file = new File(string);
            parameterMap2.put(MatlabRootFileParameter.MATLAB_ROOT_FILE, file);
        }
        return parameterMap2;
    }

    @Override
    public String getHostname() {
        return this.fHostname;
    }

    @Override
    public ParameterMap getParameterMap() {
        return this.fParameterMap;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PeerSCHostParameterKey peerSCHostParameterKey = (PeerSCHostParameterKey)object;
        if (!this.fHostname.equals(peerSCHostParameterKey.fHostname)) {
            return false;
        }
        return this.fModifiedParameterMap.equals(peerSCHostParameterKey.fModifiedParameterMap);
    }

    public int hashCode() {
        int n = this.fHostname.hashCode();
        n = 31 * n + this.fModifiedParameterMap.hashCode();
        return n;
    }

    public static class MatlabRootFileParameter<V>
    extends ParameterImpl<V> {
        private static final Parameter<File> MATLAB_ROOT_FILE = new MatlabRootFileParameter<File>(Key.MATLAB_ROOT, true, File.class);

        private MatlabRootFileParameter(Parameter.PersistentKey persistentKey, boolean bl, Class<V> clazz) {
            super(persistentKey, bl, clazz);
        }

        @Override
        protected String getSimpleName() {
            return MatlabRootFileParameter.class.getSimpleName();
        }

        private static enum Key implements Parameter.PersistentKey
        {
            MATLAB_ROOT;

        }
    }
}

