/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.toolbox.distcomp.util.LocalNetworkInfo;
import com.mathworks.toolbox.distcomp.util.ProcessorUtil;
import com.mathworks.toolbox.distcomp.util.SystemArchitecture;
import java.util.Arrays;

public final class MDCSHostInfo {
    private final String[] fHostAddresses;
    private final Integer fNumberOfProcessors;
    private final SystemArchitecture fSystemArchitecture;

    public static MDCSHostInfo forLocalHost() {
        String[] stringArray = LocalNetworkInfo.findAllHostAddresses();
        Integer n = ProcessorUtil.getNumberOfProcessors();
        SystemArchitecture systemArchitecture = SystemArchitecture.forLocalHost();
        return new MDCSHostInfo(systemArchitecture, n, stringArray);
    }

    public MDCSHostInfo(SystemArchitecture systemArchitecture, Integer n, String[] stringArray) {
        this.fNumberOfProcessors = n;
        this.fSystemArchitecture = systemArchitecture;
        this.fHostAddresses = stringArray;
    }

    public String[] getHostAddresses() {
        return Arrays.copyOf(this.fHostAddresses, this.fHostAddresses.length);
    }

    public Integer getNumberOfProcessors() {
        return this.fNumberOfProcessors;
    }

    public SystemArchitecture getSystemArchitecture() {
        return this.fSystemArchitecture;
    }
}

