/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.control.CommandConfigParser;
import com.mathworks.toolbox.distcomp.control.ConfigRunner;
import com.mathworks.toolbox.distcomp.control.ControlJobmanager;
import com.mathworks.toolbox.distcomp.control.ControlLookup;
import com.mathworks.toolbox.distcomp.control.ControlMessageException;
import com.mathworks.toolbox.distcomp.control.ControlStartStopProcess;
import com.mathworks.toolbox.distcomp.control.ControlWorker;
import com.mathworks.toolbox.distcomp.control.PortConfig;
import com.mathworks.toolbox.distcomp.control.Starter;
import com.mathworks.toolbox.distcomp.control.Stopper;
import com.mathworks.toolbox.distcomp.control.servicerequest.Host;
import com.mathworks.toolbox.distcomp.util.ConfigFileWrapper;
import net.jini.config.ConfigurationException;

public class ControlStartStopConfigParser {
    private static final String ACTION = "remoteAction";
    private static final String SERVICE_CONFIG_FILE = "serviceConfigFile";
    private static final String CLEAN = "cleanCheckpointInfo";
    private static final String PRESERVE_JOBS = "preserveJobs";
    private static final String USE_GDS_STORAGE = "useGDSStorage";
    private static final String GDS_END_POINT = "GDSEndPoint";
    private static final String GDS_LOGIN_TOKEN = "GDSLoginToken";
    private static final String GDS_QUEUE_ID = "GDSQueueID";
    private static final String SERVICE_NAME = "serviceName";
    private static final String JOBMANAGER_NAME = "jobmanagerName";
    private static final String LOOKUP_HOSTS = "lookupHosts";
    private static final String START_ACTION = "start";
    private static final String STOP_ACTION = "stop";

    private ControlStartStopConfigParser() {
    }

    public static ControlStartStopProcess createStartStopCommand(ConfigFileWrapper configFileWrapper) throws ControlMessageException, ConfigurationException {
        ControlStartStopProcess controlStartStopProcess;
        String string = configFileWrapper.getNonEmptyStringEntry("remoteCommandType");
        String string2 = configFileWrapper.getNonEmptyStringEntry(ACTION);
        String string3 = configFileWrapper.getStringEntry(SERVICE_NAME);
        String string4 = CommandConfigParser.getRemoteHostname(configFileWrapper);
        int n = PortConfig.getBasePortFromRemoteCommandPort(CommandConfigParser.getRemotePort(configFileWrapper));
        String string5 = configFileWrapper.getNonEmptyStringEntry(SERVICE_CONFIG_FILE);
        boolean bl = ControlStartStopConfigParser.actionToStartOrStop(string2);
        ConfigRunner configRunner = ControlStartStopConfigParser.getConfigRunner(bl);
        switch (string) {
            case "jobmanager": {
                Host host = new Host(string4);
                ControlJobmanager controlJobmanager = new ControlJobmanager(configRunner, bl, string5, string3, host, n);
                if (bl) {
                    controlJobmanager.setLookupHosts(configFileWrapper.getStringEntry(LOOKUP_HOSTS));
                }
                boolean bl2 = false;
                boolean bl3 = configFileWrapper.getBooleanEntry(PRESERVE_JOBS, bl2);
                controlJobmanager.setPreserveJobs(bl3);
                boolean bl4 = false;
                boolean bl5 = configFileWrapper.getBooleanEntry(USE_GDS_STORAGE, bl4);
                controlJobmanager.setUseGDSStorage(bl5);
                controlJobmanager.setGDSEndPoint(configFileWrapper.getStringEntry(GDS_END_POINT));
                controlJobmanager.setGDSLoginToken(configFileWrapper.getStringEntry(GDS_LOGIN_TOKEN));
                controlJobmanager.setGDSQueueID(configFileWrapper.getStringEntry(GDS_QUEUE_ID));
                controlStartStopProcess = controlJobmanager;
                break;
            }
            case "lookup": {
                controlStartStopProcess = new ControlLookup(configRunner, bl, string5, string3);
                break;
            }
            case "worker": {
                String string6 = configFileWrapper.getStringEntry(JOBMANAGER_NAME);
                ControlWorker controlWorker = new ControlWorker(configRunner, bl, string5, string3, string6);
                if (bl) {
                    controlWorker.setLookupHosts(configFileWrapper.getStringEntry(LOOKUP_HOSTS));
                }
                controlStartStopProcess = controlWorker;
                break;
            }
            default: {
                throw new UnknownServiceTypeException(string);
            }
        }
        boolean bl6 = false;
        boolean bl7 = configFileWrapper.getBooleanEntry(CLEAN, bl6);
        controlStartStopProcess.setClean(bl7);
        controlStartStopProcess.getInfo().setIsStarting(bl);
        controlStartStopProcess.getInfo().setRemoteHostname(CommandConfigParser.getRemoteHostname(configFileWrapper));
        return controlStartStopProcess;
    }

    private static boolean actionToStartOrStop(String string) throws ControlMessageException {
        if (string.equals(START_ACTION) || string.equals(STOP_ACTION)) {
            return string.equals(START_ACTION);
        }
        throw new InvalidActionSpecifiedException();
    }

    private static ConfigRunner getConfigRunner(boolean bl) {
        if (bl) {
            return new Starter();
        }
        return new Stopper();
    }

    private static final class InvalidActionSpecifiedException
    extends ControlParserException {
        private final BaseMsgID fBaseMsgID = new mjs.InvalidActionSpecified();

        private InvalidActionSpecifiedException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class UnknownServiceTypeException
    extends ControlParserException {
        private final BaseMsgID fBaseMsgID;

        private UnknownServiceTypeException(String string) {
            this.fBaseMsgID = new mjs.UnknownServiceType(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static abstract class ControlParserException
    extends ControlMessageException {
        ControlParserException() {
        }
    }
}

