/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.control;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.RootLog;
import com.mathworks.toolbox.distcomp.control.CommandDialogHandShake;
import com.mathworks.toolbox.distcomp.control.ControlMessage;
import com.mathworks.toolbox.distcomp.control.DisplayableResults;
import com.mathworks.toolbox.distcomp.control.MDCSCommand;
import com.mathworks.toolbox.distcomp.control.MDCSCommandResults;
import com.mathworks.toolbox.distcomp.control.RemoteCommand;
import com.mathworks.toolbox.distcomp.mjs.security.ClientCertificateStore;
import com.mathworks.toolbox.distcomp.mjs.security.SharedSecret;
import com.mathworks.toolbox.distcomp.mjs.security.SharedSecretException;
import com.mathworks.toolbox.distcomp.util.DistcompDiagnosticException;
import com.mathworks.toolbox.distcomp.util.ErrorPrinter;
import com.mathworks.toolbox.distcomp.util.ErrorPrinterImpl;
import com.mathworks.toolbox.distcomp.util.FormattableException;
import com.mathworks.toolbox.distcomp.util.Version;
import com.mathworks.toolbox.distcomp.util.i18n.I18nMatlabIdentifiedException;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompConsoleHandler;
import com.mathworks.toolbox.parallel.pctutil.logging.DistcompLevel;
import com.mathworks.toolbox.parallel.util.i18n.I18nMessageCreator;
import com.mathworks.toolbox.parallel.util.i18n.XMLMessageCreator;
import com.sun.jini.start.LifeCycle;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Handler;

public final class CommandListener {
    private static final int MAX_BYTES_TO_FLUSH = 1000000;
    private static long sStartTime;
    private int fPort;
    private ErrorPrinter fPrinter;
    private boolean fShouldListen;
    private Thread fListeningThread;
    private final int fSocketTimeoutInMilliSeconds = 1000;
    private ServerSocket fSsock;
    private boolean fPrint;

    public CommandListener(String[] stringArray, LifeCycle lifeCycle) {
        block10: {
            int n;
            this.fShouldListen = true;
            this.fListeningThread = null;
            this.fSocketTimeoutInMilliSeconds = 1000;
            this.fSsock = null;
            this.fPrint = false;
            if (stringArray.length != 2) {
                throw new WrongNumberOfArgumentsException(stringArray);
            }
            this.fPrint = true;
            if (this.fPrint) {
                System.out.println(new MDCEServiceVersionMessage(Version.VERSION_STRING).getLocalizedMessage());
            }
            try {
                n = Integer.parseInt(stringArray[0]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new CannotParsePortNumberException(stringArray[0], numberFormatException);
            }
            this.fPort = n;
            try {
                int n2 = Integer.parseInt(stringArray[1]);
                RootLog.LOG.addHandler((Handler)new DistcompConsoleHandler(n2));
            }
            catch (NumberFormatException numberFormatException) {
                throw new CannotParseLogLevelException(stringArray[1], numberFormatException);
            }
            this.fPrinter = new ErrorPrinterImpl();
            try {
                if (Boolean.getBoolean("com.mathworks.toolbox.distcomp.rmi.useSecureCommunication") && !Boolean.getBoolean("com.mathworks.toolbox.distcomp.rmi.clientsAreTrusted")) {
                    RootLog.LOG.log(DistcompLevel.SIX, "Attempting to install certificate from shared secret.");
                    Certificate certificate = SharedSecret.getInstance().getSharedSecretCertificate();
                    String string = CommandListener.class.getSimpleName();
                    ClientCertificateStore.getInstance().setCertificateEntry(string, certificate);
                }
            }
            catch (SharedSecretException sharedSecretException) {
                if (!this.fPrint) break block10;
                this.fPrinter.printError(sharedSecretException);
            }
        }
        if (this.fPrint) {
            System.out.println(new ListeningOnPortMessage(this.fPort).getLocalizedMessage());
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                CommandListener.this.listenForCommands();
            }
        };
        this.fListeningThread = new Thread(runnable, "Control CommandListener");
        this.fListeningThread.setDaemon(true);
        this.fListeningThread.start();
        sStartTime = System.currentTimeMillis();
    }

    public CommandListener(int n, ErrorPrinter errorPrinter) {
        this.fShouldListen = true;
        this.fListeningThread = null;
        this.fSocketTimeoutInMilliSeconds = 1000;
        this.fSsock = null;
        this.fPrint = false;
        this.fPort = n;
        this.fPrinter = errorPrinter;
    }

    public static Date getStartTime() {
        return new Date(sStartTime);
    }

    public void listenForCommands() {
        this.startListening();
        try {
            this.createServerSocket();
        }
        catch (Exception exception) {
            this.fPrinter.printError(exception);
            return;
        }
        while (this.shouldListen()) {
            MDCSCommandResults mDCSCommandResults;
            Object object;
            Socket socket;
            block24: {
                block23: {
                    try {
                        socket = this.getSocket();
                    }
                    catch (Exception exception) {
                        this.fPrinter.printError(new ErrorWhileReceivingCommandMessage().getLocalizedMessage(), exception);
                        continue;
                    }
                    if (socket == null) {
                        return;
                    }
                    try {
                        object = new DataInputStream(socket.getInputStream());
                        int n = ((DataInputStream)object).readInt();
                        int n2 = ((DataInputStream)object).readInt();
                        DataOutputStream dataOutputStream = new DataOutputStream(socket.getOutputStream());
                        dataOutputStream.writeInt(2999);
                        dataOutputStream.writeInt(20);
                        dataOutputStream.flush();
                        try {
                            CommandDialogHandShake.checkProtocolAndVersion(n, n2);
                            break block23;
                        }
                        catch (CommandDialogHandShake.HandShakeException handShakeException) {
                            this.fPrinter.printError(new ProblemWithProtocolAndVersionMessage().getLocalizedMessage(), handShakeException);
                            this.closeSocket(socket);
                        }
                    }
                    catch (IOException iOException) {
                        this.closeSocket(socket);
                    }
                    continue;
                }
                try {
                    object = this.getCommand(socket);
                }
                catch (IOException iOException) {
                    this.closeSocket(socket);
                    continue;
                }
                catch (Throwable throwable) {
                    this.fPrinter.printError(throwable);
                    this.flushInputstream(socket);
                    this.sendObjectAndCloseSocket(socket, throwable);
                    continue;
                }
                try {
                    if (!((RemoteCommand)object).checkVersion()) {
                        VersionException versionException = new VersionException((RemoteCommand)object);
                        this.fPrinter.printError(versionException);
                        this.sendObjectAndCloseSocket(socket, versionException);
                    }
                    break block24;
                }
                catch (Throwable throwable) {
                    this.fPrinter.printError(throwable);
                    this.sendObjectAndCloseSocket(socket, throwable);
                }
                continue;
            }
            if (this.fPrint) {
                System.out.println(((MDCSCommand)object).getPreRunDescription());
            }
            try {
                mDCSCommandResults = this.runCommand((MDCSCommand)object);
            }
            catch (Throwable throwable) {
                this.fPrinter.printError(throwable);
                this.sendObjectAndCloseSocket(socket, throwable);
                continue;
            }
            if (this.fPrint && mDCSCommandResults instanceof DisplayableResults) {
                System.out.println(((DisplayableResults)mDCSCommandResults).getPostRunDescription());
            }
            this.sendObjectAndCloseSocket(socket, mDCSCommandResults);
        }
        if (!this.fSsock.isClosed()) {
            try {
                this.fSsock.close();
            }
            catch (Exception exception) {
                this.fPrinter.printError(exception);
            }
        }
        this.fSsock = null;
    }

    public void sendObjectAndCloseSocket(Socket socket, Object object) {
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(socket.getOutputStream());
            objectOutputStream.writeObject(object);
            objectOutputStream.flush();
            socket.close();
        }
        catch (Exception exception) {
            this.fPrinter.printError(new ErrorWhileSendingMessage().getLocalizedMessage(), exception);
        }
    }

    private void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            this.fPrinter.printError(new ErrorWhileClosingSocketMessage().getLocalizedMessage(), iOException);
        }
    }

    protected void createServerSocket() throws Exception {
        try {
            this.fSsock = new ServerSocket(this.fPort);
        }
        catch (BindException bindException) {
            throw new DistcompBindException(this.fPort);
        }
        catch (IOException iOException) {
            throw new PortIOException(iOException, this.fPort);
        }
    }

    private Socket getSocket() throws IOException {
        Socket socket = null;
        this.fSsock.setSoTimeout(1000);
        while (this.shouldListen() && socket == null) {
            try {
                socket = this.fSsock.accept();
            }
            catch (SocketTimeoutException socketTimeoutException) {}
        }
        return socket;
    }

    public MDCSCommand getCommand(Socket socket) throws IOException, InvalidDistcompClassException {
        MDCSCommand mDCSCommand;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(socket.getInputStream());
            mDCSCommand = (MDCSCommand)objectInputStream.readObject();
        }
        catch (InvalidClassException invalidClassException) {
            this.fPrinter.printError(invalidClassException);
            throw new InvalidDistcompClassException(Version.VERSION_STRING);
        }
        catch (ClassNotFoundException classNotFoundException) {
            this.fPrinter.printError(classNotFoundException);
            throw new InvalidDistcompClassException(Version.VERSION_STRING);
        }
        return mDCSCommand;
    }

    public MDCSCommandResults runCommand(MDCSCommand mDCSCommand) throws Exception {
        return mDCSCommand.run();
    }

    public synchronized boolean shouldListen() {
        return this.fShouldListen;
    }

    public synchronized void stopListening() {
        this.fShouldListen = false;
    }

    public synchronized void startListening() {
        this.fShouldListen = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushInputstream(Socket socket) {
        int n = -1;
        try {
            n = socket.getSoTimeout();
            socket.setSoTimeout(1000);
            socket.getInputStream().skip(1000000L);
        }
        catch (Throwable throwable) {
        }
        finally {
            if (n >= 0) {
                try {
                    socket.setSoTimeout(n);
                }
                catch (Throwable throwable) {}
            }
        }
    }

    private static final class ProblemWithProtocolAndVersionMessage
    extends CommandListenerMessage {
        private final BaseMsgID fBaseMsgID = new mjs.ProblemWithProtocolAndVersion();

        ProblemWithProtocolAndVersionMessage() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class ErrorWhileReceivingCommandMessage
    extends CommandListenerMessage {
        private final BaseMsgID fBaseMsgID = new mjs.ErrorWhileReceivingCommand();

        ErrorWhileReceivingCommandMessage() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class ErrorWhileClosingSocketMessage
    extends CommandListenerMessage {
        private final BaseMsgID fBaseMsgID = new mjs.ErrorWhileClosingSocket();

        ErrorWhileClosingSocketMessage() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class ErrorWhileSendingMessage
    extends CommandListenerMessage {
        private final BaseMsgID fBaseMsgID = new mjs.ErrorWhileSending();

        ErrorWhileSendingMessage() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class ListeningOnPortMessage
    extends CommandListenerMessage {
        private final BaseMsgID fBaseMsgID;

        ListeningOnPortMessage(int n) {
            this.fBaseMsgID = new mjs.ListeningOnPort(Integer.toString(n));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class MDCEServiceVersionMessage
    extends CommandListenerMessage {
        private final BaseMsgID fBaseMsgID;

        MDCEServiceVersionMessage(String string) {
            this.fBaseMsgID = new mjs.MDCEServiceVersion(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static abstract class CommandListenerMessage
    extends ControlMessage {
        CommandListenerMessage() {
        }
    }

    private static final class CannotParseLogLevelException
    extends CommandListenerException {
        private final BaseMsgID fBaseMsgID;

        private CannotParseLogLevelException(String string, NumberFormatException numberFormatException) {
            super(numberFormatException);
            this.fBaseMsgID = new mjs.CannotParseLogLevel(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class CannotParsePortNumberException
    extends CommandListenerException {
        private final BaseMsgID fBaseMsgID;

        private CannotParsePortNumberException(String string, NumberFormatException numberFormatException) {
            super(numberFormatException);
            this.fBaseMsgID = new mjs.CannotParsePortNumber(string);
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static final class WrongNumberOfArgumentsException
    extends CommandListenerException {
        private final BaseMsgID fBaseMsgID;

        private WrongNumberOfArgumentsException(String[] stringArray) {
            this.fBaseMsgID = new mjs.WrongNumberOfArguments(Arrays.toString(stringArray));
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }

    private static abstract class CommandListenerException
    extends IllegalArgumentException
    implements I18nMatlabIdentifiedException {
        private final I18nMessageCreator fErrorMessageCreator = new XMLMessageCreator();

        public CommandListenerException() {
        }

        public CommandListenerException(Throwable throwable) {
            super(throwable);
        }

        protected abstract BaseMsgID getFilledMessage();

        protected abstract BaseMsgID getFilledLocalizedMessage();

        @Override
        public String getMessage() {
            return this.fErrorMessageCreator.createMessage(this.getFilledMessage());
        }

        @Override
        public String getLocalizedMessage() {
            return this.fErrorMessageCreator.createLocalizedMessage(this.getFilledLocalizedMessage());
        }

        public String getMessageID() {
            return this.getFilledMessage().getCatalogId() + ":" + this.getFilledMessage().getMessageId();
        }
    }

    public static enum ErrorKey {
        COULD_NOT_ATTACH_TO_PORT,
        INVALID_CLASS,
        INVALID_VERSION,
        INVALID_CLASS_DETAIL,
        INVALID_VERSION_DETAIL,
        PORT_BUSY;

    }

    private static class PortIOException
    extends FormattableException {
        public PortIOException(IOException iOException, int n) {
            super(iOException, (Object)ErrorKey.COULD_NOT_ATTACH_TO_PORT, n);
        }
    }

    private static class DistcompBindException
    extends DistcompDiagnosticException {
        public DistcompBindException(int n) {
            super(new FormattableException(null, (Object)ErrorKey.PORT_BUSY, new Object[0]){}, (Object)ErrorKey.COULD_NOT_ATTACH_TO_PORT, n);
        }
    }

    private static class VersionException
    extends DistcompDiagnosticException {
        public VersionException(RemoteCommand remoteCommand) {
            super(new FormattableException(null, (Object)ErrorKey.INVALID_VERSION_DETAIL, new Object[]{Version.VERSION_STRING, remoteCommand.getVersionString()}){}, (Object)ErrorKey.INVALID_VERSION, new Object[0]);
            this.setRemoteVersionNum(remoteCommand.getVersionNumber());
        }
    }

    private static class InvalidDistcompClassException
    extends DistcompDiagnosticException {
        private InvalidDistcompClassException(String string) {
            super(new FormattableException(null, (Object)ErrorKey.INVALID_CLASS_DETAIL, new Object[]{string}){}, (Object)ErrorKey.INVALID_CLASS, new Object[0]);
        }
    }
}

