/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.distcomp.auth.modules;

import com.mathworks.resource_core.BaseMsgID;
import com.mathworks.resources.parallel.cluster.mjs;
import com.mathworks.toolbox.distcomp.auth.AbstractInvocationWithAuth;
import com.mathworks.toolbox.distcomp.auth.RemoteAuthorisationModule;
import com.mathworks.toolbox.distcomp.auth.credentials.AuthenticationToken;
import com.mathworks.toolbox.distcomp.auth.credentials.UserIdentity;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.ConsumerCreationException;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumer;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerConfig;
import com.mathworks.toolbox.distcomp.auth.credentials.consumer.CredentialConsumerFactory;
import com.mathworks.toolbox.distcomp.auth.credentials.store.CredentialStore;
import com.mathworks.toolbox.distcomp.auth.modules.DialogUnavailableException;
import com.mathworks.toolbox.distcomp.mjs.MJSException;
import java.rmi.RemoteException;

abstract class RemoteAuthorisationModuleImpl
implements RemoteAuthorisationModule {
    private static final long serialVersionUID = -674422513554585262L;
    private final CredentialConsumerConfig fConsumerConfig;
    private transient CredentialConsumerFactory fConsumerFactory = null;

    RemoteAuthorisationModuleImpl(CredentialConsumerConfig credentialConsumerConfig) {
        this.fConsumerConfig = credentialConsumerConfig;
    }

    CredentialConsumerConfig getConsumerConfig() {
        return this.fConsumerConfig;
    }

    @Override
    public <T> T invokeWithAuth(AbstractInvocationWithAuth<T> abstractInvocationWithAuth, CredentialStore<AuthenticationToken> credentialStore) throws RemoteException, MJSException {
        abstractInvocationWithAuth.setInteractive(this.fConsumerFactory.isInteractive());
        return abstractInvocationWithAuth.makeInvocation(credentialStore, this);
    }

    protected CredentialConsumer getConsumer(UserIdentity userIdentity) throws DialogUnavailableException {
        if (this.fConsumerFactory == null) {
            throw new DialogUnavailableException(userIdentity, (Throwable)new NoConsumerFactoryException());
        }
        try {
            return this.fConsumerFactory.create(this.fConsumerConfig);
        }
        catch (ConsumerCreationException consumerCreationException) {
            throw new DialogUnavailableException(userIdentity, (Throwable)consumerCreationException);
        }
    }

    @Override
    public CredentialConsumerFactory getConsumerFactory() {
        return this.fConsumerFactory;
    }

    @Override
    public void setConsumerFactory(CredentialConsumerFactory credentialConsumerFactory) {
        this.fConsumerFactory = credentialConsumerFactory;
    }

    private static final class NoConsumerFactoryException
    extends ConsumerCreationException {
        private final BaseMsgID fBaseMsgID = new mjs.NoConsumerFactory();

        private NoConsumerFactoryException() {
        }

        @Override
        protected BaseMsgID getFilledMessage() {
            return this.fBaseMsgID;
        }

        @Override
        protected BaseMsgID getFilledLocalizedMessage() {
            return this.fBaseMsgID;
        }
    }
}

